/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.errors;

import java.sql.SQLException;
import oracle.dbtools.common.util.PrimitiveTypes;

public class SQLExceptions {
    private static final String ORA_CODE_PREFIX = "ORA-";
    private static final int RECURSIVE_SQL_ERROR = 604;

    public static int getErrorCode(SQLException e) {
        int errorCode = e.getErrorCode();
        if (604 == errorCode) {
            return SQLExceptions.recursiveErrorCause(e);
        }
        return errorCode;
    }

    private static int recursiveErrorCause(SQLException e) {
        String msg = e.getMessage();
        int oraCode = msg.lastIndexOf(ORA_CODE_PREFIX);
        if (oraCode == -1) {
            return e.getErrorCode();
        }
        int colon = msg.indexOf(58, oraCode);
        if (colon == -1) {
            return e.getErrorCode();
        }
        String value = msg.substring(oraCode + ORA_CODE_PREFIX.length(), colon);
        int errorCode = PrimitiveTypes.valueOf(value, Integer.class);
        return errorCode;
    }
}

