/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.activation;

import oracle.dbtools.common.activation.Activatable;
import oracle.dbtools.common.activation.CannotActivateException;
import oracle.dbtools.plugin.api.logging.Log;

public class Activator {
    private final Log log;
    private ActivationStatus status;
    private Object target;

    public Activator(Log log) {
        this(log, null);
    }

    public Activator(Log log, Object target) {
        this.log = log;
        this.target(target);
    }

    private void target(Object target) {
        if (this.target == null) {
            this.target = target;
            this.status = target == null || target instanceof Activatable ? ActivationStatus.DEACTIVATED : ActivationStatus.ACTIVATED;
        } else {
            throw new IllegalStateException();
        }
    }

    public ActivationStatus activate() {
        if (ActivationStatus.DEACTIVATED == this.status) {
            try {
                ((Activatable)this.target).activate();
                this.status = ActivationStatus.ACTIVATED;
                this.log.finest("Activated: " + this.target);
            }
            catch (CannotActivateException e) {
                this.status = ActivationStatus.UNAVAILBLE;
                this.log.info("Cannot Activate: " + this.target);
            }
            catch (RuntimeException e) {
                this.log.severe("Unexpected error when activating: " + this.target);
                this.log.severe((Throwable)e);
            }
        }
        return this.status;
    }

    public ActivationStatus activate(Object target) throws IllegalStateException {
        this.target(target);
        return this.activate();
    }

    public ActivationStatus deactivate() {
        if (ActivationStatus.ACTIVATED == this.status && this.target instanceof Activatable) {
            try {
                ((Activatable)this.target).deactivate();
                this.status = ActivationStatus.DEACTIVATED;
            }
            catch (Throwable t) {
                this.log.warning(t);
            }
        }
        return this.status;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Activator other = (Activator)obj;
        if (this.status != other.status) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    public boolean isActive() {
        return ActivationStatus.ACTIVATED == this.status;
    }

    public ActivationStatus status() {
        return this.status;
    }

    public Object target() throws IllegalStateException {
        return this.target;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Activator [status=");
        builder.append((Object)this.status);
        if (this.target != null) {
            builder.append(", target=");
            builder.append(this.target);
        }
        builder.append("]");
        return builder.toString();
    }

    public static enum ActivationStatus {
        ACTIVATED,
        DEACTIVATED,
        UNAVAILBLE;

    }
}

