/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms.xkrss;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.c14n.XMLC14NWithComments;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.xkms.util.XKMSInitializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Authentication
extends XMLElement {
    public Authentication(Element element) throws DOMException {
        super(element);
    }

    public Authentication(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2002/03/xkms#", "Authentication");
    }

    public Authentication(Document owner, String systemId) throws DOMException {
        super(owner, "http://www.w3.org/2002/03/xkms#", "Authentication", systemId);
    }

    public void setKeyBindingAuthentication(XSSignature signature) throws DOMException {
        Element kiElement = null;
        try {
            byte[] kiBytes = new XMLC14NWithComments().canonicalize(signature.getNode());
            Document kiDoc = XMLUtils.createDocBuilder().parse(new ByteArrayInputStream(kiBytes));
            kiElement = kiDoc.getDocumentElement();
        }
        catch (CanonicalizationException ex) {
            throw new DOMException(11, "Error canonicalizing dsig:Signature");
        }
        catch (IOException ex) {
            throw new DOMException(11, "Error reading dsig:Signature");
        }
        catch (SAXException ex) {
            throw new DOMException(11, "Error parsing dsig:Signature");
        }
        XSSignature ki = new XSSignature((Element)this.getOwnerDocument().importNode(kiElement, true));
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"KeyBindingAuthentication", (String)"http://www.w3.org/2002/03/xkms#");
        Element u = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "KeyBindingAuthentication");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)u);
        u.appendChild(ki.getNode());
        NodeList nList = this.getNode().getChildNodes();
        if (nList.getLength() == 0) {
            ((Element)this.getNode()).appendChild(u);
        } else {
            ((Element)this.getNode()).insertBefore(u, nList.item(0));
        }
    }

    public XSSignature getKeyBindingAuthentication() {
        Element sigVal;
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "KeyBindingAuthentication");
        if (nList.getLength() != 0 && (sigVal = (Element)((Element)nList.item(0)).getFirstChild()) != null) {
            return new XSSignature(sigVal);
        }
        return null;
    }

    public void setNotBoundAuthentication(String protocol, byte[] value) throws DOMException {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"NotBoundAuthentication", (String)"http://www.w3.org/2002/03/xkms#");
        Element u = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "NotBoundAuthentication");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)u);
        u.setAttribute("Protocol", protocol);
        u.setAttribute("Value", Base64.toBase64((byte[])value, (boolean)false));
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "KeyBindingAuthentication");
        int len = nList.getLength();
        if (len > 1) {
            throw new DOMException(11, "More than 1 xkms:KeyBindingAuthentication detected");
        }
        Node sibling = this.getNode().getFirstChild();
        if (len == 1) {
            sibling = nList.item(0).getNextSibling();
        }
        if (sibling == null) {
            ((Element)this.getNode()).appendChild(u);
        } else {
            ((Element)this.getNode()).insertBefore(u, sibling);
        }
    }

    public String getNotBoundAuthenticationProtocol() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "NotBoundAuthentication");
        if (nList.getLength() != 0) {
            Element u = (Element)nList.item(0);
            return u.getAttribute("Protocol");
        }
        return null;
    }

    public byte[] getNotBoundAuthenticationValue() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "NotBoundAuthentication");
        if (nList.getLength() != 0) {
            Element u = (Element)nList.item(0);
            return Base64.fromBase64((String)u.getAttribute("Value"));
        }
        return null;
    }

    static {
        XKMSInitializer.initialize();
    }
}

