/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms;

import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.xkms.util.XKMSInitializer;
import oracle.security.xmlsec.xkms.util.XKMSUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Status
extends XMLElement {
    public Status(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2002/03/xkms#", "Status");
    }

    public Status(Document owner, String systemId) throws DOMException {
        super(owner, "http://www.w3.org/2002/03/xkms#", "Status", systemId);
    }

    public Status(Element element) throws DOMException {
        super(element);
    }

    public void setStatusValue(String statusVal) throws DOMException {
        this.setAttribute("StatusValue", statusVal);
    }

    public String getStatusValue() {
        if (this.hasAttribute("StatusValue")) {
            return this.getAttribute("StatusValue");
        }
        return null;
    }

    public void addValidReason(String value) throws DOMException {
        Element s = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "ValidReason");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)s);
        s.appendChild(this.getOwnerDocument().createTextNode(value));
        XKMSUtils.insertChild((Element)this.getNode(), s, new String[]{"ValidReason"}, new String[]{"http://www.w3.org/2002/03/xkms#"});
    }

    public List getValidReasons() {
        ArrayList<String> v = new ArrayList<String>();
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "ValidReason");
        int x = nList.getLength();
        for (int i = 0; i < x; ++i) {
            Element k = (Element)nList.item(i);
            Text kText = (Text)k.getFirstChild();
            if (kText == null) continue;
            v.add(kText.getData());
        }
        return v;
    }

    public void addIndeterminateReason(String value) throws DOMException {
        Element s = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "IndeterminateReason");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)s);
        s.appendChild(this.getOwnerDocument().createTextNode(value));
        XKMSUtils.insertChild((Element)this.getNode(), s, new String[]{"ValidReason", "IndeterminateReason"}, new String[]{"http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
    }

    public List getIndeterminateReasons() {
        ArrayList<String> v = new ArrayList<String>();
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "IndeterminateReason");
        int x = nList.getLength();
        for (int i = 0; i < x; ++i) {
            Element k = (Element)nList.item(i);
            Text kText = (Text)k.getFirstChild();
            if (kText == null) continue;
            v.add(kText.getData());
        }
        return v;
    }

    public void addInvalidReason(String value) throws DOMException {
        Element s = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "InvalidReason");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)s);
        s.appendChild(this.getOwnerDocument().createTextNode(value));
        XKMSUtils.insertChild((Element)this.getNode(), s, new String[]{"ValidReason", "IndeterminateReason", "InvalidReason"}, new String[]{"http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
    }

    public List getInvalidReasons() {
        ArrayList<String> v = new ArrayList<String>();
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "InvalidReason");
        int x = nList.getLength();
        for (int i = 0; i < x; ++i) {
            Element k = (Element)nList.item(i);
            Text kText = (Text)k.getFirstChild();
            if (kText == null) continue;
            v.add(kText.getData());
        }
        return v;
    }

    static {
        XKMSInitializer.initialize();
    }
}

