/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms;

import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.xkms.util.XKMSInitializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class OpaqueClientData
extends XMLElement {
    public OpaqueClientData(Element element) throws DOMException {
        super(element);
    }

    public OpaqueClientData(Document owner) throws DOMException {
        super(owner, "http://www.w3.org/2002/03/xkms#", "OpaqueClientData");
        this.addNSPrefixAttr(XMLElement.getDefaultNSPrefix((String)"http://www.w3.org/2002/03/xkms#"), "http://www.w3.org/2002/03/xkms#");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2002/03/xkms#");
    }

    public void addOpaqueData(byte[] data) throws DOMException {
        Element s = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "OpaqueData");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)s);
        s.appendChild(this.getOwnerDocument().createTextNode(Base64.toBase64((byte[])data, (boolean)false)));
        this.appendChild(s);
    }

    public NodeList getOpaqueDataElements() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "OpaqueData");
        if (nList.getLength() != 0) {
            return nList;
        }
        return null;
    }

    public List getOpaqueDatas() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "OpaqueData");
        ArrayList<byte[]> list = null;
        int size = nList.getLength();
        if (size != 0) {
            list = new ArrayList<byte[]>(size);
            for (int i = 0; i < size; ++i) {
                Element s = (Element)nList.item(i);
                s.normalize();
                Text sText = (Text)s.getFirstChild();
                if (sText == null) continue;
                byte[] od = Base64.fromBase64((String)sText.getData());
                list.add(od);
            }
        }
        return list;
    }

    static {
        XKMSInitializer.initialize();
    }
}

