/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.xkms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.c14n.XMLC14NWithComments;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.xkms.util.XKMSInitializer;
import oracle.security.xmlsec.xkms.util.XKMSUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public abstract class AbstractKeyBinding
extends XMLElement {
    public AbstractKeyBinding(Document owner, String tagName) throws DOMException {
        super(owner, "http://www.w3.org/2002/03/xkms#", tagName);
    }

    public AbstractKeyBinding(Document owner, String tagName, String systemId) throws DOMException {
        super(owner, "http://www.w3.org/2002/03/xkms#", tagName, systemId);
    }

    public AbstractKeyBinding(Element element) throws DOMException {
        super(element);
    }

    public void addKeyUsage(String keyUsage) throws DOMException {
        if (keyUsage == null) {
            return;
        }
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "KeyUsage");
        if (nList.getLength() > 2) {
            throw new DOMException(11, "xkms:KeyUsage - Exceeded maxOccurs of 3");
        }
        Element k = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "KeyUsage");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)k);
        k.appendChild(this.getOwnerDocument().createTextNode(keyUsage));
        XKMSUtils.insertChild((Element)this.getNode(), k, new String[]{"KeyInfo", "KeyUsage"}, new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2002/03/xkms#"});
    }

    public void addUseKeyWith(String application, String identifier) throws DOMException {
        Element pn = this.getOwnerDocument().createElementNS("http://www.w3.org/2002/03/xkms#", "UseKeyWith");
        XMLUtils.copyNSPrefix((Element)((Element)this.node), (Element)pn);
        pn.setAttribute("Application", application);
        pn.setAttribute("Identifier", identifier);
        XKMSUtils.insertChild((Element)this.getNode(), pn, new String[]{"KeyInfo", "KeyUsage", "UseKeyWith"}, new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2002/03/xkms#", "http://www.w3.org/2002/03/xkms#"});
    }

    public XSKeyInfo getKeyInfo() {
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        if (nList.getLength() != 0) {
            return new XSKeyInfo((Element)nList.item(0));
        }
        return null;
    }

    public List getKeyUsages() {
        ArrayList<String> v = new ArrayList<String>();
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "KeyUsage");
        int x = nList.getLength();
        for (int i = 0; i < x; ++i) {
            Element k = (Element)nList.item(i);
            Text kText = (Text)k.getFirstChild();
            if (kText == null) continue;
            v.add(kText.getData());
        }
        return v;
    }

    public List getUseKeyWithApplications() {
        ArrayList<String> v = new ArrayList<String>();
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "UseKeyWith");
        int x = nList.getLength();
        for (int i = 0; i < x; ++i) {
            Element u = (Element)nList.item(i);
            v.add(u.getAttribute("Application"));
        }
        return v;
    }

    public List getUseKeyWithIdentifiers() {
        ArrayList<String> v = new ArrayList<String>();
        NodeList nList = this.getChildElementsByTagNameNS("http://www.w3.org/2002/03/xkms#", "UseKeyWith");
        int x = nList.getLength();
        for (int i = 0; i < x; ++i) {
            Element u = (Element)nList.item(i);
            v.add(u.getAttribute("Identifier"));
        }
        return v;
    }

    public void setID(String id) throws DOMException {
        this.setAttribute("Id", id);
    }

    public String getID() {
        if (this.hasAttribute("Id")) {
            return this.getAttribute("Id");
        }
        return null;
    }

    public void setKeyInfo(XSKeyInfo keyInfo) throws DOMException {
        Element kiElement = null;
        try {
            byte[] kiBytes = new XMLC14NWithComments().canonicalize(keyInfo.getNode());
            Document kiDoc = XMLUtils.createDocBuilder().parse(new ByteArrayInputStream(kiBytes));
            kiElement = kiDoc.getDocumentElement();
        }
        catch (CanonicalizationException ex) {
            throw new DOMException(11, "dsig:KeyInfo - Error canonicalizing KeyInfo element");
        }
        catch (IOException ex) {
            throw new DOMException(11, "dsig:KeyInfo - Error reading KeyInfo element");
        }
        catch (SAXException ex) {
            throw new DOMException(11, "dsig:KeyInfo - Error parsing KeyInfo element");
        }
        XSKeyInfo ki = new XSKeyInfo((Element)this.getOwnerDocument().importNode(kiElement, true));
        NodeList nList = ((Element)this.getNode()).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        int len = nList.getLength();
        Node firstChild = this.getNode().getFirstChild();
        if (len == 0) {
            if (firstChild == null) {
                this.getNode().appendChild(ki.getNode());
            } else {
                this.getNode().insertBefore(ki.getNode(), firstChild);
            }
        } else if (len == 1) {
            this.getNode().replaceChild(ki.getNode(), firstChild);
        } else {
            throw new DOMException(11, "dsig:KeyInfo - Error exceeded maxOccurs = 1");
        }
    }

    static {
        XKMSInitializer.initialize();
    }
}

