/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.share;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.share.ReverseListIterator;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.logging.LogUtils;

public abstract class AbstractTransactionMediator {
    private final Map _tokenToInfo = new HashMap();
    private static final Logger _LOGGER = Logger.getLogger(AbstractTransactionMediator.class.getName());

    public final TransactionToken createToken() {
        return new TransactionTokenImpl();
    }

    public final void commitTransaction(TransactionToken token) {
        if (token.isAbortOnCompletion()) {
            this.rollbackTransaction(token);
            return;
        }
        Info info = this._getAndRemoveInfo(token);
        this._txnLog("commit", token, info);
        if (info == null) {
            return;
        }
        if (info.edits.size() == 1) {
            assert (info.documents.size() == 1);
            this._deliverOneEdit(info.documents.iterator().next(), (UndoableEdit)info.edits.get(0));
        } else {
            this._deliverMultipleEdits(token, info);
        }
    }

    public final void rollbackTransaction(TransactionToken token) {
        Info info = this._getAndRemoveInfo(token);
        this._txnLog("rollback", token, info);
        if (info == null) {
            return;
        }
        Iterator itor = ReverseListIterator.getIterator(info.edits, false);
        while (itor.hasNext()) {
            UndoableEdit edit = (UndoableEdit)itor.next();
            try {
                if (_LOGGER.isLoggable(Level.FINER)) {
                    _LOGGER.log(Level.FINER, "Undo of edit {0} during rollback of transaction {1}", new Object[]{edit, token});
                }
                edit.undo();
            }
            catch (Throwable t) {
                LogUtils.log((Logger)_LOGGER, (Level)Level.WARNING, (String)"Exception executing undo of edit {0} during rollback of transaction {1}", (Object[])new Object[]{edit, token}, (Throwable)t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
    }

    protected void addEditImpl(TransactionToken token, Object doc, UndoableEdit edit) {
        if (token == null) {
            this._deliverOneEdit(doc, edit);
        } else {
            if (((TransactionTokenImpl)token).__isDispatched()) {
                throw new IllegalStateException("token already used! " + token);
            }
            this._bufferOneEdit(token, doc, edit);
        }
    }

    protected abstract void deliverMultipleEditsImpl(TransactionToken var1, Info var2);

    protected abstract void deliverOneEditImpl(Object var1, UndoableEdit var2);

    private void _txnLog(String desc, TransactionToken token, Info info) {
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "About to {0}: token={1} numEdits={2}", new Object[]{desc, token, info == null ? "0" : String.valueOf(info.edits.size())});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Info _getAndRemoveInfo(TransactionToken token) {
        if (token == null) {
            return null;
        }
        ((TransactionTokenImpl)token).__setDispatched();
        Map map = this._tokenToInfo;
        synchronized (map) {
            Info ret = (Info)this._tokenToInfo.remove(token);
            assert (ret == null || ret.edits.size() > 0);
            return ret;
        }
    }

    private void _deliverMultipleEdits(TransactionToken token, Info info) {
        _LOGGER.log(Level.FINER, "Dispatching multiple edits: token={0}", token);
        this.deliverMultipleEditsImpl(token, info);
    }

    private void _deliverOneEdit(Object doc, UndoableEdit edit) {
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Dispatching single edit: doc={0} edit={1}", new Object[]{doc, edit});
        }
        this.deliverOneEditImpl(doc, edit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _bufferOneEdit(TransactionToken token, Object doc, UndoableEdit edit) {
        if (_LOGGER.isLoggable(Level.FINER)) {
            _LOGGER.log(Level.FINER, "Buffering edit: token={0} doc={1} edit={2}", new Object[]{token, doc, edit});
        }
        assert (token != null);
        Map map = this._tokenToInfo;
        synchronized (map) {
            Info info = (Info)this._tokenToInfo.get(token);
            if (info == null) {
                info = new Info();
                this._tokenToInfo.put(token, info);
            }
            info.add(doc, edit);
        }
    }

    private class TransactionTokenImpl
    extends TransactionToken {
        private String _name;
        private boolean _abortOnCompletion = false;
        private WeakReference _ownerRef;
        private boolean _dispatched = false;

        private TransactionTokenImpl() {
        }

        @Override
        public synchronized Object getOwner() {
            if (this._ownerRef == null) {
                return null;
            }
            return this._ownerRef.get();
        }

        @Override
        public synchronized String getName() {
            return this._name;
        }

        @Override
        public synchronized void setNameIfUnset(String name) {
            if (this._name == null) {
                this._name = name;
            }
        }

        @Override
        public synchronized void setOwnerIfUnset(Object owner) {
            if (this._ownerRef == null) {
                this._ownerRef = new WeakReference<Object>(owner);
            }
        }

        @Override
        public synchronized void setAbortOnCompletion() {
            this._abortOnCompletion = true;
        }

        @Override
        public synchronized boolean isAbortOnCompletion() {
            return this._abortOnCompletion;
        }

        @Override
        public synchronized void dispatch(Object ifOwner, boolean isCommit) {
            if (ifOwner == this.getOwner()) {
                if (isCommit) {
                    AbstractTransactionMediator.this.commitTransaction(this);
                } else {
                    AbstractTransactionMediator.this.rollbackTransaction(this);
                }
            }
        }

        synchronized boolean __isDispatched() {
            return this._dispatched;
        }

        synchronized void __setDispatched() {
            this._dispatched = true;
        }
    }

    protected static class Info {
        public final Set documents = new HashSet(7);
        public final List edits = new ArrayList(10);

        protected Info() {
        }

        public void add(Object doc, UndoableEdit edit) {
            this.documents.add(doc);
            this.edits.add(edit);
        }
    }
}

