/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.view;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.view.FilteredView;
import org.w3c.dom.Node;

public abstract class AbstractMultipleRootFilteredView
extends FilteredView {
    private Set _roots = null;
    private final Map _cache = new HashMap();
    private static final Short _ACCEPT = 1;
    private static final Short _SKIP = 3;

    protected abstract Set updateRootNodes(XmlModelEvent var1, Set var2);

    protected short acceptNodeInSubtree(Node modelNode) {
        return 1;
    }

    @Override
    protected XmlModelEvent transformModelEventHook(XmlModelEvent modelChangeEvent) {
        if (modelChangeEvent.isDomTreeChanged()) {
            Set oldRoots = this._roots;
            this._roots = this.updateRootNodes(modelChangeEvent, oldRoots);
            if (!this._equal(oldRoots, this._roots) || modelChangeEvent.isDomStructureChanged()) {
                this._clearCache();
            }
        }
        return super.transformModelEventHook(modelChangeEvent);
    }

    @Override
    protected final short acceptNode(Node modelNode) {
        if (DomUtils.isDocument((Node)modelNode)) {
            return 1;
        }
        if (this._roots == null) {
            return 2;
        }
        short initialRet = this._acceptNodeUnderSubtree(modelNode);
        if (initialRet != 1 || this._isRootOrDocNode(modelNode)) {
            return initialRet;
        }
        return this.acceptNodeInSubtree(modelNode);
    }

    protected boolean isPossibleNewleyCreatedRoot(Node node) {
        return false;
    }

    @Override
    protected void baseModelAttached() {
        super.baseModelAttached();
        this._roots = this.updateRootNodes(null, this._roots);
        this._clearCache();
    }

    static boolean __isDecendentOfRootNode(Set roots, Node node) {
        for (Node root : roots) {
            if (!DomUtils.isDescendant((Node)node, (Node)root)) continue;
            return true;
        }
        return false;
    }

    private boolean _isRootOrDocNode(Node node) {
        return node.getNodeType() == 9 || this._roots != null && this._roots.contains(node);
    }

    private boolean _equal(Set a1, Set a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 != null && a2 != null) {
            return a1.equals(a2);
        }
        return false;
    }

    private short _acceptNodeUnderSubtree(Node node) {
        short ret;
        Short cached = (Short)this._cache.get(node);
        short s = ret = cached != null ? (short)cached : (short)-1;
        if (ret == -1) {
            ret = this._isRootOrDocNode(node) ? _ACCEPT : (this._isAncestorOfRootNode(node) ? _SKIP : (AbstractMultipleRootFilteredView.__isDecendentOfRootNode(this._roots, node) ? _ACCEPT : (this.isPossibleNewleyCreatedRoot(node) ? _ACCEPT.shortValue() : _SKIP.shortValue())));
            this._cache.put(node, ret);
        }
        return ret;
    }

    private boolean _isAncestorOfRootNode(Node node) {
        for (Node root : this._roots) {
            if (!DomUtils.isDescendant((Node)root, (Node)node)) continue;
            return true;
        }
        return false;
    }

    private void _clearCache() {
        this._cache.clear();
    }
}

