/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.id.xsd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.SimpleType;
import oracle.bali.xml.grammar.util.TypeUtils;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.id.IdGenerationContext;
import oracle.bali.xml.model.id.Scope;
import oracle.bali.xml.model.id.ScopedIdLocation;
import oracle.bali.xml.model.id.base.BaseIdGenerationPlugin;
import org.w3c.dom.Element;

public class XsdIdGenerationPlugin
extends BaseIdGenerationPlugin {
    protected static final String XSD_ID_SCOPE_IDENTIFIER = "xsd-id-document-scope";

    @Override
    public List<ScopedIdLocation> getScopedIdLocations(IdGenerationContext context, Element element) {
        ArrayList<ScopedIdLocation> foundLocations = null;
        XmlModel model = context.getModel();
        XmlMetadataResolver xmlMetadataResolver = model.getXmlMetadataResolver();
        ElementDef elementDef = (ElementDef)xmlMetadataResolver.getGrammarComponent(element);
        if (elementDef != null) {
            for (Object attributeDefObject : elementDef.getAttributeDefs()) {
                AttributeDef attributeDef = (AttributeDef)attributeDefObject;
                SimpleType simpleType = attributeDef.getType();
                if (simpleType == null || !TypeUtils.isIdType((SimpleType)simpleType)) continue;
                if (foundLocations == null) {
                    foundLocations = new ArrayList<ScopedIdLocation>(1);
                }
                Scope scope = Scope.findOrCreateDocumentRootedScope(context, XSD_ID_SCOPE_IDENTIFIER);
                ScopedIdLocation location = ScopedIdLocation.createAttrLocation(scope, element, attributeDef.getQualifiedName());
                foundLocations.add(location);
            }
        }
        if (foundLocations == null) {
            return Collections.emptyList();
        }
        return foundLocations;
    }
}

