/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.id.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.xml.dom.CustomizationLayer;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.id.IdGenerationContext;
import oracle.bali.xml.model.id.IdGenerationPlugin;
import oracle.bali.xml.model.id.Scope;
import oracle.bali.xml.model.id.ScopedIdLocation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseIdGenerationPlugin
extends IdGenerationPlugin {
    private static final String _ALREADY_SCANNED_DOCUMENT = "base-id-gen-already-scanned-document";
    private static final String _NEXT_UNIQUE_ID_SUFFIXES_MAP_KEY = "next-unique-id-suffixes";
    protected static final String ATTR_ID_SCOPE_IDENTIFIER = "attr-id-document-scope";
    private static final String DEFAULT_UNIQUE_ID_PREFIX = "__";

    @Override
    public void recordExistingIdsInScope(IdGenerationContext context, Scope scope) {
        if (context.getProperty(_ALREADY_SCANNED_DOCUMENT) == null) {
            Document document = context.getModel().getDocument();
            Element root = document.getDocumentElement();
            if (root != null) {
                this._recordExistingIdsInScopeHelper(context, root);
            }
            context.putProperty(_ALREADY_SCANNED_DOCUMENT, Boolean.TRUE);
        }
    }

    @Override
    public boolean shouldReplaceExistingId(IdGenerationContext context, ScopedIdLocation scopedIdLocation, String existingValue, boolean conflictsWithExistingId) {
        return conflictsWithExistingId;
    }

    @Override
    public String generateUniqueId(IdGenerationContext context, ScopedIdLocation scopedIdLocation) {
        boolean uniqueIdFound = false;
        String existingValue = scopedIdLocation.getValue();
        String uniqueIdPrefix = existingValue != null && existingValue.length() > 0 && this.shouldReplaceExistingId(context, scopedIdLocation, existingValue, context.isUsedInScope(scopedIdLocation.getScope(), existingValue)) ? this.getUniqueIdPrefixForExistingId(context, scopedIdLocation) : this.getUniqueIdPrefix(context, scopedIdLocation);
        while (!uniqueIdFound) {
            int nextUniqueIdSuffix = this._getNextUniqueIdSuffixesMap(context).containsKey(uniqueIdPrefix) ? this._getNextUniqueIdSuffixesMap(context).get(uniqueIdPrefix) : 1;
            this._getNextUniqueIdSuffixesMap(context).put(uniqueIdPrefix, nextUniqueIdSuffix + 1);
            String potentialUniqueId = uniqueIdPrefix + nextUniqueIdSuffix;
            if (context.isUsedInScope(scopedIdLocation.getScope(), potentialUniqueId)) continue;
            uniqueIdFound = true;
            return potentialUniqueId;
        }
        return null;
    }

    protected String getUniqueIdPrefixForExistingId(IdGenerationContext context, ScopedIdLocation scopedIdLocation) {
        String currentId = scopedIdLocation.getValue();
        if (currentId.length() > 0 && context.isUsedInScope(scopedIdLocation.getScope(), scopedIdLocation.getValue())) {
            return this.getUniqueIdPrefix(context, scopedIdLocation) + BaseIdGenerationPlugin.stripUniqueIdSuffix(context, scopedIdLocation);
        }
        return null;
    }

    protected String getUniqueIdPrefix(IdGenerationContext context, ScopedIdLocation scopedIdLocation) {
        Object uniqueIdPrefix = null;
        CustomizationLayer tipCustomizationLayer = context.getModel().getTipCustomizationLayer();
        uniqueIdPrefix = tipCustomizationLayer != null ? tipCustomizationLayer.getSuggestedIdPrefix() + "_" : this.getDefaultUniqueIdPrefix(context, scopedIdLocation);
        return uniqueIdPrefix;
    }

    private void _recordExistingIdsInScopeHelper(IdGenerationContext context, Element current) {
        if (context.getElementsInNewSubtrees().contains(current)) {
            return;
        }
        List<ScopedIdLocation> scopedIdLocations = this.getScopedIdLocations(context, current);
        for (ScopedIdLocation scopedIdLocation : scopedIdLocations) {
            context.recordKnownScope(scopedIdLocation.getScope());
            String existingValue = scopedIdLocation.getValue();
            if (existingValue == null) continue;
            context.recordUsedId(scopedIdLocation.getScope(), existingValue);
        }
        for (Node child = current.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!DomUtils.isElement((Node)child)) continue;
            this._recordExistingIdsInScopeHelper(context, (Element)child);
        }
    }

    protected String getDefaultUniqueIdPrefix(IdGenerationContext context, ScopedIdLocation scopedIdLocation) {
        return DEFAULT_UNIQUE_ID_PREFIX;
    }

    protected BaseIdGenerationPlugin() {
    }

    protected static void addAttrWithNameBasedId(String attrIdName, IdGenerationContext context, List<ScopedIdLocation> foundLocations, XmlMetadataResolver xmlMetadataResolver, Element element) {
        AttributeDef attributeDef;
        ElementDef elementDef = (ElementDef)xmlMetadataResolver.getGrammarComponent(element);
        if (elementDef != null && (attributeDef = elementDef.getAttributeDefByName(attrIdName)) != null) {
            if (foundLocations == null) {
                foundLocations = new ArrayList<ScopedIdLocation>(1);
            }
            Scope scope = Scope.findOrCreateDocumentRootedScope(context, ATTR_ID_SCOPE_IDENTIFIER);
            ScopedIdLocation location = ScopedIdLocation.createAttrLocation(scope, element, attributeDef.getQualifiedName());
            foundLocations.add(location);
        }
    }

    protected static String stripUniqueIdSuffix(IdGenerationContext context, ScopedIdLocation scopedIdLocation) {
        int i;
        String currentIdValue = scopedIdLocation.getValue();
        for (i = currentIdValue.length() - 1; i >= 0 && Character.isDigit(currentIdValue.charAt(i)); --i) {
        }
        if (i > 0) {
            return currentIdValue.substring(0, i + 1);
        }
        return currentIdValue;
    }

    private Map<String, Integer> _getNextUniqueIdSuffixesMap(IdGenerationContext context) {
        HashMap map = (HashMap)context.getProperty(_NEXT_UNIQUE_ID_SUFFIXES_MAP_KEY);
        if (map == null) {
            map = new HashMap();
            context.putProperty(_NEXT_UNIQUE_ID_SUFFIXES_MAP_KEY, map);
        }
        return map;
    }
}

