/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.id;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.id.IdGenerationContext;
import oracle.bali.xml.model.id.IdGenerationPlugin;
import oracle.bali.xml.model.id.Scope;
import oracle.bali.xml.model.id.ScopedIdLocation;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import org.w3c.dom.Element;

public final class IdGenerationTask {
    private static final Logger _sLogger = Logger.getLogger(IdGenerationTask.class.getName());

    public static final boolean run(final IdGenerationContext context, final IdGenerationPlugin plugin) {
        if (context == null) {
            throw new IllegalArgumentException("UniqueIdGenerationTask.run called with null context parameter");
        }
        if (plugin == null) {
            throw new IllegalArgumentException("UniqueIdGenerationTask.run called with null plugin parameter");
        }
        FixedNameTransactionTask task = new FixedNameTransactionTask("Add Unique Ids"){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                IdGenerationTask._processNewElements(context, plugin);
            }
        };
        boolean success = false;
        try {
            success = task.runThrowingXCE(context.getModel());
        }
        catch (XmlCommitException e) {
            _sLogger.log(Level.WARNING, "UniqueIdGenerationTask failed with XmlCommitException", e);
        }
        catch (RuntimeException re) {
            _sLogger.log(Level.SEVERE, "UniqueIdGenerationTask failed with unexpected RuntimeException", re);
        }
        return success;
    }

    private static void _processNewElements(IdGenerationContext context, IdGenerationPlugin plugin) throws XmlCommitException {
        Set<Element> newElements = context.getElementsInNewSubtrees();
        for (Element newElement : newElements) {
            IdGenerationTask._processNewElement(context, plugin, newElement);
        }
    }

    private static void _processNewElement(IdGenerationContext context, IdGenerationPlugin plugin, Element newElement) throws XmlCommitException {
        List<ScopedIdLocation> idLocations = plugin.getScopedIdLocations(context, newElement);
        for (ScopedIdLocation idLocation : idLocations) {
            String existingValue;
            Scope scope = idLocation.getScope();
            if (context.recordKnownScope(idLocation.getScope())) {
                plugin.recordExistingIdsInScope(context, scope);
            }
            if ((existingValue = idLocation.getValue()) == null || plugin.shouldReplaceExistingId(context, idLocation, existingValue, context.isUsedInScope(scope, existingValue))) {
                String newId = plugin.generateUniqueId(context, idLocation);
                idLocation.setValue(context.getModel(), newId);
                context.recordUsedId(scope, newId);
                continue;
            }
            context.recordUsedId(scope, existingValue);
        }
    }
}

