/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.category;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import oracle.bali.xml.model.category.CategoryDefinition;

public final class MutableCategoryDefinition
extends CategoryDefinition {
    private String _displayName;
    private String _description = null;
    private Icon _smallIcon = null;
    private int _displayOrder = -1;
    private float _preferredPageRank = -1.0f;
    private boolean _openByDefault;
    private Map<String, CategoryDefinition> _subCategoryMap = null;

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    public Icon getSmallIcon() {
        return this._smallIcon;
    }

    public void setSmallIcon(Icon smallIcon) {
        this._smallIcon = smallIcon;
    }

    @Override
    public int getDisplayOrder() {
        return this._displayOrder;
    }

    public void setDisplayOrder(String displayOrder) {
        try {
            this._displayOrder = Integer.valueOf(displayOrder.trim());
        }
        catch (NumberFormatException e) {
            this._displayOrder = -1;
        }
    }

    @Override
    public float getPreferredPageRank() {
        return this._preferredPageRank;
    }

    public void setPreferredPageRank(String preferredPageRank) {
        try {
            this._preferredPageRank = Float.valueOf(preferredPageRank.trim()).floatValue();
        }
        catch (NumberFormatException e) {
            this._preferredPageRank = -1.0f;
        }
    }

    @Override
    public boolean getOpenByDefault() {
        return this._openByDefault;
    }

    public void setOpenByDefault(String openByDefault) {
        this._openByDefault = "true".equalsIgnoreCase(openByDefault);
    }

    @Override
    public Iterator<CategoryDefinition> getSubCategoryDefinitions() {
        if (this._subCategoryMap == null) {
            return Collections.emptyList().iterator();
        }
        return this._subCategoryMap.values().iterator();
    }

    @Override
    public CategoryDefinition getSubCategoryDefinition(String identifier) {
        if (this._subCategoryMap == null) {
            return null;
        }
        return this._subCategoryMap.get(identifier);
    }

    public void addSubCategoryDefinition(CategoryDefinition subCategory) {
        if (subCategory != null) {
            if (this._subCategoryMap == null) {
                this._subCategoryMap = new LinkedHashMap<String, CategoryDefinition>();
            }
            this._subCategoryMap.put(subCategory.getIdentifier(), subCategory);
        }
    }

    @Override
    protected String getDisplayNameImpl() {
        return this._displayName;
    }

    protected MutableCategoryDefinition(String identifier) {
        super(identifier);
    }
}

