/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.annotation;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.util.JavaTypeManager;
import oracle.bali.xml.grammar.util.SimpleTypeConverter;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.XmlMetadataConstants;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import oracle.bali.xml.model.annotation.AnnotationModel;
import oracle.bali.xml.model.annotation.AnnotationProvider;
import org.w3c.dom.Node;

public class AnnotationMetadataResolver {
    private static final Map<String, Object> _DEFAULT_IMPLICIT_OBJECTS = Collections.emptyMap();
    private MetadataProvider _metadataProvider = null;

    public AnnotationMetadataResolver(MetadataProvider annotationMetadataProvider) {
        if (annotationMetadataProvider == null) {
            throw new IllegalArgumentException("AnnotationMetadataResolver:  null MetadataProvider passed to constructor");
        }
        this._metadataProvider = annotationMetadataProvider;
    }

    public final List<URL> getAnnotationPropertyFormLayouts(AnnotationProvider provider, Node associatedNode) {
        return this.getAnnotationPropertyFormLayoutsImpl(provider, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final int getDisplayOrder(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getDisplayOrderImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final String getDisplayValue(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getDisplayValueImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final boolean isExpert(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.isExpertImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final String getGroup(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getGroupImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final String getHelpTopic(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getHelpTopicImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final boolean isHidden(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.isHiddenImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final String getJavaType(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getJavaTypeImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final boolean isPreferred(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.isPreferredImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final Object getPropertyEditor(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getPropertyEditorImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final boolean isRequired(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.isRequiredImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final String getShortDescription(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getShortDescriptionImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final String getShortDisplayName(QualifiedName annotationPropertyName, Node associatedNode) {
        return this.getShortDisplayNameImpl(annotationPropertyName, associatedNode, _DEFAULT_IMPLICIT_OBJECTS);
    }

    public final boolean isValueModifable(AnnotationModel annotationModel, AnnotationProvider annotationProvider, QualifiedName annotationPropertyName, Node associatedNode) {
        return this.isValueModifableImpl(annotationModel, annotationProvider, annotationPropertyName, associatedNode);
    }

    public final String getBundleNameForLayoutFile(AnnotationProvider provider, Node associatedNode, URL layoutFile) {
        return this.getBundleNameForLayoutFileImpl(provider, associatedNode, layoutFile, _DEFAULT_IMPLICIT_OBJECTS);
    }

    protected List<URL> getAnnotationPropertyFormLayoutsImpl(AnnotationProvider provider, Node associatedNode, Map<String, Object> implicitObjects) {
        Set<URL> set = this._getLayoutUrls();
        return Arrays.asList(set.toArray(new URL[0]));
    }

    protected String getBundleNameForLayoutFileImpl(AnnotationProvider provider, Node associatedNode, URL layoutFile, Map<String, Object> implicitObjects) {
        String bundle = null;
        Map<QualifiedName, String> map = this._getLayoutUrlsAndProperties(layoutFile);
        if (map != null) {
            bundle = map.get(QualifiedName.getQualifiedName(null, (String)"bundle"));
        }
        return bundle;
    }

    protected int getDisplayOrderImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        Object rawValue = this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.DISPLAY_ORDER);
        return this.convertToInt(rawValue, -1);
    }

    protected String getDisplayValueImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        return (String)this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.DISPLAY_VALUE);
    }

    protected boolean isExpertImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        Object rawValue = this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.EXPERT);
        return this.convertToBoolean(rawValue, false);
    }

    protected String getGroupImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        return (String)this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.GROUP);
    }

    protected String getHelpTopicImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        return (String)this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.HELP_TOPIC);
    }

    protected boolean isHiddenImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        Object rawValue = this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.HIDDEN);
        return this.convertToBoolean(rawValue, false);
    }

    protected String getJavaTypeImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        return (String)this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.JAVA_TYPE);
    }

    protected boolean isPreferredImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        Object rawValue = this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.PREFERRED);
        return this.convertToBoolean(rawValue, false);
    }

    protected Object getPropertyEditorImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        return this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.PROPERTY_EDITOR);
    }

    protected boolean isRequiredImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        Object rawValue = this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.REQUIRED);
        return this.convertToBoolean(rawValue, false);
    }

    protected String getShortDescriptionImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        return (String)this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.SHORT_DESCRIPTION);
    }

    protected String getShortDisplayNameImpl(QualifiedName annotationPropertyName, Node associatedNode, Map<String, Object> implicitObjects) {
        return (String)this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.SHORT_DISPLAY_NAME);
    }

    protected boolean isValueModifableImpl(AnnotationModel annotationModel, AnnotationProvider annotationProvider, QualifiedName annotationPropertyName, Node associatedNode) {
        if (annotationModel.isReadOnly()) {
            return false;
        }
        Object rawValue = this._metadataProvider.getMetadataItem((Object)annotationPropertyName, (Object)XmlMetadataConstants.WRITABLE);
        return this.convertToBoolean(rawValue, true);
    }

    protected final boolean convertToBoolean(Object rawValue, boolean defaultValue) {
        if (rawValue instanceof String) {
            if ("true".equals(rawValue) || "1".equals(rawValue)) {
                return true;
            }
            if ("false".equals(rawValue) || "0".equals(rawValue)) {
                return false;
            }
        }
        if (rawValue instanceof Boolean) {
            return (Boolean)rawValue;
        }
        return defaultValue;
    }

    protected final int convertToInt(Object rawValue, int defaultValue) {
        if (rawValue instanceof String) {
            try {
                return Integer.valueOf((String)rawValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rawValue instanceof Integer) {
            return (Integer)rawValue;
        }
        return defaultValue;
    }

    protected final URL convertToURL(Object rawValue) {
        if (rawValue instanceof String) {
            try {
                SimpleTypeConverter converter = JavaTypeManager.getInstance().getSimpleTypeConverter(XmlMetadataConstants.TYPE_RESOURCEPATH);
                return (URL)converter.convertToJavaType((String)rawValue, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (rawValue instanceof URL) {
            return (URL)rawValue;
        }
        return null;
    }

    protected final MetadataProvider getAnnotationMetadataProvider() {
        return this._metadataProvider;
    }

    private Set<URL> _getLayoutUrls() {
        List formLayoutBeans = this._metadataProvider.getGlobalMetadata(QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata/model", (String)"annotationPropertyFormLayout"));
        if (formLayoutBeans != null && !formLayoutBeans.isEmpty()) {
            HashSet<URL> urlList = new HashSet<URL>(3);
            for (StructuredMetadataBean formLayoutBean : formLayoutBeans) {
                String rawText = formLayoutBean.getValue();
                URL url = this.convertToURL(rawText);
                if (url == null) continue;
                urlList.add(url);
            }
            return urlList;
        }
        return Collections.emptySet();
    }

    private Map<QualifiedName, String> _getLayoutUrlsAndProperties(URL layoutFile) {
        List formLayoutBeans = this._metadataProvider.getGlobalMetadata(QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/bali/xml/metadata/model", (String)"annotationPropertyFormLayout"));
        if (formLayoutBeans != null && !formLayoutBeans.isEmpty()) {
            for (StructuredMetadataBean formLayoutBean : formLayoutBeans) {
                String rawText = formLayoutBean.getValue();
                URL url = this.convertToURL(rawText);
                if (url == null || !url.equals(layoutFile)) continue;
                return formLayoutBean.getProperties();
            }
        }
        return Collections.emptyMap();
    }
}

