/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model;

import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import oracle.bali.xml.dom.DomModel;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.position.DomRange;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversalTreeWalker;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.PrecommitOptions;
import oracle.bali.xml.model.PrecommitResults;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.bali.xml.model.listenerImpl.EventDeliveryTask;
import oracle.bali.xml.model.message.MessageCategory;
import oracle.bali.xml.model.message.ValidationHandler;
import oracle.bali.xml.model.message.XmlModelMessageIssueList;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.bali.xml.share.PropertyChange;
import oracle.bali.xml.util.XmlNavigationActions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.TreeWalker;

public abstract class XmlView
extends AbstractModel {
    private XmlMetadataResolver _resolver;
    private XmlNavigationActions _navActions;
    private List _contextActions;
    private XmlModel _model;
    private Document _document;
    private LockAssertingTreeTraversal _currentViewTraversal;
    private boolean _hasPendingSelectionEvent;
    private XmlModelEvent _transformedEvent;
    private XmlModelEvent _eventToTransform;
    private XmlModelEvent _invalidateBufferingEvent;
    private XmlModelEvent _changeBufferingEvent;
    private boolean _hadBlockingErrorsBeforeOuterTxn = true;

    public XmlView() {
        this.createSelection();
    }

    @Override
    public final XmlModel getBaseModel() {
        return this._model;
    }

    @Override
    public final DomModel getDomModel() {
        return this.getBaseModel().getDomModel();
    }

    @Override
    public final XmlContext getContext() {
        return this.getBaseModel().getContext();
    }

    @Override
    public Object getService(Object selector) {
        return this.getBaseModel().getService(selector);
    }

    @Override
    public Document getDocument() {
        this.__verifyLock();
        return this._document;
    }

    @Override
    public final void startTransaction(TransactionOptions transOptions) {
        this.getBaseModel().__requestStartTransaction(this, transOptions);
        this.getSelection().__startTransaction();
        if (this._validatesButDoesntRequireValidModel() && this.getBaseModel().__getTransactionDepth() == 1) {
            this._hadBlockingErrorsBeforeOuterTxn = this.getBaseModel().__checkForTransactionBlockingErrors();
        }
    }

    @Override
    public final boolean commitTransaction() throws XmlCommitException {
        boolean shouldThrow = this.requiresValidModel() ? true : (this.validatesTransactions() ? (this.getBaseModel().__getTransactionDepth() == 1 ? !this._hadBlockingErrorsBeforeOuterTxn : true) : false);
        XmlModel baseModel = this.getBaseModel();
        PrecommitOptions options = PrecommitOptions.getInstance(shouldThrow);
        PrecommitResults precommitResults = baseModel.__requestPrecommitTransaction(this, options);
        if (!precommitResults.precommitSucceeded()) {
            XmlCommitException fatalException = precommitResults.getFatalException();
            if (fatalException.isValidationFailure()) {
                String desc = this.getDomModel().getTransactionDescription();
                String errorFormat = this.getTranslatedString("XML_MODEL_INVALID.TRANSACTION_MESSAGE_FORMAT");
                String errorMessage = FastMessageFormat.formatMessage(errorFormat, desc);
                String descFormat = this.getTranslatedString("XML_MODEL_INVALID.TRANSACTION_DESC_FORMAT");
                String descMessage = FastMessageFormat.formatMessage(descFormat, desc);
                this.getContext().showErrorMessage(errorMessage, descMessage, fatalException);
            }
            throw fatalException;
        }
        this._hasPendingSelectionEvent = this.getSelection().commitTransaction();
        boolean isValid = false;
        try {
            isValid = baseModel.__requestCommitTransaction(this, shouldThrow);
        }
        catch (XmlCommitException xce) {
            this.getLogger().log(Level.SEVERE, "XmlModel commit threw exception not thrown in precommit! view=" + this, xce);
        }
        return isValid;
    }

    @Override
    public final void rollbackTransaction() {
        this.getSelection().__rollbackTransaction();
        this.getBaseModel().__requestRollbackTransaction(this);
    }

    public Node modelToView(Node modelNode) {
        DomPosition viewPosition;
        if (modelNode != null && (viewPosition = this.modelToView(DomPositionFactory.createInsideOrAfterPosition((Node)modelNode))) != null) {
            return viewPosition.getTargetNode();
        }
        return null;
    }

    public Node viewToModel(Node viewNode) {
        DomPosition modelPosition;
        if (viewNode != null && (modelPosition = this.viewToModel(DomPositionFactory.createInsideOrAfterPosition((Node)viewNode))) != null) {
            return modelPosition.getTargetNode();
        }
        return null;
    }

    @Override
    public DomPosition convertInsertionPosition(DomPosition origPosition) {
        DomPosition origModel;
        if (origPosition != null && (origModel = this.viewToModel(origPosition)) != null) {
            DomPosition newModel = this.getBaseModel().convertInsertionPosition(origModel);
            if (origModel.equals((Object)newModel)) {
                return origPosition;
            }
            DomPosition newView = this.modelToView(newModel);
            if (newView != null) {
                return newView;
            }
        }
        return origPosition;
    }

    public abstract DomPosition modelToView(DomPosition var1);

    public abstract DomPosition viewToModel(DomPosition var1);

    @Override
    public TreeWalker createTreeWalker() {
        return new ViewTreeWalker();
    }

    @Override
    public Action getAction(String actionString) {
        if ("nextNode".equals(actionString)) {
            return this._getNavActions().getNextAction();
        }
        if ("prevNode".equals(actionString)) {
            return this._getNavActions().getPreviousAction();
        }
        return this.getBaseModel().getAction(actionString);
    }

    public final List getContextActions() {
        if (this._contextActions == null) {
            this._contextActions = this.initContextActions();
        }
        return this._contextActions;
    }

    @Override
    public String getTranslatedString(String key) {
        return this.getBaseModel().getTranslatedString(key);
    }

    @Override
    public Node remapNode(List oldNodePath) {
        int pathCount = oldNodePath.size();
        if (pathCount == 0) {
            return null;
        }
        Node lastNode = (Node)oldNodePath.get(pathCount - 1);
        Node modelNode = this.viewToModel(lastNode);
        if (modelNode != null) {
            int nodeDepth = DomUtils.getNodeDepth((Node)modelNode);
            if (nodeDepth == -1) {
                Node currViewNode;
                for (int i = pathCount - 2; i >= 0 && ((modelNode = this.viewToModel(currViewNode = (Node)oldNodePath.get(i))) == null || (nodeDepth = DomUtils.getNodeDepth((Node)modelNode)) == -1); --i) {
                }
            }
            if (nodeDepth == -1) {
                return null;
            }
            ArrayList<Node> modelPath = new ArrayList<Node>(nodeDepth);
            for (int i = 0; i < nodeDepth; ++i) {
                modelPath.add(modelNode);
                modelNode = modelNode.getParentNode();
            }
            Collections.reverse(modelPath);
            Node remappedModelNode = this.getBaseModel().remapNode(modelPath);
            if (remappedModelNode != null) {
                return this.modelToView(remappedModelNode);
            }
            return null;
        }
        return null;
    }

    @Override
    public final XmlMetadataResolver getXmlMetadataResolver() {
        if (this._resolver == null) {
            MetadataEvaluator evaluator = this.createMetadataEvaluator();
            this._resolver = evaluator == null ? this.getBaseModel().getXmlMetadataResolver() : this.createXmlMetadataResolver(evaluator);
        }
        return this._resolver;
    }

    @Override
    public XmlKey getNodeXmlKey(Node node) {
        if (node == null) {
            return null;
        }
        Node modelNode = this.viewToModel(node);
        if (modelNode == null) {
            return null;
        }
        return this.getBaseModel().getNodeXmlKey(modelNode);
    }

    @Override
    public Collection deleteNodes(final String transactionName, final Collection nodes, final boolean updateSelection) throws XmlCommitException {
        final Collection[] ret = new Collection[1];
        new FixedNameTransactionTask(transactionName){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                Collection modelRet = XmlView.this.getBaseModel().deleteNodes(transactionName, XmlView.this.viewToModel(nodes), updateSelection);
                ret[0] = XmlView.this.modelToView(modelRet);
            }
        }.runThrowingXCE(this);
        return ret[0];
    }

    private void _fixUpSelectionPostDeletion() {
        DomRange range;
        DomPosition oldDrop;
        Selection sel = this.getSelection();
        Selection modelSel = this.getBaseModel().getSelection();
        Node[] selNodes = sel.getSelectedNodesArray();
        for (int i = 0; i < selNodes.length; ++i) {
            Node node = selNodes[i];
            if (this.isInModelDocumentHierarchy(node)) continue;
            sel.remove(node);
        }
        DomPosition oldCursor = sel.getCursorLocation();
        if (oldCursor != null && !this.isInModelDocumentHierarchy(oldCursor)) {
            sel.setCursorLocation(this.modelToView(modelSel.getCursorLocation()));
        }
        if ((oldDrop = sel.getDropLocation()) != null && !this.isInModelDocumentHierarchy(oldDrop)) {
            sel.setDropLocation(this.modelToView(modelSel.getDropLocation()));
        }
        if (sel.hasRangeSelection() && !this.isInModelDocumentHierarchy((range = sel.getRangeSelection()).getStart()) && !this.isInModelDocumentHierarchy(range.getEnd())) {
            sel.clearRangeSelectionPreservingNodes();
        }
    }

    @Override
    public Collection deleteNodes(final String transactionName, final DomRange range, final boolean updateSelection) throws XmlCommitException {
        final Collection[] ret = new Collection[1];
        new FixedNameTransactionTask(transactionName){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                if (range.isInsideAttributeValue()) {
                    Element owner = (Element)range.getStart().getTargetNode();
                    Node modelOwner = XmlView.this.viewToModel(owner);
                    if (DomUtils.isElement((Node)modelOwner)) {
                        Element modelElem = (Element)modelOwner;
                        QualifiedName attrQName = range.getStart().getAttributeQName();
                        XmlView.this.getBaseModel().deleteInsideAttributeValueImpl(DomRange.create((DomPosition)DomPositionFactory.createAttributePosition((Element)modelElem, (QualifiedName)attrQName, (int)range.getStart().getTextOffset()), (DomPosition)DomPositionFactory.createAttributePosition((Element)modelElem, (QualifiedName)attrQName, (int)range.getEnd().getTextOffset()), (TreeTraversal)model.getBaseModel().getTreeTraversal()));
                        ret[0] = Collections.EMPTY_LIST;
                    } else {
                        this.cancelTask();
                    }
                } else {
                    Node modelTarget;
                    Node startTarget = range.getStart().getTargetNode();
                    if (startTarget == range.getEnd().getTargetNode() && (modelTarget = XmlView.this.viewToModel(startTarget)) == startTarget) {
                        Collection modelRet = XmlView.this.getBaseModel().deleteNodes(transactionName, range, updateSelection);
                        ret[0] = XmlView.this.modelToView(modelRet);
                        return;
                    }
                    Collection viewNodes = XmlView.this.getNodesForDeletion(range, updateSelection);
                    Collection modelRet = XmlView.this.getBaseModel().deleteNodes(transactionName, XmlView.this.viewToModel(viewNodes), false);
                    ret[0] = XmlView.this.modelToView(modelRet);
                }
            }
        }.runThrowingXCE(this);
        return ret[0];
    }

    @Override
    public Collection insertNodes(final DomPosition location, final String transactionName, final Collection nodes, final boolean updateSelection) throws XmlCommitException {
        final Collection[] ret = new Collection[1];
        new FixedNameTransactionTask(transactionName){

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                DomPosition modelPos = XmlView.this.viewToModel(location);
                if (modelPos != null) {
                    Collection modelRet = XmlView.this.getBaseModel().insertNodes(modelPos, transactionName, XmlView.this.viewToModel(nodes), updateSelection);
                    ret[0] = XmlView.this.modelToView(modelRet);
                    if (updateSelection) {
                        XmlView.this.selectInsertedNodes(ret[0]);
                    }
                }
            }
        }.runThrowingXCE(this);
        return ret[0];
    }

    protected final List viewToModel(Collection collection) {
        if (collection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Node> ret = new ArrayList<Node>(collection.size());
        for (Object next : collection) {
            Object modelObject = next instanceof Node ? this.viewToModel((Node)next) : (next instanceof DomPosition ? this.viewToModel((DomPosition)next) : null);
            if (modelObject == null) continue;
            ret.add((Node)modelObject);
        }
        return ret;
    }

    protected final List modelToView(Collection collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Node> ret = new ArrayList<Node>(collection.size());
        for (Object next : collection) {
            Object viewObject = next instanceof Node ? this.modelToView((Node)next) : (next instanceof DomPosition ? this.modelToView((DomPosition)next) : null);
            if (viewObject == null) continue;
            ret.add((Node)viewObject);
        }
        return ret;
    }

    @Override
    protected void mergeTextNodesImpl(Text a, Text b) {
        AbstractModel.MapperForMergeTextNodes mapper = new AbstractModel.MapperForMergeTextNodes(a, b);
        Node modelA = this.viewToModel(a);
        Node modelB = this.viewToModel(b);
        if (a == modelA && b == modelB && a.getNextSibling() == b) {
            this.getBaseModel().mergeTextNodesImpl(a, b);
        } else {
            a.appendData(b.getNodeValue());
            Node parent = this.getTreeTraversal().getParentNode((Node)b);
            parent.removeChild(b);
        }
        mapper.applyMappings();
    }

    @Override
    protected Text splitTextNodeImpl(Text orig, int offset) {
        AbstractModel.MapperForSplitTextNode mapper = new AbstractModel.MapperForSplitTextNode(orig, offset);
        Node modelOrig = this.viewToModel(orig);
        Text created = modelOrig == orig ? this.getBaseModel().splitTextNodeImpl(orig, offset) : orig.splitText(offset);
        mapper.setCreated(created);
        mapper.applyMappings();
        return created;
    }

    @Override
    protected void commentOutImpl(DomRange range, boolean escapeDashDash) {
        this.getDomModel().commentOut(range, escapeDashDash);
    }

    @Override
    protected void uncommentImpl(DomRange range) {
        this.getDomModel().uncomment(range);
    }

    @Override
    public Transferable createTransferable() {
        this.acquireReadLock();
        try {
            if (!this.getXmlMetadataResolver().isSelectionTransferable()) {
                Transferable transferable = null;
                return transferable;
            }
            Transferable transferable = this.getBaseModel().createTransferable();
            return transferable;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public List getExtraContextMenus(DomPosition position) {
        return this.getBaseModel().getViewExtraContextMenus(this, position);
    }

    @Override
    public boolean isReadOnly() {
        return this.getBaseModel().isReadOnly() || this.requiresValidModel() && !this.getBaseModel().isDocumentValid();
    }

    @Override
    protected final boolean isImmutable(Node node) {
        if (node == null) {
            return false;
        }
        if (this.isReadOnly()) {
            return true;
        }
        Node modelNode = this.viewToModel(node);
        if (modelNode != null) {
            return this.getBaseModel().isImmutable(modelNode);
        }
        return false;
    }

    @Override
    protected final boolean isDeletable(Node node) {
        if (node == null) {
            return false;
        }
        Node modelNode = this.viewToModel(node);
        if (modelNode != null) {
            if (this.requiresValidModel() && modelNode == this.getBaseModel().getDocument().getDocumentElement()) {
                return false;
            }
            return this.getBaseModel().isDeletable(modelNode);
        }
        return true;
    }

    @Override
    protected final boolean canAddChild(DomPosition position) {
        if (position == null) {
            return false;
        }
        DomPosition modelPos = this.viewToModel(position);
        if (modelPos != null) {
            return this.getBaseModel().canAddChild(modelPos);
        }
        return true;
    }

    @Override
    protected final boolean canAddAttribute(Element parent, XmlKey attrKey) {
        if (parent == null) {
            return false;
        }
        Element modelParent = (Element)this.viewToModel(parent);
        if (modelParent != null) {
            return this.getBaseModel().canAddAttribute(modelParent, attrKey);
        }
        return true;
    }

    @Override
    protected final boolean isValueModifiable(Node node) {
        if (node == null) {
            return false;
        }
        Node modelNode = this.viewToModel(node);
        if (modelNode != null) {
            return this.getBaseModel().isValueModifiable(modelNode);
        }
        return true;
    }

    @Override
    public TreeTraversal getTreeTraversal() {
        this.__verifyLock();
        TreeTraversal ret = this.getTreeTraversalImpl();
        if (ret == null) {
            return null;
        }
        if (this._currentViewTraversal == null || ret != this._currentViewTraversal.getRealTraversal()) {
            this._currentViewTraversal = new LockAssertingTreeTraversal(ret);
        }
        return this._currentViewTraversal;
    }

    public String getDebugInfo() {
        return new String("View=[" + this + "] Model=[" + this.getBaseModel() + "]Traversal=[" + this._currentViewTraversal.getRealTraversal() + "]");
    }

    @Override
    public final void acquireReadLock() {
        this.getBaseModel().acquireReadLock();
    }

    @Override
    public final void releaseReadLock() {
        this.getBaseModel().releaseReadLock();
    }

    public final XmlModelEvent createHelloGoodbyeEvent(boolean isHello) {
        return this.createEvent(isHello);
    }

    @Override
    final void __acquireWriteLock() {
        this.getBaseModel().__acquireWriteLock();
    }

    @Override
    final void __releaseWriteLock() {
        this.getBaseModel().__releaseWriteLock();
    }

    @Override
    final void __verifyLock() {
        this.getBaseModel().__verifyLock();
    }

    @Override
    final void __verifyWriteLock() {
        this.getBaseModel().__verifyWriteLock();
    }

    protected TreeTraversal getTreeTraversalImpl() {
        return null;
    }

    protected void baseModelAttached() {
        XmlModel baseModel = this.getBaseModel();
        this.acquireReadLock();
        try {
            this._document = baseModel.getDocument();
        }
        finally {
            this.releaseReadLock();
        }
    }

    protected void postAttachmentHook() {
        this.getXmlMetadataResolver();
    }

    protected void postCreationHook() {
    }

    protected MetadataProvider createMetadataProvider() {
        return null;
    }

    protected MetadataEvaluator createMetadataEvaluator() {
        return null;
    }

    protected XmlMetadataResolver createXmlMetadataResolver(MetadataEvaluator evaluator) {
        XmlMetadataResolver baseResolver = this.getBaseModel().getXmlMetadataResolver();
        return baseResolver.cloneWithEvaluator(evaluator, this);
    }

    protected List initContextActions() {
        Action goDecl;
        ArrayList<Action> contextActions = new ArrayList<Action>(7);
        contextActions.add(this.getAction("cut"));
        contextActions.add(this.getAction("copy"));
        contextActions.add(this.getAction("paste"));
        contextActions.add(this.getAction("clear"));
        contextActions.add(this.getAction("customizeNode"));
        contextActions.add(this.getAction("convertNode"));
        contextActions.add(this.getAction("surroundNode"));
        contextActions.add(this.getAction("gotoproperties"));
        contextActions.add(this.getAction("showAsTop"));
        contextActions.add(this.getAction("selectTop"));
        contextActions.add(this.getAction("collapseAllBelow"));
        contextActions.add(this.getAction("expandAllBelow"));
        Action goSource = this.getAction("gotosource");
        if (goSource != null) {
            contextActions.add(goSource);
        }
        if ((goDecl = this.getAction("gotodeclaration")) != null) {
            contextActions.add(goDecl);
        }
        return Collections.unmodifiableList(contextActions);
    }

    protected XmlModelEvent transformModelEvent(XmlModelEvent modelChangeEvent) {
        return new XmlModelEvent(this, modelChangeEvent.getChangeRoot(), modelChangeEvent.getChangeFlags(), modelChangeEvent.getPropertyChanges(), modelChangeEvent.getSelectionsAdded(), modelChangeEvent.getSelectionsRemoved(), modelChangeEvent.getBaseModelDomChanges(), modelChangeEvent.getNodeChangeDetails());
    }

    public Set modelNodeIteratorToViewNodeSet(Iterator modelNodeIterator, Set mutableOutSet) {
        if (modelNodeIterator == null || !modelNodeIterator.hasNext()) {
            return Collections.EMPTY_SET;
        }
        if (mutableOutSet == null) {
            mutableOutSet = new HashSet(17);
        }
        this._modelNodeIteratorToViewNodeSet(modelNodeIterator, mutableOutSet);
        return mutableOutSet;
    }

    public Set modelNodeSetToViewNodeSet(Set modelSet, Set mutableOutSet) {
        int setSize = modelSet.size();
        if (setSize == 0) {
            return modelSet;
        }
        Set viewSet = mutableOutSet != null ? mutableOutSet : new HashSet((int)((double)setSize * 1.5));
        Iterator modelNodes = modelSet.iterator();
        boolean changed = this._modelNodeIteratorToViewNodeSet(modelNodes, viewSet);
        if (changed) {
            return viewSet;
        }
        return modelSet;
    }

    protected boolean validatesTransactions() {
        return true;
    }

    protected void createSelection() {
    }

    protected void initializeSelectionState(XmlModelEvent modelHelloEvent) {
    }

    protected void handleModelInvalidateEvent(XmlModelEvent event) {
    }

    protected void handleModelChangeEvent(XmlModelEvent event) {
    }

    protected void addCurrentPropertiesToEvent(Map propertyChanges, boolean isAdding) {
        super.addCurrentPropertiesToEvent(propertyChanges, isAdding);
        XmlModelMessageIssueList validationIssueList = this.getBaseModel().getValidationIssues();
        propertyChanges.put("validationIssues", new PropertyChange("validationIssues", new ValidationHandler(this.getBaseModel(), MessageCategory.GRAMMAR_VALIDITY), validationIssueList));
        propertyChanges.put("XmlModelIssueList", new PropertyChange("XmlModelIssueList", null, this.getContext().getIssueList()));
    }

    void __attachBaseModel(XmlModel baseModel) {
        if (baseModel == null) {
            throw new IllegalArgumentException("Null XmlModel passed as the base model");
        }
        if (this._model != null) {
            throw new IllegalStateException("Cannot attach a BaseModel twice");
        }
        this._model = baseModel;
    }

    void __initializationComplete() {
        this.getBaseModel().addModelListener(new ModelChangeListener());
        this.markAsFullyInstantiatedAndDeliverInitialEvent();
    }

    private boolean _modelNodeIteratorToViewNodeSet(Iterator modelNodeIterator, Set mutableOutSet) {
        boolean changed = false;
        while (modelNodeIterator.hasNext()) {
            Node viewNode;
            Node modelNode = (Node)modelNodeIterator.next();
            changed |= modelNode != (viewNode = this.modelToView(modelNode));
            if (viewNode == null) continue;
            mutableOutSet.add(viewNode);
        }
        return changed;
    }

    private XmlNavigationActions _getNavActions() {
        if (this._navActions == null) {
            this._navActions = new XmlNavigationActions(this, this.getTreeTraversal());
        }
        return this._navActions;
    }

    private boolean _validatesButDoesntRequireValidModel() {
        return this.validatesTransactions() && !this.requiresValidModel();
    }

    private class ViewTreeWalker
    extends TreeTraversalTreeWalker {
        private ViewTreeWalker() {
        }

        protected TreeTraversal getTreeTraversal() {
            return XmlView.this.getTreeTraversal();
        }

        public Node getRoot() {
            Document doc = XmlView.this.getDocument();
            if (doc != null) {
                return doc.getDocumentElement();
            }
            return null;
        }
    }

    private class LockAssertingTreeTraversal
    extends TreeTraversal {
        private final TreeTraversal _real;

        public LockAssertingTreeTraversal(TreeTraversal real) {
            this._real = real;
        }

        public TreeTraversal getRealTraversal() {
            return this._real;
        }

        public Node getParentNode(Node node) {
            XmlView.this.__verifyLock();
            return this._real.getParentNode(node);
        }

        public Node getFirstChild(Node node) {
            XmlView.this.__verifyLock();
            return this._real.getFirstChild(node);
        }

        public Node getLastChild(Node node) {
            XmlView.this.__verifyLock();
            return this._real.getLastChild(node);
        }

        public Node getNextSibling(Node node) {
            XmlView.this.__verifyLock();
            return this._real.getNextSibling(node);
        }

        public Node getPreviousSibling(Node node) {
            XmlView.this.__verifyLock();
            return this._real.getPreviousSibling(node);
        }

        public Node getChild(Node parentNode, int childIndex) {
            XmlView.this.__verifyLock();
            return this._real.getChild(parentNode, childIndex);
        }

        public int getChildCount(Node parentNode) {
            XmlView.this.__verifyLock();
            return this._real.getChildCount(parentNode);
        }

        public Node getPreviousNode(Node node) {
            XmlView.this.__verifyLock();
            return this._real.getPreviousNode(node);
        }

        public Node getNextNode(Node node) {
            XmlView.this.__verifyLock();
            return this._real.getNextNode(node);
        }
    }

    private class ModelChangeListener
    extends XmlModelAdapter {
        private ModelChangeListener() {
        }

        @Override
        public void invalidate(XmlModelEvent event) {
            XmlView.this.getListenerManager().executeEventDeliveryTask(new PropogateInvalidateEventTask(event));
        }

        @Override
        public void modelChanged(XmlModelEvent event) {
            XmlView.this.getListenerManager().executeEventDeliveryTask(new PropogateModelChangeEventTask(event));
        }

        @Override
        public void noChange(XmlModelEvent event) {
            XmlView.this.getListenerManager().executeEventDeliveryTask(new PropogateNoChangeEventTask(event));
        }

        @Override
        public void listenerAttached(XmlModelEvent event) {
            XmlView.this.initializeSelectionState(event);
        }
    }

    private class PropogateNoChangeEventTask
    extends EventDeliveryTask {
        private XmlModelEvent _baseModelEvent;

        public PropogateNoChangeEventTask(XmlModelEvent baseModelEvent) {
            this._baseModelEvent = baseModelEvent;
        }

        @Override
        public void execute(List<XmlModelListener> attachedListeners, List<XmlModelListener> pendingAddListeners, List<XmlModelListener> pendingRemoveListeners) {
            if (XmlView.this._hasPendingSelectionEvent) {
                PropogateInvalidateEventTask sendMockInvalidate = new PropogateInvalidateEventTask(this._baseModelEvent);
                ((EventDeliveryTask)sendMockInvalidate).execute(attachedListeners, pendingAddListeners, pendingRemoveListeners);
                PropogateInvalidateEventTask sendMockModelChangeEvent = new PropogateInvalidateEventTask(this._baseModelEvent);
                ((EventDeliveryTask)sendMockModelChangeEvent).execute(attachedListeners, pendingAddListeners, pendingRemoveListeners);
                XmlView.this._hasPendingSelectionEvent = false;
            }
            this.deliverEventHelper(attachedListeners, pendingRemoveListeners, XmlView.this.getListenerManager().getEmptyEvent(), (short)4);
        }
    }

    private class PropogateModelChangeEventTask
    extends EventDeliveryTask {
        private XmlModelEvent _baseModelEvent;

        public PropogateModelChangeEventTask(XmlModelEvent baseModelEvent) {
            this._baseModelEvent = baseModelEvent;
        }

        @Override
        public void execute(List<XmlModelListener> attachedListeners, List<XmlModelListener> pendingAddListeners, List<XmlModelListener> pendingRemoveListeners) {
            XmlModelEvent viewChangeEvent;
            if (XmlView.this._eventToTransform == this._baseModelEvent) {
                viewChangeEvent = XmlView.this._transformedEvent;
                if (XmlView.this.getBaseModel().isDocumentValid()) {
                    XmlView.this._changeBufferingEvent = null;
                    XmlView.this._invalidateBufferingEvent = null;
                } else if (XmlView.this._invalidateBufferingEvent != null) {
                    XmlView.this._changeBufferingEvent = (XmlModelEvent)XmlView.this._invalidateBufferingEvent.clone();
                }
            } else if (XmlView.this._changeBufferingEvent != null) {
                XmlView.this._changeBufferingEvent.addModelEvent(this._baseModelEvent);
                if (XmlView.this.getBaseModel().isDocumentValid()) {
                    viewChangeEvent = XmlView.this.transformModelEvent(XmlView.this._changeBufferingEvent);
                    XmlView.this._changeBufferingEvent = null;
                    XmlView.this._invalidateBufferingEvent = null;
                } else {
                    viewChangeEvent = null;
                }
            } else {
                viewChangeEvent = XmlView.this.transformModelEvent(this._baseModelEvent);
            }
            XmlView.this._transformedEvent = null;
            XmlView.this._eventToTransform = null;
            if (viewChangeEvent != null && viewChangeEvent.getChangeFlags() != 0) {
                try {
                    viewChangeEvent.prepareForDelivery();
                    XmlView.this.handleModelChangeEvent(viewChangeEvent);
                }
                catch (Throwable e) {
                    XmlView.this.getLogger().log(Level.WARNING, "Unexpected throwable in XmlView.handleModelChangeEvent", e);
                }
                this.deliverEventHelper(attachedListeners, pendingRemoveListeners, viewChangeEvent, (short)3);
            }
        }
    }

    private class PropogateInvalidateEventTask
    extends EventDeliveryTask {
        private XmlModelEvent _baseModelEvent;

        public PropogateInvalidateEventTask(XmlModelEvent baseModelEvent) {
            this._baseModelEvent = baseModelEvent;
        }

        @Override
        public void execute(List<XmlModelListener> attachedListeners, List<XmlModelListener> pendingAddListeners, List<XmlModelListener> pendingRemoveListeners) {
            assert (this._baseModelEvent.getSource() == XmlView.this.getBaseModel());
            XmlView.this._hasPendingSelectionEvent = false;
            XmlModelEvent viewEvent = null;
            if (XmlView.this.requiresValidModel()) {
                PropertyChange validChange = this._baseModelEvent.getDomDocumentValidPropertyChange();
                if (validChange != null) {
                    if (!validChange.getNewBooleanValue()) {
                        assert (XmlView.this._invalidateBufferingEvent == null);
                        XmlView.this._invalidateBufferingEvent = (XmlModelEvent)this._baseModelEvent.clone();
                        XmlView.this._invalidateBufferingEvent.removePropertyChange(validChange.getPropertyName());
                        viewEvent = new XmlModelEvent(XmlView.this);
                        viewEvent.addPropertyChanges(Collections.singletonMap(validChange.getPropertyName(), validChange));
                    } else if (XmlView.this._invalidateBufferingEvent != null) {
                        XmlView.this._invalidateBufferingEvent.addModelEvent(this._baseModelEvent);
                        this._baseModelEvent = XmlView.this._invalidateBufferingEvent;
                        XmlView.this._invalidateBufferingEvent = null;
                    }
                } else if (XmlView.this._invalidateBufferingEvent != null) {
                    XmlView.this._invalidateBufferingEvent.addModelEvent(this._baseModelEvent);
                    if (XmlView.this.getBaseModel().isDocumentValid()) {
                        this._baseModelEvent = XmlView.this._invalidateBufferingEvent;
                        XmlView.this._invalidateBufferingEvent = null;
                    } else {
                        this._baseModelEvent = null;
                    }
                }
            }
            if (this._baseModelEvent != null) {
                XmlView.this._eventToTransform = this._baseModelEvent;
                PropertyChange documentChange = this._baseModelEvent.getDomDocumentPropertyChange();
                if (documentChange != null) {
                    XmlView.this._document = (Document)documentChange.getNewValue();
                }
                if (viewEvent == null) {
                    viewEvent = XmlView.this.transformModelEvent(this._baseModelEvent);
                }
                if (viewEvent != null && viewEvent.getChangeFlags() != 0) {
                    XmlView.this._transformedEvent = viewEvent;
                    try {
                        viewEvent.prepareForDelivery();
                        XmlView.this.handleModelInvalidateEvent(viewEvent);
                    }
                    catch (Throwable e) {
                        XmlView.this.getLogger().log(Level.WARNING, "Unexpected throwable in XmlView.handleModelInvalidateEvent", e);
                    }
                    if (XmlView.this.getLogger().isLoggable(Level.FINER)) {
                        XmlView.this.getLogger().finer("XmlView deliver (" + this + "): " + viewEvent);
                    }
                    this.deliverEventHelper(attachedListeners, viewEvent, (short)2);
                } else {
                    XmlView.this._transformedEvent = null;
                    this.deliverEventHelper(attachedListeners, XmlView.this.getListenerManager().getEmptyEvent(), (short)4);
                }
            }
        }
    }
}

