/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector.editors;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.MappedEditorFactoryInfo;
import oracle.bali.inspector.editor.ToStringConverter;

public final class EditorUtils {
    private static final String COMPONENT_TYPE_FINAL = "COMPONENT_TYPE_FINAL";

    private EditorUtils() {
    }

    public static EditorComponentInfo createEditorComponentInfo(final String componentIdentifier, final Map<String, Object> properties) {
        return new EditorComponentInfo(){

            public Object initialValue() {
                return new MappedEditorFactoryInfo(EditorUtils._getEditorType(componentIdentifier), EditorUtils._getProperties(properties));
            }

            public ToStringConverter editorValueToStringConverter() {
                return (ToStringConverter)properties.get(MappedEditorFactoryInfo.TO_STRING_CONVERTER);
            }

            public String getComponentIdentifier() {
                if (componentIdentifier == null) {
                    return super.getComponentIdentifier();
                }
                return componentIdentifier;
            }

            public Map<String, Object> getProperties() {
                return properties;
            }
        };
    }

    public static EditorComponentInfo createEditorComponentInfo(String componentIdentifier, String propertyName, Object property) {
        HashMap<String, Object> properties = new HashMap<String, Object>(1);
        properties.put(propertyName, property);
        return EditorUtils.createEditorComponentInfo(componentIdentifier, properties);
    }

    public static EditorComponentInfo createEditorComponentInfo(String propertyName, Object property) {
        return EditorUtils.createEditorComponentInfo(null, propertyName, property);
    }

    private static MappedEditorFactoryInfo.EditorType _getEditorType(String componentIdentifier) {
        if (componentIdentifier == null) {
            componentIdentifier = MappedEditorFactoryInfo.TEXT_FIELD;
        }
        for (MappedEditorFactoryInfo.EditorType et : MappedEditorFactoryInfo.EditorType.values()) {
            if (!et.toString().equals(componentIdentifier)) continue;
            return et;
        }
        return null;
    }

    private static Map<MappedEditorFactoryInfo.PropertyName, Object> _getProperties(Map<String, Object> properties) {
        HashMap<MappedEditorFactoryInfo.PropertyName, Object> newProperties = new HashMap<MappedEditorFactoryInfo.PropertyName, Object>(properties.size());
        Set<String> propertyNames = properties.keySet();
        for (String s : propertyNames) {
            for (MappedEditorFactoryInfo.PropertyName pn : MappedEditorFactoryInfo.PropertyName.values()) {
                if (!pn.toString().equals(s)) continue;
                newProperties.put(pn, properties.get(s));
            }
        }
        return newProperties;
    }
}

