/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.base.inspector;

import java.util.logging.Level;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.FixedAttributeElementDef;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.gui.base.inspector.AttributeValueItemPropertyEditor;
import oracle.bali.xml.gui.base.inspector.BaseInspectorGui;
import oracle.bali.xml.gui.base.inspector.PropertyRow;
import oracle.bali.xml.gui.base.inspector.PropertyRowOwner;
import oracle.bali.xml.gui.base.inspector.XmlKeyPropertyRow;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.XmlMetadataMethods;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlMetadataResolver;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SimpleElementPropertyRow
extends XmlKeyPropertyRow {
    private QualifiedName _qName;
    private static final QualifiedName _sTextQName = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/jdeveloper/xmlef/ignored", (String)"text_virtual_attribute");

    public SimpleElementPropertyRow(BaseInspectorGui gui, XmlKey key, Node node, PropertyRowOwner owner) {
        super(gui, key, node, owner);
    }

    @Override
    protected String getRowValueAsString(boolean useDefault) {
        return this._getNodeValue(this.getGui(), this.getNode(), this.getKey(), useDefault);
    }

    @Override
    protected PropertyRow.UpdateResult setRowValueAsString(String newValue) {
        boolean changed = false;
        Node n = this.getNode();
        if (n == null && newValue != null && !"".equals(newValue)) {
            GrammarComponent gc;
            Node owner = this.getOwner().getParentNode();
            if (owner == null) {
                return PropertyRow.UpdateResult.NO_UPDATE;
            }
            XmlKey key = this.getKey();
            n = owner.getOwnerDocument().createElementNS(key.getNamespace(), key.getLocalName());
            if (this._isFixedAttribute(key) && (gc = this.getView().getXmlMetadataResolver().getGrammarComponent(key)) != null) {
                AttributeDef fixedAttr = ((FixedAttributeElementDef)gc).getFixedAttribute();
                DomUtils.setAttribute((Element)((Element)n), (String)fixedAttr.getTargetNamespace(), (String)fixedAttr.getName(), (String)fixedAttr.getFixedValue());
            }
            if (DomUtils.isInDocumentHierarchy((Node)owner)) {
                try {
                    n = this.getView().getBaseModel().insertNode(n, DomPositionFactory.inside((Node)owner), false);
                    if (n == null) {
                        throw new RuntimeException(this.getView().getTranslatedString("INSPECTOR.INVALID_DOCUMENT"));
                    }
                }
                catch (XmlCommitException e) {
                    this.getView().getLogger().log(Level.FINER, "Couldn't create simple type element", e);
                }
            } else {
                DomPosition pos = this.getView().getBaseModel().findValidInsertionPosition(key, n, DomPositionFactory.inside((Node)owner), this.getOwner().getParentKey());
                if (pos == null) {
                    throw new RuntimeException(this.getView().getTranslatedString("INSPECTOR.INVALID_DOCUMENT"));
                }
                DomUtils.insertNodeAtPosition((DomPosition)pos, (Node)n);
            }
        }
        if (n == null) {
            return PropertyRow.UpdateResult.NO_UPDATE;
        }
        this.__setNode(n);
        if (newValue == null) {
            this._getResolver().setNodeToDefault(this.getNode());
            return PropertyRow.UpdateResult.INVALIDATE_MODEL;
        }
        if ("".equals(newValue)) {
            boolean removed = this._getResolver().setNodeEmptyString(this.getNode(), newValue);
            if (removed) {
                return PropertyRow.UpdateResult.INVALIDATE_MODEL;
            }
            return PropertyRow.UpdateResult.INVALIDATE_CELL;
        }
        QualifiedName qName = this._getQName(this.getKey());
        if (qName == _sTextQName) {
            String old = DomUtils.getTextContent((Node)n);
            changed = old != newValue && !newValue.equals(old);
            boolean preferCDATA = this._getResolver().getPrefersCDATAValue(n);
            DomUtils.setTextContent((Node)n, (String)newValue, (boolean)preferCDATA);
        } else {
            DomUtils.setAttribute((Element)((Element)n), (String)qName.getNamespace(), (String)qName.getName(), (String)newValue);
            changed = true;
        }
        if (changed) {
            return PropertyRow.UpdateResult.INVALIDATE_MODEL;
        }
        return PropertyRow.UpdateResult.NO_UPDATE;
    }

    @Override
    protected boolean isRequired() {
        XmlKey key = this.getKey();
        PropertyRowOwner owner = this.getOwner();
        XmlKey ownerKey = owner.getParentKey();
        GrammarComponent gc = this._getResolver().getGrammarComponent(key);
        if (key.equals((Object)ownerKey)) {
            return this._getResolver().isTextValueRequired(key);
        }
        if (this._isFixedAttribute(key)) {
            FixedAttributeElementDef ed = (FixedAttributeElementDef)gc;
            AttributeDef ad = ed.getFixedAttribute();
            XmlKey attrKey = DerivedXmlKey.createAttributeKey((GrammarResolver)this.getView().getContext().getGrammarResolver(), (XmlKey)key, (QualifiedName)ad.getQualifiedName());
            return this._getResolver().isRequired(attrKey, key);
        }
        return super.isRequired();
    }

    @Override
    boolean __isDrillable() {
        return false;
    }

    @Override
    protected boolean isCommon(XmlKey key) {
        return true;
    }

    @Override
    protected boolean isSet() {
        return this.getNode() != null;
    }

    @Override
    protected Object createElementFactory(Object pe, int columnIndex) {
        return AttributeValueItemPropertyEditor.create(this, this.getPEF2(pe));
    }

    @Override
    XmlKey __getQueryKey() {
        XmlKey key = this.getKey();
        QualifiedName qName = this._getQName(key);
        if (qName != _sTextQName) {
            key = DerivedXmlKey.createAttributeKey((GrammarResolver)this.getGui().getGuiContext().getGrammarResolver(), (XmlKey)key, (QualifiedName)qName);
        }
        return key;
    }

    @Override
    Node __getQueryNode() {
        NamedNodeMap map;
        XmlKey key;
        QualifiedName qName;
        Node node = this.getNode();
        if (node != null && (qName = this._getQName(key = this.getKey())) != _sTextQName && (map = node.getAttributes()) != null) {
            node = map.getNamedItemNS(qName.getNamespace(), qName.getName());
        }
        return node;
    }

    @Override
    String getPropertyDisplayName(XmlMetadataResolver resolver, Node n) {
        GrammarComponent gc;
        XmlKey a = this.getKey();
        if (this._isFixedAttribute(a) && (gc = resolver.getGrammarComponent(a)) != null) {
            FixedAttributeElementDef ed = (FixedAttributeElementDef)gc;
            AttributeDef ad = ed.getFixedAttribute();
            XmlKey attrKey = DerivedXmlKey.createAttributeKey((GrammarResolver)this.getView().getContext().getGrammarResolver(), (XmlKey)a, (QualifiedName)ad.getQualifiedName());
            Object value = XmlMetadataMethods.getShortDisplayName((MetadataEvaluator)this.getView().getXmlMetadataResolver().getMetadataEvaluator(), (Object)attrKey, null);
            if (value == null) {
                value = ad.getFixedValue();
            }
            if (resolver.isRequired(attrKey, a)) {
                value = (String)value + " *";
            }
            return value;
        }
        Object displayName = resolver.getPropertyDisplayName(this.getNode(), a, this.getOwner().getParentNode(), this.getOwner().getParentKey());
        if (this.isRequired()) {
            displayName = (String)displayName + " *";
        }
        return displayName;
    }

    @Override
    String getPropertyDisplayName(XmlMetadataResolver resolver, XmlKey key, Node ownerNode, XmlKey ownerKey) {
        GrammarComponent gc;
        XmlKey a = this.getKey();
        if (this._isFixedAttribute(a) && (gc = resolver.getGrammarComponent(a)) != null) {
            FixedAttributeElementDef ed = (FixedAttributeElementDef)gc;
            AttributeDef ad = ed.getFixedAttribute();
            XmlKey attrKey = DerivedXmlKey.createAttributeKey((GrammarResolver)this.getView().getContext().getGrammarResolver(), (XmlKey)a, (QualifiedName)ad.getQualifiedName());
            Object value = XmlMetadataMethods.getShortDisplayName((MetadataEvaluator)this.getView().getXmlMetadataResolver().getMetadataEvaluator(), (Object)attrKey, null);
            if (value == null) {
                value = ad.getFixedValue();
            }
            if (resolver.isRequired(attrKey, a)) {
                value = (String)value + " *";
            }
            return value;
        }
        return super.getPropertyDisplayName(resolver, a, ownerNode, ownerKey);
    }

    private boolean _isFixedAttribute(XmlKey key) {
        if (key.getNodeType() == 1) {
            QualifiedName qName = key.getElementQName();
            return qName.getAttributeValue() != null;
        }
        return false;
    }

    private XmlMetadataResolver _getResolver() {
        return this.getView().getXmlMetadataResolver();
    }

    private String _getNodeValue(BaseInspectorGui gui, Node n, XmlKey key, boolean useDefault) {
        Node child;
        NamedNodeMap map;
        String value = null;
        QualifiedName qName = SimpleElementPropertyRow._getQName(gui, key);
        if (qName == _sTextQName) {
            if (n != null) {
                value = DomUtils.getTextContent((Node)n);
            }
            if (useDefault && value == null) {
                value = this.getGui().getView().getXmlMetadataResolver().getDefaultValue(this.getOwner(), n, key);
            }
            if (value == null) {
                if (n == null) {
                    return null;
                }
                return "";
            }
            return value;
        }
        if (n != null && (map = n.getAttributes()) != null && (child = map.getNamedItemNS(qName.getNamespace(), qName.getName())) != null) {
            return child.getNodeValue();
        }
        if (useDefault) {
            value = this.getDefaultValue();
        }
        return value;
    }

    private static QualifiedName _getQName(BaseInspectorGui gui, XmlKey key) {
        String source = gui.getView().getXmlMetadataResolver().getVirtualAttributeDataSource(key);
        if (source == null || source.equals("##text")) {
            return _sTextQName;
        }
        return SimpleElementPropertyRow._getQName(gui, source);
    }

    private static QualifiedName _getQName(BaseInspectorGui gui, String source) {
        String namespace = null;
        String localName = null;
        String[] split = source.split(":");
        if (split.length == 1) {
            localName = split[0];
        } else {
            namespace = gui.getView().getXmlMetadataResolver().getNamespaceURIFromPrefix(split[0]);
            localName = split[1];
        }
        return QualifiedName.getQualifiedName(namespace, (String)localName);
    }

    private QualifiedName _getQName(XmlKey key) {
        if (this._qName == null) {
            this._qName = SimpleElementPropertyRow._getQName(this.getGui(), key);
        }
        return this._qName;
    }
}

