/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.tracking;

import java.util.HashMap;
import java.util.Map;
import oracle.bali.xml.dom.AbstractNode;
import oracle.bali.xml.dom.tracking.TrackingAttr;
import oracle.bali.xml.dom.tracking.TrackingDocument;
import oracle.bali.xml.dom.tracking.TrackingElement;
import oracle.bali.xml.dom.tracking.TrackingEventHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TrackingNode
extends AbstractNode {
    private final TrackingEventHandler _handler;
    private final Node _realNode;
    private static final Map _nodes = new HashMap();

    protected TrackingNode(TrackingEventHandler handler, Node realNode) {
        if (realNode == null || handler == null) {
            throw new IllegalArgumentException();
        }
        this._handler = handler;
        this._realNode = realNode;
    }

    @Override
    public String getNodeName() {
        this.handleRead();
        return this._realNode.getNodeName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        this.handleRead();
        return this._realNode.getNodeValue();
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        this.handleWrite();
        this._realNode.setNodeValue(nodeValue);
    }

    @Override
    public short getNodeType() {
        this.handleRead();
        return this._realNode.getNodeType();
    }

    @Override
    public Node getParentNode() {
        this.handleRead();
        return this.createTrackingNode(this._realNode.getParentNode());
    }

    @Override
    public NodeList getChildNodes() {
        this.handleRead();
        return new TrackingNodeList(this._realNode.getChildNodes());
    }

    @Override
    public Node getFirstChild() {
        this.handleRead();
        return this.createTrackingNode(this._realNode.getFirstChild());
    }

    @Override
    public Node getLastChild() {
        this.handleRead();
        return this.createTrackingNode(this._realNode.getLastChild());
    }

    @Override
    public Node getPreviousSibling() {
        this.handleRead();
        return this.createTrackingNode(this._realNode.getPreviousSibling());
    }

    @Override
    public Node getNextSibling() {
        this.handleRead();
        return this.createTrackingNode(this._realNode.getNextSibling());
    }

    @Override
    public NamedNodeMap getAttributes() {
        this.handleRead();
        NamedNodeMap map = this._realNode.getAttributes();
        if (map == null) {
            return null;
        }
        return new TrackingNamedNodeMap(map);
    }

    @Override
    public Document getOwnerDocument() {
        this.handleRead();
        return (Document)this.createTrackingNode(this._realNode.getOwnerDocument());
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        this.handleWrite();
        return this.createTrackingNode(this._realNode.insertBefore(newChild, refChild));
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.handleWrite();
        return this.createTrackingNode(this._realNode.replaceChild(newChild, oldChild));
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        this.handleWrite();
        return this.createTrackingNode(this._realNode.removeChild(oldChild));
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        this.handleWrite();
        return this.createTrackingNode(this._realNode.appendChild(newChild));
    }

    @Override
    public boolean hasChildNodes() {
        this.handleRead();
        return this._realNode.hasChildNodes();
    }

    @Override
    public Node cloneNode(boolean deep) {
        this.handleRead();
        return this.createTrackingNode(this._realNode.cloneNode(deep));
    }

    @Override
    public void normalize() {
        this.handleWrite();
        this._realNode.normalize();
    }

    @Override
    public boolean isSupported(String feature, String version) {
        this.handleRead();
        return this._realNode.isSupported(feature, version);
    }

    @Override
    public String getNamespaceURI() {
        this.handleRead();
        return this._realNode.getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        this.handleRead();
        return this._realNode.getPrefix();
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        this.handleWrite();
        this._realNode.setPrefix(prefix);
    }

    @Override
    public String getLocalName() {
        this.handleRead();
        return this._realNode.getLocalName();
    }

    @Override
    public boolean hasAttributes() {
        this.handleRead();
        return this._realNode.hasAttributes();
    }

    public static Document createDocument(TrackingEventHandler handler, Document doc) {
        return (Document)TrackingNode.createTrackingNode(handler, doc);
    }

    public boolean equals(Object other) {
        if (other instanceof TrackingNode) {
            other = ((TrackingNode)other).getRealNode();
        }
        return this._realNode != null ? this._realNode.equals(other) : false;
    }

    public int hashCode() {
        return this._realNode.hashCode();
    }

    protected void handleRead() {
        this.getHandler().handleRead(this.getRealNode());
    }

    protected void handleWrite() {
        this.getHandler().handleWrite(this.getRealNode());
    }

    protected Node getRealNode() {
        return this._realNode;
    }

    protected TrackingEventHandler getHandler() {
        return this._handler;
    }

    protected Node createTrackingNode(Node node) {
        return TrackingNode.createTrackingNode(this.getHandler(), node);
    }

    protected static synchronized Node createTrackingNode(TrackingEventHandler handler, Node node) {
        if (node == null) {
            return null;
        }
        Node n = (Node)_nodes.get(node);
        if (n == null) {
            short nodeType = node.getNodeType();
            switch (nodeType) {
                case 2: {
                    n = new TrackingAttr(handler, (Attr)node);
                    break;
                }
                case 1: {
                    n = new TrackingElement(handler, (Element)node);
                    break;
                }
                case 9: {
                    n = new TrackingDocument(handler, (Document)node);
                }
            }
            if (n == null) {
                n = node;
            }
            _nodes.put(node, n);
        }
        return n;
    }

    public class TrackingNodeList
    implements NodeList {
        private final NodeList _real;

        public TrackingNodeList(NodeList real) {
            this._real = real;
        }

        @Override
        public int getLength() {
            return this._real.getLength();
        }

        @Override
        public Node item(int index) {
            return TrackingNode.this.createTrackingNode(this._real.item(index));
        }
    }

    public class TrackingNamedNodeMap
    implements NamedNodeMap {
        private final NamedNodeMap _realMap;

        public TrackingNamedNodeMap(NamedNodeMap real) {
            this._realMap = real;
        }

        @Override
        public int getLength() {
            return this._realMap.getLength();
        }

        @Override
        public Node getNamedItem(String name) {
            return TrackingNode.this.createTrackingNode(this._realMap.getNamedItem(name));
        }

        @Override
        public Node getNamedItemNS(String ns, String name) {
            return TrackingNode.this.createTrackingNode(this._realMap.getNamedItemNS(ns, name));
        }

        @Override
        public Node item(int index) {
            return TrackingNode.this.createTrackingNode(this._realMap.item(index));
        }

        @Override
        public Node removeNamedItem(String name) {
            return TrackingNode.this.createTrackingNode(this._realMap.removeNamedItem(name));
        }

        @Override
        public Node removeNamedItemNS(String ns, String name) {
            return TrackingNode.this.createTrackingNode(this._realMap.removeNamedItemNS(ns, name));
        }

        @Override
        public Node setNamedItem(Node arg) {
            return TrackingNode.this.createTrackingNode(this._realMap.setNamedItem(arg));
        }

        @Override
        public Node setNamedItemNS(Node arg) {
            return TrackingNode.this.createTrackingNode(this._realMap.setNamedItemNS(arg));
        }
    }
}

