/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.impl;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.bali.xml.dom.DomCommitException;
import oracle.bali.xml.dom.NodeChangeDetails;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.impl.ChangeRecord;
import oracle.bali.xml.dom.impl.DomModelImpl;
import oracle.bali.xml.dom.impl.DomModelTransaction;
import oracle.bali.xml.dom.impl.NCDImpl;
import oracle.bali.xml.dom.impl.RemovedSubtreeListener;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Node;
import org.w3c.dom.events.MutationEvent;

class ChildDomModelTransaction
extends DomModelTransaction {
    private DomModelTransaction _parent;
    private String _description;
    private Node _changeTarget;
    private int _changeFlags;
    private NodeChangeDetails _details = new NCDImpl();
    private final List _mutationChanges = new LinkedList();
    private final List<RemovedSubtreeListener> _removedSubtreeListeners = new LinkedList<RemovedSubtreeListener>();

    ChildDomModelTransaction(DomModelImpl model, DomModelTransaction parentTransaction, String description) {
        super(model);
        if (parentTransaction == null) {
            throw new IllegalArgumentException();
        }
        this._parent = parentTransaction;
        this._description = description;
    }

    @Override
    protected final Node getChangeTarget() {
        return this._changeTarget;
    }

    @Override
    protected final int getChangeFlags() {
        return this._changeFlags;
    }

    public List getMutationChanges() {
        return this._mutationChanges;
    }

    public NodeChangeDetails getNodeChangeDetails() {
        return this._details;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public DomCommitException precommit() {
        DomModelTransaction parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("No transaction started");
        }
        return parent.precommitChild(this.getChangeIncrement());
    }

    @Override
    public DomModelTransaction commit() {
        DomModelTransaction parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("No transaction started");
        }
        parent.commitChild(this.getChangeIncrement());
        this._parent = null;
        return parent;
    }

    @Override
    public boolean hasModifications() {
        return !this._mutationChanges.isEmpty() || super.hasModifications();
    }

    public String toString() {
        return super.toString() + "desc=" + this._description + ", parent=" + this._parent;
    }

    @Override
    protected DomModelTransaction getParent() {
        return this._parent;
    }

    protected int getChangeIncrement() {
        return this._changeTarget != null ? 1 : 0;
    }

    protected boolean modifiesUndoStack() {
        return true;
    }

    @Override
    public Node getCommittedChangeTarget() {
        ChildDomModelTransaction child = this.getChild();
        if (child != null) {
            return DomUtils.lowestCommonAncestor((Node)this._changeTarget, (Node)child.getCommittedChangeTarget());
        }
        return this._changeTarget;
    }

    @Override
    protected void updateChangeTarget(ChildDomModelTransaction child, int changeIncrement) {
        Node changeTarget = child.getChangeTarget();
        if (changeTarget != null) {
            this._mutationChanges.add(child.getMutationChanges());
            if (this._details != NodeChangeDetails.NO_DETAILS_AVAILABLE) {
                NodeChangeDetails childDetails = child.getNodeChangeDetails();
                this._details = childDetails == NodeChangeDetails.NO_DETAILS_AVAILABLE ? NodeChangeDetails.NO_DETAILS_AVAILABLE : this._details.addDetails(childDetails);
            }
            if (this._changeTarget != null && DomUtils.isInDocumentHierarchy((Node)this._changeTarget)) {
                changeTarget = DomUtils.lowestCommonAncestor((Node)this._changeTarget, (Node)changeTarget);
            }
            this._removedSubtreeListeners.addAll(child._removedSubtreeListeners);
            if (this._description == null) {
                this._description = child.getDescription();
            }
            this._changeTarget = changeTarget;
            this._changeFlags |= child.getChangeFlags();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleMutationEventHook(Node mergeNode, int changeFlag, ChangeRecord changeRecord, MutationEvent mEvent) {
        DomChange change = changeRecord.getChange();
        final Node changedNode = changeRecord.getAssociatedNode();
        this.getModel().handleUncommittedMutationEventHook(change, mEvent, this.modifiesUndoStack());
        ChildDomModelTransaction childDomModelTransaction = this;
        synchronized (childDomModelTransaction) {
            this._changeTarget = DomUtils.lowestCommonAncestor((Node)this._changeTarget, (Node)mergeNode);
            this._changeFlags |= changeFlag;
        }
        this._mutationChanges.add(changeRecord);
        if (this._details != NodeChangeDetails.NO_DETAILS_AVAILABLE) {
            NCDImpl details = (NCDImpl)this._details;
            details.__processChange(changeRecord);
        }
        change.process(new DomChangeHandler(){

            @Override
            public void handleNodeInsertedChange(NodeInsertedChange change) {
                ChildDomModelTransaction txn = ChildDomModelTransaction.this;
                while (txn != null) {
                    Iterator<RemovedSubtreeListener> itor = txn._removedSubtreeListeners.iterator();
                    while (itor.hasNext()) {
                        RemovedSubtreeListener rsl = itor.next();
                        if (!rsl.isRemovedNodeInHierarchyNow()) continue;
                        itor.remove();
                        rsl.dispose();
                    }
                    if (txn._parent instanceof ChildDomModelTransaction) {
                        txn = (ChildDomModelTransaction)txn._parent;
                        continue;
                    }
                    txn = null;
                }
            }

            @Override
            public void handleNodeRemovedChange(NodeRemovedChange change) {
                ChildDomModelTransaction.this._removedSubtreeListeners.add(new RemovedSubtreeListener(changedNode, ChildDomModelTransaction.this.getModel().getLogger(), new Exception("deletion trace")));
            }

            @Override
            public void handleNodeValueChange(NodeValueChange change) {
            }

            @Override
            public void handleAttrAddedChange(AttrAddedChange change) {
            }

            @Override
            public void handleAttrRemovedChange(AttrRemovedChange change) {
            }

            @Override
            public void handleAttrValueChange(AttrValueChange change) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DomModelTransaction rollback() {
        DomModelTransaction parent;
        ChildDomModelTransaction childDomModelTransaction = this;
        synchronized (childDomModelTransaction) {
            parent = this._parent;
            this._parent = null;
            if (parent == null) {
                throw new IllegalStateException("No transaction started");
            }
            this.__disposeAllRemovedSubtreeListeners();
            parent.rollbackChild();
            DomModelImpl model = this.getModel();
            model.__removeDocListeners();
            this.rollbackChanges(this._mutationChanges);
            model.__addDocListeners();
        }
        return parent;
    }

    void __disposeAllRemovedSubtreeListeners() {
        for (RemovedSubtreeListener rsl : this._removedSubtreeListeners) {
            rsl.dispose();
        }
    }
}

