/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer.lexer;

import oracle.bali.xml.dom.buffer.lexer.XMLTokens;
import oracle.javatools.parser.AbstractLexer;
import oracle.javatools.parser.LexerToken;

public class XMLLexer
extends AbstractLexer
implements XMLTokens {
    private int lastToken = -1;
    private int startOffset = -1;
    private int endOffset = -1;
    private boolean useLastToken = false;
    private boolean skipComments = false;

    public XMLLexer() {
        this.setTextBuffer(null);
        this.setPosition(0);
    }

    public void setSkipComments(boolean skipComments) {
        this.skipComments = skipComments;
    }

    public int lex(LexerToken lexedToken) {
        int endTextOffset;
        block33: {
            if (this.useLastToken) {
                this.useLastToken = false;
                return this.fillLexerToken(lexedToken);
            }
            int startTextOffset = -1;
            endTextOffset = -1;
            this.lastToken = 0;
            try {
                block11: while (true) {
                    char c = this.textBuffer.getChar(this.currentPos++);
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            if (startTextOffset == -1) {
                                startTextOffset = this.currentPos - 1;
                            }
                            endTextOffset = this.currentPos;
                            continue block11;
                        }
                    }
                    this.startOffset = this.currentPos - 1;
                    switch (c) {
                        case '<': {
                            if (startTextOffset != -1) {
                                this.lastToken = 16;
                                --this.currentPos;
                                this.startOffset = startTextOffset;
                            } else {
                                this.lastToken = 12;
                                if (this.textBuffer.getChar(this.currentPos) == '!') {
                                    ++this.currentPos;
                                    this.lastToken = 16;
                                    if (this.textBuffer.getChar(this.currentPos) == '-' && this.textBuffer.getChar(this.currentPos + 1) == '-') {
                                        this.currentPos += 2;
                                        this.lastToken = 13;
                                        this.skipComment();
                                        if (this.skipComments) {
                                            this.lastToken = 0;
                                            break;
                                        }
                                    } else if (this.textBuffer.getChar(this.currentPos) == '[') {
                                        if (this.textBuffer.getChar(this.currentPos + 1) == 'C' && this.textBuffer.getChar(this.currentPos + 2) == 'D' && this.textBuffer.getChar(this.currentPos + 3) == 'A' && this.textBuffer.getChar(this.currentPos + 4) == 'T' && this.textBuffer.getChar(this.currentPos + 5) == 'A' && this.textBuffer.getChar(this.currentPos + 6) == '[') {
                                            this.lastToken = 17;
                                            this.skipCDATASection();
                                        }
                                    } else if (this.textBuffer.getChar(this.currentPos) == 'D' && this.textBuffer.getChar(this.currentPos + 1) == 'O' && this.textBuffer.getChar(this.currentPos + 2) == 'C' && this.textBuffer.getChar(this.currentPos + 3) == 'T' && this.textBuffer.getChar(this.currentPos + 4) == 'Y' && this.textBuffer.getChar(this.currentPos + 5) == 'P' && this.textBuffer.getChar(this.currentPos + 6) == 'E') {
                                        this.lastToken = 18;
                                        this.skipDocumentType();
                                    }
                                } else if (this.textBuffer.getChar(this.currentPos) == '?') {
                                    ++this.currentPos;
                                    this.lastToken = 15;
                                    if (this.textBuffer.getChar(this.currentPos) == 'x' && this.textBuffer.getChar(this.currentPos + 1) == 'm' && this.textBuffer.getChar(this.currentPos + 2) == 'l') {
                                        this.lastToken = 14;
                                        switch (this.textBuffer.getChar(this.currentPos + 3)) {
                                            case '\t': 
                                            case '\n': 
                                            case '\f': 
                                            case '\r': 
                                            case ' ': 
                                            case '?': {
                                                this.skipDeclaration();
                                                break;
                                            }
                                            default: {
                                                this.lastToken = 15;
                                                this.skipProcessingInstruction();
                                                break;
                                            }
                                        }
                                    } else {
                                        this.skipProcessingInstruction();
                                    }
                                } else {
                                    this.lastToken = this.skipElementTag();
                                }
                            }
                            break block33;
                        }
                        default: {
                            if (startTextOffset == -1) {
                                startTextOffset = this.currentPos - 1;
                            }
                            endTextOffset = this.currentPos;
                            break;
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.currentPos = this.textBuffer.getLength();
                if (this.lastToken == 0) {
                    if (startTextOffset != -1) {
                        this.lastToken = 16;
                        this.startOffset = startTextOffset;
                    } else {
                        this.startOffset = this.currentPos;
                    }
                }
                if (!this.skipComments || this.lastToken != 13) break block33;
                this.lastToken = 0;
                this.startOffset = this.currentPos;
            }
        }
        this.endOffset = endTextOffset == -1 ? this.currentPos : endTextOffset;
        this.useLastToken = false;
        return this.fillLexerToken(lexedToken);
    }

    public void backup() {
        this.useLastToken = true;
    }

    public void setPosition(int offset) {
        super.setPosition(offset);
        this.useLastToken = false;
    }

    private void skipComment() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '-' || this.textBuffer.getChar(this.currentPos) != '-' || this.textBuffer.getChar(this.currentPos + 1) != '>') {
        }
        this.currentPos += 2;
    }

    private int skipElementTag() {
        boolean terminatedNormally = this.skipToTagEnd();
        if (terminatedNormally) {
            return 11;
        }
        return 12;
    }

    private void skipDocumentType() {
        this.currentPos += 7;
        char quote = '\u0000';
        boolean inBracket = false;
        block7: while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\"': 
                case '\'': {
                    if (quote != '\u0000') {
                        if (quote != c) continue block7;
                        quote = '\u0000';
                        continue block7;
                    }
                    quote = c;
                    continue block7;
                }
                case '[': {
                    if (quote != '\u0000') continue block7;
                    inBracket = true;
                    continue block7;
                }
                case ']': {
                    if (quote != '\u0000') continue block7;
                    inBracket = false;
                    continue block7;
                }
                case '>': {
                    if (quote != '\u0000' || inBracket) continue block7;
                    return;
                }
                case '<': {
                    if (inBracket) continue block7;
                    --this.currentPos;
                    return;
                }
            }
        }
    }

    private void skipCDATASection() {
        char c;
        this.currentPos += 7;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != ']' || this.textBuffer.getChar(this.currentPos) != ']' || this.textBuffer.getChar(this.currentPos + 1) != '>') {
        }
        this.currentPos += 2;
    }

    private void skipDeclaration() {
        this.skipToTagEnd();
    }

    private void skipProcessingInstruction() {
        char c;
        while ((c = this.textBuffer.getChar(this.currentPos++)) != '?' || this.textBuffer.getChar(this.currentPos) != '>') {
        }
        ++this.currentPos;
    }

    private boolean skipToTagEnd() {
        char quote = '\u0000';
        block5: while (true) {
            char c = this.textBuffer.getChar(this.currentPos++);
            switch (c) {
                case '\"': 
                case '\'': {
                    if (quote != '\u0000') {
                        if (quote != c) continue block5;
                        quote = '\u0000';
                        continue block5;
                    }
                    quote = c;
                    continue block5;
                }
                case '>': {
                    if (quote != '\u0000') continue block5;
                    return true;
                }
                case '<': {
                    --this.currentPos;
                    return false;
                }
            }
        }
    }

    private int fillLexerToken(LexerToken lexedToken) {
        AbstractLexer.DefaultLexerToken outToken = (AbstractLexer.DefaultLexerToken)lexedToken;
        outToken.setToken(this.lastToken);
        outToken.setStartOffset(this.startOffset);
        outToken.setEndOffset(this.endOffset);
        return this.lastToken;
    }

    public static String tokenToString(int token) {
        switch (token) {
            case 11: {
                return "TK_XML_ELEMENT";
            }
            case 12: {
                return "TK_XML_ELEMENT_INCOMPLETE";
            }
            case 13: {
                return "TK_XML_COMMENT";
            }
            case 14: {
                return "TK_XML_DECLARATION";
            }
            case 15: {
                return "TK_XML_PROCESSING_INSTRUCTION";
            }
            case 16: {
                return "TK_XML_TEXT";
            }
            case 17: {
                return "TK_XML_CDATA";
            }
            case 18: {
                return "TK_XML_DOCUMENT_TYPE";
            }
        }
        return "**UNKNOWN**";
    }

    public static String tokenToText(int token) {
        switch (token) {
            case 11: {
                return "XML Element";
            }
            case 12: {
                return "XML Element Incomplete";
            }
            case 13: {
                return "XML Comment";
            }
            case 14: {
                return "XML Declaration";
            }
            case 15: {
                return "XML Processing Instruction";
            }
            case 16: {
                return "XML Text";
            }
            case 17: {
                return "XML CDATA Section";
            }
            case 18: {
                return "XML Document Type";
            }
        }
        return "**UNKNOWN**";
    }
}

