/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom.buffer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.bali.xml.dom.buffer.BufferDomDocumentParser;
import oracle.bali.xml.dom.buffer.locator.AttributeLocator;
import oracle.bali.xml.dom.buffer.locator.ElementLocator;
import oracle.bali.xml.dom.buffer.locator.Locator;
import oracle.bali.xml.dom.buffer.locator.SimpleLocator;
import oracle.bali.xml.dom.buffer.locator.TextLocator;
import oracle.bali.xml.dom.impl.DomModelPlugin;
import oracle.bali.xml.dom.impl.DomModelPluginContext;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class LocatorAwareDomModelPlugin
extends DomModelPlugin {
    protected LocatorAwareDomModelPlugin(DomModelPluginContext context) {
        super(context);
    }

    public Locator getLocator(Node node) {
        this.getContext().verifyLock();
        return this._getLocatorDirectly(node);
    }

    public Locator getDocumentTypeLocator() {
        this.getContext().verifyLock();
        return (Locator)this.getLocatorMap().get(BufferDomDocumentParser.DOCUMENT_TYPE_LOCATOR_KEY);
    }

    protected abstract HashMap getLocatorMap();

    protected abstract int getDocumentLength();

    @Override
    protected void getTextOffsets(Node node, int[] results) {
        if (DomUtils.isDocument((Node)node)) {
            results[0] = 0;
            results[1] = this.getDocumentLength();
        } else {
            Locator loc = this._getLocatorDirectly(node);
            if (loc == null) {
                super.getTextOffsets(node, results);
            } else {
                results[0] = loc.getStartOffset();
                results[1] = loc.getEndOffset();
            }
        }
    }

    @Override
    protected int getTextOffset(DomPosition pos) {
        Node node = pos.getTargetNode();
        int relPos = pos.getRelativePosition();
        Locator loc = this._getLocatorDirectly(node);
        if (loc != null) {
            switch (relPos) {
                case 1: {
                    return loc.getStartOffset();
                }
                case 2: {
                    return loc.getEndOffset();
                }
                case 0: {
                    if (pos.hasTextOffset()) {
                        return this._getSubNodeTextOffset(pos, loc);
                    }
                    if (DomUtils.isElement((Node)node)) {
                        Locator lastChildLoc;
                        Node lastChild = node.getLastChild();
                        if (lastChild != null && (lastChildLoc = this._getLocatorDirectly(lastChild)) != null) {
                            return lastChildLoc.getEndOffset();
                        }
                        ElementLocator eLoc = (ElementLocator)loc;
                        SimpleLocator endTagLoc = eLoc.getEndTagLocator();
                        if (endTagLoc != null) {
                            return ((Locator)endTagLoc).getStartOffset();
                        }
                        return loc.getEndOffset();
                    }
                    return loc.getEndOffset();
                }
            }
        }
        return -1;
    }

    @Override
    protected Node getNodeAtOffset(int offset) {
        return this._getNodeAtOffsetHelper(this.getContext().getDocument(), offset);
    }

    @Override
    protected DomPosition getDomPosition(int caretPosition, boolean considerAttrs) {
        DomPosition domPos = null;
        Node containingNode = this._getNodeContainingCaretPosition(this.getContext().getDocument(), caretPosition);
        if (containingNode == null) {
            containingNode = this.getContext().getDocument();
        }
        if (containingNode != null) {
            SimpleLocator startLocator;
            ElementLocator elementLocator;
            if (containingNode.getNodeType() == 1 && (elementLocator = (ElementLocator)this._getLocatorDirectly(containingNode)) != null && (startLocator = elementLocator.getStartTagLocator()) != null && startLocator.containsNotAtStart(caretPosition)) {
                NamedNodeMap attrs;
                if (considerAttrs && (attrs = containingNode.getAttributes()) != null) {
                    int numAttrs = attrs.getLength();
                    for (int i = 0; i < numAttrs; ++i) {
                        TextLocator valueLocator;
                        Attr attr = (Attr)attrs.item(i);
                        AttributeLocator attrLocator = (AttributeLocator)this._getLocatorDirectly(attr);
                        if (attrLocator == null || (valueLocator = attrLocator.getValueLocator()) == null || !valueLocator.containsNotAtStart(caretPosition)) continue;
                        int domContentPosition = 0;
                        domPos = DomPositionFactory.createAttributePosition((Attr)attr, (int)domContentPosition);
                        break;
                    }
                }
                if (domPos == null) {
                    domPos = DomPositionFactory.inside((Node)containingNode);
                }
            }
            if (domPos == null) {
                Locator loc;
                Node firstChild = containingNode.getFirstChild();
                if (firstChild != null) {
                    Node nodeBeforeCaret = null;
                    for (Node current = firstChild; current != null; current = current.getNextSibling()) {
                        Locator childLocator = this._getLocatorDirectly(current);
                        if (childLocator == null) continue;
                        if (caretPosition < childLocator.getEndOffset()) break;
                        nodeBeforeCaret = current;
                    }
                    domPos = nodeBeforeCaret != null ? DomPositionFactory.after(nodeBeforeCaret) : DomPositionFactory.before((Node)firstChild);
                } else if (DomUtils.isText((Node)containingNode)) {
                    loc = (TextLocator)this._getLocatorDirectly(containingNode);
                    if (loc != null) {
                        int contentPos = this._convertToDomContentPosition((TextLocator)loc, caretPosition);
                        return DomPositionFactory.createTextPosition((CharacterData)((Text)containingNode), (int)contentPos);
                    }
                } else if ((DomUtils.isNodeType((Node)containingNode, (int)8) || DomUtils.isNodeType((Node)containingNode, (int)4)) && (loc = (SimpleLocator)this._getLocatorDirectly(containingNode)) != null) {
                    int offset = 4;
                    if (DomUtils.isNodeType((Node)containingNode, (int)4)) {
                        offset = 9;
                    }
                    int pos = caretPosition - ((SimpleLocator)loc).getStartOffset() - offset;
                    int length = containingNode.getNodeValue().length();
                    if (pos < 0) {
                        pos = 0;
                    } else if (pos >= length) {
                        pos = length;
                    }
                    return DomPositionFactory.createTextPosition((CharacterData)((CharacterData)containingNode), (int)pos);
                }
                if (domPos == null) {
                    domPos = DomPositionFactory.createInsideOrAfterPosition((Node)containingNode);
                }
            }
        }
        return domPos;
    }

    protected Locator _getLocatorDirectly(Node node) {
        Locator ret = (Locator)this.getLocatorMap().get(node);
        if (ret != null) {
            return ret;
        }
        if (node == null) {
            throw new IllegalArgumentException("null node");
        }
        if (node.getNodeType() == 10 && node.getOwnerDocument() == this.getContext().getDocument()) {
            return this.getDocumentTypeLocator();
        }
        return null;
    }

    private int _convertToDomContentPosition(TextLocator textLocator, int textBufferCaretPosition) {
        SimpleLocator loc;
        int startOffset;
        int domContentPosition = 0;
        List contentLocators = textLocator.getContentLocators();
        Iterator iter = contentLocators.iterator();
        while (iter.hasNext() && textBufferCaretPosition > (startOffset = (loc = (SimpleLocator)iter.next()).getStartOffset())) {
            int domLength = loc.getDomLength();
            if (textBufferCaretPosition < loc.getEndOffset()) {
                int approxPosInside = textBufferCaretPosition - startOffset;
                if (domLength < approxPosInside) {
                    approxPosInside = domLength;
                }
                domContentPosition += approxPosInside;
                break;
            }
            domContentPosition += domLength;
        }
        return domContentPosition;
    }

    private int _getSubNodeTextOffset(DomPosition pos, Locator loc) {
        Node node = pos.getTargetNode();
        int offset = pos.getTextOffset();
        if (pos.hasAttributeQName()) {
            Attr attr = DomUtils.getAttribute((Element)((Element)node), (QualifiedName)pos.getAttributeQName());
            if (attr == null || this.isUnspecifiedAttribute(attr)) {
                return -1;
            }
            node = attr;
            loc = this._getLocatorDirectly(attr);
        }
        if (offset < 0 || offset > node.getNodeValue().length()) {
            return -1;
        }
        switch (node.getNodeType()) {
            case 3: {
                return ((TextLocator)loc).getContentTextOffset(offset);
            }
            case 2: {
                AttributeLocator al = (AttributeLocator)loc;
                TextLocator valueLoc = al.getValueLocator();
                if (valueLoc == null) {
                    return -1;
                }
                int ret = valueLoc.getContentTextOffset(offset);
                if (ret != -1 && al.isStartQuotePresent()) {
                    ++ret;
                }
                return ret;
            }
            case 4: {
                return loc.getStartOffset() + 9 + offset;
            }
            case 8: {
                return loc.getStartOffset() + 4 + offset;
            }
        }
        throw new IllegalArgumentException("no subnode location for " + pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node _getNodeAtOffsetHelper(Node currentNode, int offset) {
        boolean locatorContainsCurrentNode = false;
        if (currentNode == null) return null;
        Locator currentLocator = this._getLocatorDirectly(currentNode);
        if (currentLocator != null) {
            if (!currentLocator.contains(offset)) return null;
            locatorContainsCurrentNode = true;
        }
        if (currentNode.getNodeType() == 1 || currentNode.getNodeType() == 9) {
            Node nodeAtOffset = null;
            for (Node child = currentNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                nodeAtOffset = this._getNodeAtOffsetHelper(child, offset);
                if (nodeAtOffset == null) continue;
                return nodeAtOffset;
            }
        }
        if (!locatorContainsCurrentNode) return null;
        return currentNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Node _getNodeContainingCaretPosition(Node currentNode, int caretPosition) {
        boolean nodeContainsCaretPosition = false;
        if (currentNode == null) return null;
        Locator currentLocator = this._getLocatorDirectly(currentNode);
        if (currentLocator != null) {
            if (caretPosition <= currentLocator.getStartOffset() || caretPosition >= currentLocator.getEndOffset()) return null;
            nodeContainsCaretPosition = true;
        }
        if (currentNode.getNodeType() == 1 || currentNode.getNodeType() == 9) {
            Node containingNode = null;
            for (Node child = currentNode.getFirstChild(); child != null; child = child.getNextSibling()) {
                containingNode = this._getNodeContainingCaretPosition(child, caretPosition);
                if (containingNode == null) continue;
                return containingNode;
            }
        }
        if (!nodeContainsCaretPosition) return null;
        return currentNode;
    }
}

