/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

public final class XmlDeclarationInfo {
    public static final Float VERSION_1_0 = Float.valueOf(1.0f);
    public static final XmlDeclarationInfo SUITABLE_DEFAULT = new XmlDeclarationInfo(VERSION_1_0, "UTF-8", null);
    private final Float _version;
    private final String _encoding;
    private final Boolean _standalone;

    public XmlDeclarationInfo(Float version, String encoding, Boolean standalone) {
        this._version = version;
        this._encoding = encoding;
        this._standalone = standalone;
    }

    public Float getVersion() {
        return this._version;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public Boolean getStandalone() {
        return this._standalone;
    }

    public StringBuffer getAsXml() {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml ");
        if (this._version != null) {
            XmlDeclarationInfo._addField(buf, "version", this._version);
            XmlDeclarationInfo._addField(buf, "encoding", this._encoding);
            if (this._standalone != null) {
                XmlDeclarationInfo._addField(buf, "standalone", Boolean.TRUE.equals(this._standalone) ? "yes" : "no");
            }
        }
        buf.append("?>");
        return buf;
    }

    public String toString() {
        return this.getAsXml().toString();
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash ^= XmlDeclarationInfo._hash(this._version);
        hash ^= XmlDeclarationInfo._hash(this._encoding);
        return hash ^= XmlDeclarationInfo._hash(this._standalone);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        XmlDeclarationInfo other = (XmlDeclarationInfo)o;
        return XmlDeclarationInfo._eq(this._version, other._version) && XmlDeclarationInfo._eq(this._encoding, other._encoding) && XmlDeclarationInfo._eq(this._standalone, other._standalone);
    }

    private static void _addField(StringBuffer buf, String name, Object value) {
        if (value != null) {
            buf.append(name);
            buf.append("=\"");
            buf.append(value);
            buf.append("\" ");
        }
    }

    private static boolean _eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    private static int _hash(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }
}

