/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.changes.AttrAddedChange;
import oracle.bali.xml.dom.changes.AttrRemovedChange;
import oracle.bali.xml.dom.changes.AttrValueChange;
import oracle.bali.xml.dom.changes.DomChange;
import oracle.bali.xml.dom.changes.DomChangeHandler;
import oracle.bali.xml.dom.changes.DomChangesUndoableEdit;
import oracle.bali.xml.dom.changes.NodeInsertedChange;
import oracle.bali.xml.dom.changes.NodeRemovedChange;
import oracle.bali.xml.dom.changes.NodeValueChange;
import oracle.bali.xml.dom.ref.NodeRef;
import oracle.bali.xml.dom.ref.NonAttrNodeRef;
import oracle.bali.xml.dom.util.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MakeTestCaseUndoableEditListener
implements UndoableEditListener,
DomChangeHandler {
    private final StringBuffer _buffer = new StringBuffer();
    private int _nextVar = 0;
    private static final String _DOC_VAR = "doc";

    public StringBuffer getOutput() {
        return this._buffer;
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent event) {
        UndoableEdit edit = event.getEdit();
        this._line("getDomModel().startTransaction(" + this._literal(edit.getPresentationName()) + ");");
        if (edit instanceof DomChangesUndoableEdit) {
            ((DomChangesUndoableEdit)edit).processChanges(this);
        } else {
            this._line("Unknown UndoableEdit" + edit);
        }
        this._line("");
        this._line("getDomModel().commitTransaction();");
        this._line("");
    }

    @Override
    public void handleAttrAddedChange(AttrAddedChange change) {
        this._setupForNextChange(change);
        String ownerVar = this._localForRef("Element", change.getOwnerElementRef(), true);
        this._setAttr(ownerVar, change.getAddedAttributeClone());
    }

    @Override
    public void handleAttrRemovedChange(AttrRemovedChange change) {
        this._setupForNextChange(change);
        String ownerVar = this._localForRef("Element", change.getOwnerElementRef(), true);
        Attr copy = change.getRemovedAttributeClone();
        this._line(ownerVar + ".removeAttributeNS(" + this._literal(copy.getNamespaceURI()) + ", " + this._literal(DomUtils.getLocalName((Node)copy)) + ");");
    }

    @Override
    public void handleAttrValueChange(AttrValueChange change) {
        this._setupForNextChange(change);
        String nodeVar = this._localForRef(change.getNodeRef());
        this._line(nodeVar + ".setNodeValue(" + this._literal(change.getNewValue()) + ");");
    }

    @Override
    public void handleNodeInsertedChange(NodeInsertedChange change) {
        this._setupForNextChange(change);
        String createVar = this._createSubtree(change.getInsertedNodeClone());
        NonAttrNodeRef ref = (NonAttrNodeRef)change.getNodeRef();
        int[] path = ref.getNodePath();
        int indexInParent = path[path.length - 1];
        StringBuffer parentPathBuf = new StringBuffer("new int[] {");
        for (int i = 0; i < path.length - 1; ++i) {
            if (i != 0) {
                parentPathBuf.append(", ");
            }
            parentPathBuf.append(path[i]);
        }
        parentPathBuf.append("}");
        String parentVar = this._local("DomUtils.getNodeFromPath(doc, " + parentPathBuf + ")");
        this._line("DomUtils.insertChildAtIndex(" + createVar + ", " + parentVar + ", " + indexInParent + ");");
    }

    @Override
    public void handleNodeRemovedChange(NodeRemovedChange change) {
        this._setupForNextChange(change);
        String nodeVar = this._localForRef(change.getNodeRef());
        String parentVar = this._local(nodeVar + ".getParentNode()");
        this._line(parentVar + ".removeChild(" + nodeVar + ");");
    }

    @Override
    public void handleNodeValueChange(NodeValueChange change) {
        this._setupForNextChange(change);
        String nodeVar = this._localForRef(change.getNodeRef());
        this._line(nodeVar + ".setNodeValue(" + this._literal(change.getNewValue()) + ");");
    }

    private String _createSubtree(Node node) {
        NamedNodeMap attrs;
        String createType = "Node";
        String nodeVar = this._local(createType, "doc." + (switch (node.getNodeType()) {
            case 8 -> "createComment(" + this._literal(node.getNodeValue()) + ")";
            case 3 -> "createTextNode(" + this._literal(node.getNodeValue()) + ")";
            case 1 -> {
                createType = "Element";
                yield "createElementNS(" + this._literal(node.getNamespaceURI()) + ", " + this._literal(node.getNodeName()) + ")";
            }
            default -> "????? " + node;
        }), !"Node".equals(createType));
        if (node.getNodeType() == 1 && (attrs = node.getAttributes()) != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                this._setAttr(nodeVar, attr);
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String childVar = this._createSubtree(child);
            this._line(nodeVar + ".appendChild(" + childVar + ");");
        }
        return nodeVar;
    }

    private void _setAttr(String ownerVar, Attr copy) {
        this._line(ownerVar + ".setAttributeNS(" + this._literal(copy.getNamespaceURI()) + ", " + this._literal(copy.getName()) + ", " + this._literal(copy.getValue()) + ");");
    }

    private void _setupForNextChange(DomChange change) {
        this._line("");
        this._line("// " + change);
    }

    private String _localForRef(NodeRef ref) {
        return this._local(ref.getJavaExpression(_DOC_VAR));
    }

    private String _localForRef(String type, NodeRef ref, boolean needsCast) {
        return this._local(type, ref.getJavaExpression(_DOC_VAR), needsCast);
    }

    private String _localForRef(String type, NodeRef ref) {
        return this._localForRef(type, ref, false);
    }

    private String _local(String value) {
        return this._local("Node", value);
    }

    private String _local(String type, String value) {
        return this._local(type, value, false);
    }

    private String _local(String type, String value, boolean needsCast) {
        String var = this._getNextVariable();
        Object cast = needsCast ? "(" + type + ") " : "";
        this._line(type + " " + var + " = " + (String)cast + value + ";");
        return var;
    }

    private void _line(String s) {
        if (s.length() > 0) {
            this._buffer.append("    ");
            this._buffer.append(s);
        }
        this._buffer.append("\n");
    }

    private String _literal(String s) {
        return s == null ? "null" : "\"" + s + "\"";
    }

    private String _getNextVariable() {
        String val = "node_" + this._nextVar;
        ++this._nextVar;
        return val;
    }
}

