/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.dom;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Node;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public abstract class DomParseProblem
extends SAXParseException
implements Comparable {
    public static final int SEVERITY_INFO = 0;
    public static final int SEVERITY_WARNING = 1;
    public static final int SEVERITY_ERROR = 2;
    public static final int SEVERITY_FATAL_ERROR = 3;
    private Map<String, Object> _parametersMap = new ConcurrentHashMap<String, Object>(2);

    protected DomParseProblem() {
        super((String)null, (Locator)null);
    }

    @Override
    public abstract String getMessage();

    public abstract int getSeverity();

    public int getProblemTextStartOffset() {
        return -1;
    }

    public int getProblemTextEndOffset() {
        return -1;
    }

    public Node getProblemNode() {
        return null;
    }

    public String getErrCode() {
        return null;
    }

    public void dispose() {
    }

    public int compareTo(Object o) {
        int otherStart;
        DomParseProblem other = (DomParseProblem)o;
        int myStart = this.getProblemTextStartOffset();
        if (myStart == (otherStart = other.getProblemTextStartOffset())) {
            int myEnd = this.getProblemTextEndOffset();
            int otherEnd = other.getProblemTextEndOffset();
            if (myEnd == -1) {
                myEnd = myStart;
            }
            if (otherEnd == -1) {
                otherEnd = otherStart;
            }
            return myEnd - otherEnd;
        }
        if (myStart == -1) {
            return 1;
        }
        if (otherStart == -1) {
            return -1;
        }
        return myStart - otherStart;
    }

    public Map<String, Object> getParameters() {
        return this._parametersMap;
    }

    public Object getParameter(String key) {
        return this._parametersMap.get(key);
    }

    public Object putParameter(String key, Object value) {
        return this._parametersMap.put(key, value);
    }

    public void putAllParameters(Map<String, Object> params) {
        this._parametersMap.putAll(params);
    }
}

