/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel.impl.handlers.element;

import java.lang.reflect.Method;
import java.util.List;
import oracle.bali.xml.beanmodel.XmlBaseType;
import oracle.bali.xml.beanmodel.annotation.Operation;
import oracle.bali.xml.beanmodel.annotation.OperationLiteral;
import oracle.bali.xml.beanmodel.impl.DynamicProxyContext;
import oracle.bali.xml.beanmodel.impl.DynamicProxyFactory;
import oracle.bali.xml.beanmodel.impl.handlers.element.ElementInvocationHandler;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ElementCreateInvocationHandler
extends ElementInvocationHandler {
    @Override
    public Operation getOperation() {
        return new OperationLiteral("create");
    }

    @Override
    protected Object invokeImpl(XmlBaseType proxy, Method method, Object[] args, DynamicProxyContext context, Element parent, XmlKey childKey, List<QualifiedName> childNames) throws Throwable {
        QualifiedName childName = childNames.get(0);
        Class returnType = method.getReturnType();
        if (args != null && args.length == 2) {
            if (args[0] instanceof QualifiedName) {
                childName = (QualifiedName)args[0];
            }
            if (args[1] instanceof Class) {
                returnType = (Class)args[1];
            }
        }
        if (!XmlBaseType.class.isAssignableFrom(returnType)) {
            throw new IllegalStateException("ElementCreateInvocationHandler asked to create a type that does not extend XmlBaseType");
        }
        if (!childNames.contains(childName)) {
            throw new IllegalStateException("ElementCreateInvocationHandler asked to create an invalid element");
        }
        XmlModel model = context.getXmlModel();
        Document document = model.getDocument();
        Element newElement = document.createElementNS(childName.getNamespace(), childName.getName());
        XmlKey derivedKey = context.getXmlModel().getElementKey(context.getXmlKey(), childName);
        DynamicProxyContext newContext = new DynamicProxyContext(model, newElement, derivedKey, returnType.getClassLoader());
        context.addAssociatedContext(newContext);
        return DynamicProxyFactory.getInstance().createProxyInstance(newContext, returnType);
    }
}

