/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.beanmodel.XmlBaseType;
import oracle.bali.xml.beanmodel.impl.DynamicProxyContext;
import oracle.bali.xml.beanmodel.impl.DynamicProxyFactory;
import oracle.bali.xml.beanmodel.versioning.VersionManager;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.task.ReadOnlyTask;
import org.w3c.dom.Node;

public class ReadOnlyBeanTask<R, T extends XmlBaseType> {
    private Class<T> _clazz;
    private QualifiedName _qName;
    private static final Logger _LOGGER = Logger.getLogger(ReadOnlyBeanTask.class.getName());

    public ReadOnlyBeanTask(Class<T> clazz, QualifiedName qName) {
        if (qName == null) {
            throw new IllegalArgumentException("ReadOnlyBeanTask requires a qualified name which is not null");
        }
        this._clazz = clazz;
        this._qName = qName;
    }

    public final R run(XmlContext xmlContext) {
        return this.run(xmlContext.getModel(), null);
    }

    public final R run(AbstractModel model) {
        return this.run(model, null);
    }

    public final R run(AbstractModel model, final Node node) {
        ReadOnlyTask task = new ReadOnlyTask<R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected R runImpl(AbstractModel model) {
                VersionManager versionManager;
                XmlModel baseModel = model.getBaseModel();
                Node typeNode = node;
                if (typeNode == null) {
                    typeNode = baseModel.getDocument().getDocumentElement();
                }
                QualifiedName validQName = (versionManager = baseModel.getContext().getVersionManager()) != null ? versionManager.getVersionQualifiedName(ReadOnlyBeanTask.this._qName) : ReadOnlyBeanTask.this._qName;
                XmlKey key = null;
                if (typeNode == null) {
                    typeNode = baseModel.getDocument().createElementNS(validQName.getNamespace(), validQName.getName());
                    key = ImmutableXmlKey.createElementKey((QualifiedName)validQName);
                } else {
                    if (!baseModel.isInModelDocumentHierarchy(typeNode)) {
                        throw new IllegalArgumentException("ReadOnlyBeanTask.run method passed a Node that is not in the model's document hierarchy");
                    }
                    key = model.getNodeXmlKey(typeNode);
                }
                QualifiedName typeNodeQName = DomUtils.getQualifiedName((Node)typeNode);
                if (!validQName.equals((Object)typeNodeQName)) {
                    String msg = "The node doesn't match, namespace: " + validQName.getNamespace() + " name: " + validQName.getName();
                    _LOGGER.log(Level.WARNING, msg);
                    return null;
                }
                DynamicProxyContext context = new DynamicProxyContext(baseModel, typeNode, key, ReadOnlyBeanTask.this._clazz.getClassLoader());
                Object type = ReadOnlyBeanTask.this.getType(context);
                try {
                    Object r = ReadOnlyBeanTask.this.performTask(type);
                    return r;
                }
                finally {
                    context.setExpired();
                }
            }
        };
        return (R)task.run(model);
    }

    protected R performTask(T type) {
        return null;
    }

    private final T getType(DynamicProxyContext context) {
        return (T)((XmlBaseType)DynamicProxyFactory.getInstance().createProxyInstance(context, this._clazz));
    }
}

