/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.beanmodel;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.beanmodel.XmlBaseType;
import oracle.bali.xml.beanmodel.impl.DynamicProxyContext;
import oracle.bali.xml.beanmodel.impl.DynamicProxyFactory;
import oracle.bali.xml.beanmodel.versioning.VersionManager;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.TransactionToken;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeanTask<T extends XmlBaseType> {
    private Class<T> _clazz;
    private String _txnName;
    private QualifiedName _qName;
    private static final Logger _LOGGER = Logger.getLogger(BeanTask.class.getName());

    public BeanTask(Class<T> clazz, String txnName, QualifiedName qName) {
        if (qName == null) {
            throw new IllegalArgumentException("BeanTask requires a qualified name which is not null");
        }
        this._clazz = clazz;
        this._txnName = txnName;
        this._qName = qName;
    }

    public final boolean run(XmlContext xmlContext) {
        return this.runWithToken(xmlContext.getModel(), null);
    }

    public final boolean runWithToken(XmlContext xmlContext, TransactionToken transactionToken) {
        return this.runWithToken(xmlContext.getModel(), transactionToken);
    }

    public final boolean run(AbstractModel model) {
        return this.runWithToken(model, null);
    }

    public final boolean run(XmlContext xmlContext, Enum version) throws XmlCommitException {
        return this.runWithTokenThrowingXCE(xmlContext.getModel(), null, null, version);
    }

    public final boolean runWithToken(AbstractModel model, TransactionToken transactionToken) {
        try {
            return this.runWithTokenThrowingXCE(model, transactionToken);
        }
        catch (XmlCommitException xce) {
            return false;
        }
    }

    public final boolean runWithTokenThrowingXCE(AbstractModel model, TransactionToken transactionToken) throws XmlCommitException {
        return this.runWithTokenThrowingXCE(model, transactionToken, null);
    }

    public final boolean run(AbstractModel model, Node node) {
        return this.runWithToken(model, null, node);
    }

    public final boolean runWithToken(AbstractModel model, TransactionToken transactionToken, Node node) {
        try {
            return this.runWithTokenThrowingXCE(model, transactionToken, node);
        }
        catch (XmlCommitException xce) {
            return false;
        }
    }

    public final boolean runWithTokenThrowingXCE(AbstractModel model, TransactionToken transactionToken, Node node) throws XmlCommitException {
        return this.runWithTokenThrowingXCE(model, transactionToken, node, null);
    }

    public final boolean runWithTokenThrowingXCE(AbstractModel model, TransactionToken transactionToken, final Node node, final Enum version) throws XmlCommitException {
        FixedNameTransactionTask createTask = new FixedNameTransactionTask("Create Root Node"){

            @Override
            protected boolean requiresTask(AbstractModel model) {
                XmlModel baseModel = model.getBaseModel();
                return node == null && baseModel.getDocument().getDocumentElement() == null;
            }

            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                VersionManager versionManager = model.getContext().getVersionManager();
                QualifiedName rootQName = versionManager != null ? versionManager.getVersionQualifiedName(BeanTask.this._qName, version) : BeanTask.this._qName;
                Element rootNode = model.getDocument().createElementNS(rootQName.getNamespace(), rootQName.getName());
                model.getDocument().appendChild(rootNode);
                if (versionManager != null) {
                    versionManager.initRootForVersion(rootNode, version);
                }
            }
        };
        createTask.runWithTokenThrowingXCE(model, transactionToken);
        FixedNameTransactionTask task = new FixedNameTransactionTask(this._txnName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean requiresTask(AbstractModel model) {
                DynamicProxyContext context = this.getContext(model);
                if (context != null) {
                    Object type = BeanTask.this.getType(context);
                    try {
                        boolean bl = BeanTask.this.requiresTask(type);
                        return bl;
                    }
                    finally {
                        context.setExpired();
                    }
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void performTask(AbstractModel model) throws XmlCommitException {
                DynamicProxyContext context = this.getContext(model);
                if (context == null) {
                    return;
                }
                Object type = BeanTask.this.getType(context);
                try {
                    BeanTask.this.performTask(type);
                }
                finally {
                    context.setExpired();
                }
            }

            private DynamicProxyContext getContext(AbstractModel model) {
                XmlModel baseModel = model.getBaseModel();
                VersionManager versionManager = baseModel.getContext().getVersionManager();
                QualifiedName validQName = versionManager != null ? versionManager.getVersionQualifiedName(BeanTask.this._qName) : BeanTask.this._qName;
                Node typeNode = node;
                if (typeNode == null) {
                    typeNode = baseModel.getDocument().getDocumentElement();
                }
                if (!baseModel.isInModelDocumentHierarchy(typeNode)) {
                    throw new IllegalArgumentException("BeanTask.run method passed a Node that is not in the model's document hierarchy");
                }
                QualifiedName typeNodeQName = DomUtils.getQualifiedName((Node)typeNode);
                if (!validQName.equals((Object)typeNodeQName)) {
                    String msg = "The node doesn't match, namespace: " + validQName.getNamespace() + " name: " + validQName.getName();
                    _LOGGER.log(Level.WARNING, msg);
                    return null;
                }
                XmlKey nodeXmlKey = baseModel.getNodeXmlKey(typeNode);
                return new DynamicProxyContext(baseModel, typeNode, nodeXmlKey, BeanTask.this._clazz.getClassLoader());
            }
        };
        return task.runWithTokenThrowingXCE(model, transactionToken);
    }

    protected boolean requiresTask(T type) {
        return true;
    }

    protected void performTask(T type) throws XmlCommitException {
    }

    private final T getType(DynamicProxyContext context) {
        return (T)((XmlBaseType)DynamicProxyFactory.getInstance().createProxyInstance(context, this._clazz));
    }
}

