/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.exec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.xqxp.datamodel.FSChoiceType;
import oracle.xml.xqxp.datamodel.FSPrimeChoiceType;
import oracle.xml.xqxp.datamodel.FSSequenceType;
import oracle.xml.xqxp.datamodel.FSType;
import oracle.xml.xqxp.datamodel.FSTypeUtil;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.builtIns.FNFunctionLibrary;
import oracle.xml.xqxp.functions.builtIns.FNUtil;
import oracle.xquery.XQException;
import oracle.xquery.exec.ArithOp;
import oracle.xquery.exec.Case;
import oracle.xquery.exec.ConstantExpr;
import oracle.xquery.exec.DeleteExpr;
import oracle.xquery.exec.Document;
import oracle.xquery.exec.Dot;
import oracle.xquery.exec.Exists;
import oracle.xquery.exec.Expr;
import oracle.xquery.exec.ExprSequence;
import oracle.xquery.exec.FLWR;
import oracle.xquery.exec.FilterProject;
import oracle.xquery.exec.FunctionCall;
import oracle.xquery.exec.GeneralComparison;
import oracle.xquery.exec.InsertExpr;
import oracle.xquery.exec.LetExpr;
import oracle.xquery.exec.LogicalOp;
import oracle.xquery.exec.NLJ;
import oracle.xquery.exec.OrderComparison;
import oracle.xquery.exec.PathStep;
import oracle.xquery.exec.Predicate;
import oracle.xquery.exec.PredicateSet;
import oracle.xquery.exec.PredicatedExpr;
import oracle.xquery.exec.QueryState;
import oracle.xquery.exec.RelOp;
import oracle.xquery.exec.RenameExpr;
import oracle.xquery.exec.ReplaceNodeExpr;
import oracle.xquery.exec.ReplaceValueExpr;
import oracle.xquery.exec.SQLQuery;
import oracle.xquery.exec.Scan;
import oracle.xquery.exec.SeqOp;
import oracle.xquery.exec.SortNS;
import oracle.xquery.exec.TransformExpr;
import oracle.xquery.exec.TypeFactory;
import oracle.xquery.exec.TypeOp;
import oracle.xquery.exec.UnaryExpr;
import oracle.xquery.exec.ValidateExpr;
import oracle.xquery.exec.VarExpr;
import oracle.xquery.exec.Variable;
import oracle.xquery.exec.Visitor;
import oracle.xquery.exec.XMLCons;
import oracle.xquery.exec.XMLElem;
import oracle.xquery.exec.XQRangeExpr;
import oracle.xquery.exec.XQueryUtils;
import oracle.xquery.exec.XpathExpr;
import oracle.xquery.func.FunctionDefn;

public class StaticTypingVisitor
implements Visitor {
    private QueryState queryState;
    private TypeFactory typeFactory;
    private Expr curExpr;
    private HashMap schemaTypeChain;
    private int flag;
    private static int INIT_FLAG = 0;
    private static int XPATH_GIVE_UP = 1;
    private static int INSIDE_DIRECT_ELEM = 2;
    private static int INSIDE_UDF_BODY = 4;

    public StaticTypingVisitor(QueryState queryState) {
        this.queryState = queryState;
        this.typeFactory = queryState.getTypeFactory();
        queryState.setStaticTypingVisitor(this);
        this.flag = INIT_FLAG;
        this.curExpr = null;
    }

    @Override
    public void visitLiteral(ConstantExpr constantExpr) {
    }

    @Override
    public void visitVariableRef(VarExpr varExpr) {
        varExpr.var.acceptVisitor(this);
        varExpr.setStaticType(this.getStaticType(varExpr.var));
    }

    @Override
    public void visitVariable(Variable variable) {
    }

    @Override
    public void visitLetExpr(LetExpr letExpr) {
        OXMLSequenceType oXMLSequenceType = letExpr.getDefinedType();
        FSType fSType = this.getStaticType(letExpr.kids[0]);
        if (oXMLSequenceType != null) {
            int n = fSType.instanceOf((FSType)oXMLSequenceType);
            this.handleErrorPass(n, letExpr.kids[0]);
            if (n == 0) {
                letExpr.setStaticType(fSType);
            } else {
                letExpr.setStaticType((FSType)oXMLSequenceType);
            }
        } else {
            letExpr.kids[0].passStaticTyping();
            letExpr.setStaticType(fSType);
        }
    }

    @Override
    public void visitContextItem(Dot dot) {
        FSType fSType = this.queryState.getContextItemStaticType();
        if (fSType == null) {
            this.raiseContextItemNullError();
        }
        dot.setStaticType(fSType);
    }

    @Override
    public void visitFunctionCall(FunctionCall functionCall) {
        String string;
        if (XQueryUtils.fnEquals(functionCall.fd.getNamespace())) {
            string = functionCall.fd.getFunctionName();
            if (string.equals("abs") || string.equals("ceiling") || string.equals("floor") || string.equals("round") || string.equals("round-half-to-even")) {
                this.visitNumericFunction(functionCall);
                return;
            }
            if (string.equals("boolean")) {
                this.visitBooleanFunction(functionCall);
                return;
            }
            if (string.equals("data")) {
                this.visitDataFunction(functionCall);
                return;
            }
            if (string.equals("distinct-values")) {
                this.visitDistinctValueFunction(functionCall);
                return;
            }
            if (string.equals("unordered")) {
                this.visitUnorderedFunction(functionCall);
                return;
            }
            if (string.equals("error")) {
                this.visitErrorFunction(functionCall);
                return;
            }
            if (string.equals("min") || string.equals("max") || string.equals("avg") || string.equals("sum")) {
                this.visitAggregateFunction(functionCall);
                return;
            }
            if (string.equals("remove")) {
                this.visitRemoveFunction(functionCall);
                return;
            }
            if (string.equals("reverse")) {
                this.visitReverseFunction(functionCall);
                return;
            }
            if (string.equals("subsequence")) {
                this.visitSubsequenceFunction(functionCall);
                return;
            }
            if (string.equals("insert-before")) {
                this.visitInsertBeforeFunction(functionCall);
                return;
            }
            if (string.equals("zero-or-one") || string.equals("one-or-more") || string.equals("exactly-one")) {
                this.visitCardinalityFunction(functionCall);
                return;
            }
            if (string.equals("root")) {
                this.visitRootFunction(functionCall);
                return;
            }
        }
        string = functionCall.fd.getNamespace();
        boolean bl = XQueryUtils.isBuiltIn(string);
        OXMLFunction oXMLFunction = functionCall.fd.getFunctionObj();
        Variable[] variableArray = functionCall.fd.getParameters();
        if (functionCall.kids != null) {
            for (int i = 0; i < functionCall.kids.length; ++i) {
                OXMLSequenceType oXMLSequenceType;
                OXMLSequenceType oXMLSequenceType2;
                OXMLSequenceType oXMLSequenceType3 = oXMLSequenceType2 = oXMLFunction != null ? oXMLFunction.getArgType(i) : null;
                if (!bl && (oXMLSequenceType = variableArray[i].getDefinedType()) != null) {
                    oXMLSequenceType2 = oXMLSequenceType;
                }
                this.normalizeParameter(oXMLSequenceType2, functionCall.kids[i]);
            }
        }
        FSType fSType = functionCall.fd.getStaticReturnType();
        functionCall.setStaticType((FSType)(bl || fSType == null ? (oXMLFunction != null ? oXMLFunction.getReturnType() : null) : fSType));
        if (functionCall.staticType == null) {
            functionCall.setStaticType((FSType)OXMLSequenceType.ITEM_ZERO_OR_MORE);
        }
    }

    private FSType normalizeParameter(OXMLSequenceType oXMLSequenceType, Expr expr) {
        int n;
        if (oXMLSequenceType == null || oXMLSequenceType == OXMLSequenceType.ITEM_ZERO_OR_MORE) {
            FSType fSType = this.getStaticType(expr);
            this.passStaticTyping(expr);
            return fSType;
        }
        int n2 = oXMLSequenceType.quantifier();
        FSType fSType = this.getStaticType(expr);
        Expr expr2 = this.getExpr(expr);
        if (fSType.isEmpty()) {
            if (n2 == 1 || n2 == 3) {
                this.raiseStaticTypeError();
            } else {
                expr2.passStaticTyping();
                return fSType;
            }
        }
        if (oXMLSequenceType.isOfType(OXMLSequenceType.ANYATOMIC_ZERO_OR_MORE)) {
            fSType = this.applyFnData(expr2);
            if (FSTypeUtil.isAnyAtomicType((FSType)fSType)) {
                return oXMLSequenceType;
            }
            n = fSType.instanceOf((FSType)OXMLSequenceType.getConstantType((int)4, (int)0));
            if (n == 0) {
                expr2.noTypePromotion();
                return oXMLSequenceType;
            }
            if (n == 2) {
                return oXMLSequenceType;
            }
            expr2.noCast();
            if (oXMLSequenceType.isOfType(OXMLSequenceType.NUMERIC_ZERO_OR_MORE)) {
                n = FSTypeUtil.typePromotable((FSType)fSType, (OXMLSequenceType)oXMLSequenceType);
                if (n == 0) {
                    if (FSTypeUtil.quantifierLessThan((int)fSType.quantifier(), (int)n2)) {
                        expr2.knowStaticType();
                    }
                    return oXMLSequenceType;
                }
                if (n == 2) {
                    return oXMLSequenceType;
                }
                this.raiseStaticTypeError();
            } else if (oXMLSequenceType.isOfTypeIgnoreOccurence(OXMLSequenceType.TSTRING)) {
                n = fSType.instanceOf((FSType)OXMLSequenceType.getConstantType((int)4, (int)17));
                if (n == 0) {
                    if (FSTypeUtil.quantifierLessThan((int)fSType.quantifier(), (int)n2)) {
                        expr2.knowStaticType();
                    }
                    return oXMLSequenceType;
                }
                if (n == 2) {
                    return oXMLSequenceType;
                }
                expr2.noTypePromotion();
            } else {
                expr2.noTypePromotion();
            }
        } else {
            expr2.noAtomization();
            expr2.noCast();
            expr2.noTypePromotion();
        }
        n = fSType.instanceOf((FSType)oXMLSequenceType);
        this.handleError(n, expr2);
        return n == 2 ? oXMLSequenceType : fSType;
    }

    private void visitNumericFunction(FunctionCall functionCall) {
        Expr expr;
        FSType fSType;
        FSType fSType2;
        if (functionCall.kids.length == 2) {
            this.normalizeParameter(OXMLSequenceType.TINTEGER, functionCall.kids[1]);
        }
        if ((fSType2 = this.castUntypedAtomicHelper(fSType = this.applyFnData(functionCall.kids[0]), 4, expr = this.getExpr(functionCall.kids[0]))) != null) {
            functionCall.setStaticType(fSType2);
            return;
        }
        this.numericFunctionHelper(fSType, functionCall);
    }

    private void numericFunctionHelper(FSType fSType, Expr expr) {
        if (FSTypeUtil.isAnyAtomicType((FSType)fSType)) {
            int n = fSType.quantifier();
            expr.setStaticType((FSType)(FSTypeUtil.quantifierAtLeastOne((int)n) ? OXMLSequenceType.NUMERIC_ONE : OXMLSequenceType.NUMERIC_ZERO_OR_ONE));
            return;
        }
        int n = fSType.instanceOf((FSType)OXMLSequenceType.NUMERIC_ZERO_OR_MORE);
        if (n == 1) {
            this.raiseStaticTypeError();
        }
        if (n == 2) {
            int n2 = fSType.quantifier();
            expr.setStaticType((FSType)(FSTypeUtil.quantifierAtLeastOne((int)n2) ? OXMLSequenceType.NUMERIC_ONE : OXMLSequenceType.NUMERIC_ZERO_OR_ONE));
            return;
        }
        if (this.typeConversion(fSType, 22, expr)) {
            return;
        }
        if (this.typeConversion(fSType, 5, expr)) {
            return;
        }
        if (this.typeConversion(fSType, 3, expr)) {
            return;
        }
        this.typeConversion(fSType, 4, expr);
    }

    private boolean typeConversion(FSType fSType, int n, Expr expr) {
        int n2 = FSTypeUtil.typePromotable((FSType)fSType, (OXMLSequenceType)OXMLSequenceType.getConstantType((int)1, (int)n));
        if (n2 == 0) {
            expr.setStaticType((FSType)(FSTypeUtil.quantifierAtLeastOne((int)fSType.quantifier()) ? OXMLSequenceType.getConstantType((int)1, (int)n) : OXMLSequenceType.getConstantType((int)2, (int)n)));
            return true;
        }
        return false;
    }

    private void visitBooleanFunction(FunctionCall functionCall) {
        FSType fSType = this.getStaticType(functionCall.kids[0]);
        this.applyFnBoolean(fSType, functionCall.kids[0]);
        functionCall.kids[0].passStaticTyping();
        if (!functionCall.kids[0].unknownEBV()) {
            functionCall.setEBV(functionCall.kids[0].trueEBV());
        }
        functionCall.setStaticType((FSType)OXMLSequenceType.TBOOLEAN);
    }

    private void visitDataFunction(FunctionCall functionCall) {
        functionCall.setStaticType(this.applyFnData(functionCall.kids[0]));
        this.passStaticTyping(functionCall.kids[0]);
    }

    private void visitDistinctValueFunction(FunctionCall functionCall) {
        FSType fSType = this.applyFnData(functionCall.kids[0]);
        functionCall.kids[0].knowStaticType();
        functionCall.setStaticType(this.getPrimeQuan(fSType));
    }

    private void visitUnorderedFunction(FunctionCall functionCall) {
        Expr expr = functionCall.kids[0];
        FSType fSType = this.getStaticType(expr);
        this.passStaticTyping(expr);
        functionCall.setStaticType(this.getPrimeQuan(fSType));
    }

    private void visitErrorFunction(FunctionCall functionCall) {
        if (functionCall.kids != null) {
            for (int i = 0; i < functionCall.kids.length; ++i) {
                OXMLSequenceType oXMLSequenceType = functionCall.fd.getFunctionObj().getArgType(i);
                this.normalizeParameter(oXMLSequenceType, functionCall.kids[i]);
            }
        }
        functionCall.setStaticType((FSType)FSType.NoneType);
    }

    private void visitAggregateFunction(FunctionCall functionCall) {
        FSType fSType = null;
        if (functionCall.kids.length > 1) {
            fSType = this.normalizeParameter(functionCall.fd.getFunctionObj().getArgType(1), functionCall.kids[1]);
        }
        FSType fSType2 = this.applyFnData(functionCall.kids[0]);
        FSType fSType3 = this.getPrime(fSType2);
        String string = functionCall.fd.getFunctionName();
        if (fSType3.isNone() || fSType3.isEmpty()) {
            if (string.equals("sum")) {
                functionCall.setStaticType((FSType)(fSType == null ? OXMLSequenceType.TINTEGER : fSType));
            } else {
                this.replaceWithEmptySequence(functionCall);
            }
            return;
        }
        OXMLSequenceType oXMLSequenceType = FSTypeUtil.aggregateFunctionHelper((FSType)fSType3, (String)string);
        if (oXMLSequenceType == null) {
            this.raiseStaticTypeError("FORG0006");
        }
        int n = FSTypeUtil.aggregateQuantifier((int)fSType2.quantifier());
        functionCall.setStaticType((FSType)this.getOXMLSequenceType(oXMLSequenceType, n));
        if (string.equals("sum")) {
            FSChoiceType fSChoiceType = this.typeFactory.getFSChoiceType(2);
            fSChoiceType.addType(functionCall.staticType);
            if (fSType != null) {
                fSChoiceType.addType(fSType);
            } else {
                fSChoiceType.addType((FSType)OXMLSequenceType.TINTEGER);
            }
            functionCall.setStaticType((FSType)fSChoiceType);
        }
    }

    private void visitRemoveFunction(FunctionCall functionCall) {
        this.normalizeParameter(functionCall.fd.getFunctionObj().getArgType(1), functionCall.kids[1]);
        FSType fSType = this.getStaticType(functionCall.kids[0]);
        this.passStaticTyping(functionCall.kids[0]);
        int n = FSTypeUtil.calculateQuantifier((int)fSType.quantifier(), (int)2, (int)2);
        FSType fSType2 = this.getPrimeQuan(fSType, n);
        functionCall.setStaticType(fSType2);
    }

    private void visitReverseFunction(FunctionCall functionCall) {
        Expr expr = functionCall.kids[0];
        FSType fSType = this.getStaticType(expr);
        this.passStaticTyping(expr);
        functionCall.setStaticType(this.getPrimeQuan(fSType));
    }

    private void visitSubsequenceFunction(FunctionCall functionCall) {
        for (int i = 1; i < functionCall.kids.length; ++i) {
            this.normalizeParameter(functionCall.fd.getFunctionObj().getArgType(i), functionCall.kids[i]);
        }
        FSType fSType = this.getStaticType(functionCall.kids[0]);
        this.passStaticTyping(functionCall.kids[0]);
        if (fSType.isEmpty()) {
            this.replaceWithEmptySequence(functionCall);
            return;
        }
        int n = FSTypeUtil.calculateQuantifier((int)fSType.quantifier(), (int)2, (int)2);
        FSType fSType2 = this.getPrimeQuan(fSType, n);
        functionCall.setStaticType(fSType2);
    }

    private void visitInsertBeforeFunction(FunctionCall functionCall) {
        this.normalizeParameter(functionCall.fd.getFunctionObj().getArgType(1), functionCall.kids[1]);
        FSType fSType = this.getStaticType(functionCall.kids[0]);
        if (fSType.isEmpty()) {
            functionCall.setStaticType(this.getStaticType(functionCall.kids[2]));
            this.curExpr = functionCall.replaceMeWithKid(functionCall.kids[2]);
            return;
        }
        FSType fSType2 = this.getStaticType(functionCall.kids[2]);
        if (fSType2.isEmpty()) {
            functionCall.setStaticType(this.getStaticType(functionCall.kids[0]));
            this.curExpr = functionCall.replaceMeWithKid(functionCall.kids[0]);
            return;
        }
        functionCall.kids[0].passStaticTyping();
        functionCall.kids[2].passStaticTyping();
        FSPrimeChoiceType fSPrimeChoiceType = this.typeFactory.getFSPrimeChoiceType();
        FSTypeUtil.addPrime((FSType)fSType, (FSType)fSType2, (FSPrimeChoiceType)fSPrimeChoiceType);
        int n = FSTypeUtil.calculateQuantifier((int)fSType.quantifier(), (int)fSType2.quantifier(), (int)0);
        fSPrimeChoiceType.setQuantifier(n);
        functionCall.setStaticType((FSType)fSPrimeChoiceType);
    }

    private void visitCardinalityFunction(FunctionCall functionCall) {
        FSType fSType = this.getStaticType(functionCall.kids[0]);
        functionCall.kids[0].passStaticTyping();
        int n = fSType.quantifier();
        int n2 = 99;
        String string = functionCall.fd.getFunctionName();
        if (string.equals("zero-or-one")) {
            if (n == 2 || n == 1) {
                functionCall.setStaticType(fSType);
                this.curExpr = functionCall.replaceMeWithKid(functionCall.kids[0]);
                return;
            }
            n2 = 2;
        } else if (string.equals("one-or-more")) {
            if (fSType.isEmpty()) {
                this.raiseStaticTypeError("FORG0004");
            }
            if (n == 3 || n == 1) {
                functionCall.setStaticType(fSType);
                this.curExpr = functionCall.replaceMeWithKid(functionCall.kids[0]);
                return;
            }
            n2 = 3;
        } else if (string.equals("exactly-one")) {
            if (fSType.isEmpty()) {
                this.raiseStaticTypeError("FORG0005");
            }
            if (n == 1) {
                functionCall.setStaticType(fSType);
                this.curExpr = functionCall.replaceMeWithKid(functionCall.kids[0]);
                return;
            }
            n2 = 1;
        }
        FSType fSType2 = this.getPrimeQuan(fSType, n2);
        functionCall.setStaticType(fSType2);
    }

    private void visitRootFunction(FunctionCall functionCall) {
        int n;
        FSType fSType = null;
        if (functionCall.kids == null) {
            fSType = this.queryState.getContextItemStaticType();
            if (fSType == null) {
                this.raiseContextItemNullError();
            }
            if ((n = fSType.instanceOf((FSType)OXMLSequenceType.NODE_ZERO_OR_ONE)) == 1) {
                this.raiseStaticTypeError("XPTY0004");
            }
        } else {
            fSType = this.getStaticType(functionCall.kids[0]);
            if (fSType.isEmpty()) {
                this.replaceWithEmptySequence(functionCall);
                return;
            }
            n = fSType.instanceOf((FSType)OXMLSequenceType.NODE_ZERO_OR_ONE);
            this.handleErrorPass(n, functionCall.kids[0]);
        }
        n = fSType.instanceOf((FSType)OXMLSequenceType.DOCUMENT_ZERO_OR_MORE);
        if (n == 0) {
            if (fSType.quantifier() == 1) {
                functionCall.setStaticType(fSType);
            }
        } else if (functionCall.kids == null) {
            functionCall.setStaticType((FSType)OXMLSequenceType.NODE_ONE);
        } else {
            functionCall.setStaticType((FSType)OXMLSequenceType.NODE_ZERO_OR_ONE);
        }
    }

    @Override
    public void visitDocument(Document document) {
        FSType fSType = this.normalizeParameter(OXMLSequenceType.TSTRING_ZERO_OR_ONE, document.kids[0]);
        String string = document.getFunctionName();
        if (string.equals("doc")) {
            if (fSType.isEmpty()) {
                this.replaceWithEmptySequence(document);
                return;
            }
            document.setStaticType((FSType)OXMLSequenceType.createNodeType(null, null, (int)9, (boolean)false, (int)1, (boolean)true));
        } else if (string.equals("doc-available")) {
            if (fSType.isEmpty()) {
                document.setEBV(false);
            }
            document.setStaticType((FSType)OXMLSequenceType.TBOOLEAN);
        } else {
            if (fSType.isEmpty()) {
                this.raiseStaticTypeError("FODC0002");
            }
            document.setStaticType((FSType)OXMLSequenceType.createNodeType(null, null, (int)9, (boolean)false, (int)4, (boolean)true));
        }
    }

    @Override
    public void visitOraView(SQLQuery sQLQuery) {
        Object object;
        if (sQLQuery.kids != null) {
            object = sQLQuery.getBindVarType();
            for (int i = 0; i < sQLQuery.kids.length; ++i) {
                FSType fSType = this.getStaticType(sQLQuery.kids[i]);
                if (fSType.instanceOf((FSType)object[i]) != 1) continue;
                this.raiseStaticTypeError();
            }
        }
        object = sQLQuery.getRootElementName();
        OXMLSequenceType oXMLSequenceType = null;
        switch (sQLQuery.getType()) {
            case 4: {
                oXMLSequenceType = this.createDocumentType(null, 4);
                break;
            }
            case 1: 
            case 3: {
                oXMLSequenceType = this.createDocumentType((QName)object, 4);
                break;
            }
            case 2: {
                oXMLSequenceType = this.createDocumentType((QName)object, 2);
            }
        }
        sQLQuery.setStaticType((FSType)oXMLSequenceType);
    }

    private OXMLSequenceType createDocumentType(QName qName, int n) {
        OXMLSequenceType oXMLSequenceType = null;
        oXMLSequenceType = qName == null ? OXMLSequenceType.createNodeType(null, (QName)FSTypeUtil.UNTYPED_QNAME, (int)9, (boolean)false, (int)n, (boolean)true) : OXMLSequenceType.createNodeType((QName)qName, null, (int)9, (boolean)false, (int)n, (boolean)true);
        return oXMLSequenceType;
    }

    private void raiseContextItemNullError() {
        throw new XQException(this.queryState.getMesg().getMessage0("XPDY0002"), this.queryState.getMesg().getMessage0("XQE-0505"));
    }

    private void clearBit(int n) {
        this.flag &= ~n;
    }

    private void setBit(int n) {
        this.flag |= n;
    }

    private boolean isBitSet(int n) {
        return (this.flag & n) == n;
    }

    @Override
    public void visitPath(XpathExpr xpathExpr) {
        Expr expr;
        int n;
        FSType fSType;
        FSType fSType2 = this.queryState.getContextItemStaticType();
        this.clearBit(XPATH_GIVE_UP);
        FSType fSType3 = null;
        if (xpathExpr.kids != null) {
            fSType3 = this.getStaticType(xpathExpr.kids[0]);
            int n2 = fSType3.instanceOf((FSType)OXMLSequenceType.NODE_ZERO_OR_MORE);
            this.handleErrorPass(n2, xpathExpr.kids[0], "XPTY0019");
            this.queryState.setContextItemStaticType(fSType3);
        }
        if ((fSType = this.queryState.getContextItemStaticType()) == null) {
            this.raiseContextItemNullError();
        }
        int n3 = xpathExpr.steps.size();
        for (n = 0; n < n3 - 1; ++n) {
            expr = (Expr)xpathExpr.steps.get(n);
            fSType3 = this.getStaticType(expr);
            if (expr.falseEBV()) {
                this.replaceWithEmptySequence(xpathExpr);
                return;
            }
            int n4 = fSType3.instanceOf((FSType)OXMLSequenceType.NODE_ZERO_OR_MORE);
            this.handleErrorPass(n4, expr, "XPTY0019");
            this.queryState.setContextItemStaticType(fSType3);
        }
        n = this.queryState.getContextItemStaticType().quantifier();
        expr = (Expr)xpathExpr.steps.get(n3 - 1);
        fSType3 = this.getStaticType(expr);
        if (expr instanceof PathStep) {
            if (expr.falseEBV()) {
                this.replaceWithEmptySequence(xpathExpr);
                return;
            }
        } else if (fSType3.quantifier() != n) {
            FSType fSType4;
            n = FSTypeUtil.calculateQuantifier((int)fSType3.quantifier(), (int)n, (int)2);
            fSType3 = fSType4 = this.getPrimeQuan(fSType3, n);
        }
        xpathExpr.setStaticType(fSType3);
        this.queryState.setContextItemStaticType(fSType2);
    }

    private boolean invalidAxis(PathStep pathStep) {
        FSType fSType = this.queryState.getContextItemStaticType();
        boolean bl = false;
        switch (pathStep.axisClass.getAxisType()) {
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                bl = FSTypeUtil.isATCPType((FSType)fSType) || FSTypeUtil.isNodeType((FSType)fSType, (int)9);
                break;
            }
            case 3: 
            case 4: {
                bl = FSTypeUtil.isATCPType((FSType)fSType);
                break;
            }
            case 0: 
            case 8: {
                bl = FSTypeUtil.isNodeType((FSType)fSType, (int)9);
                break;
            }
        }
        return bl;
    }

    @Override
    public void visitPathStep(PathStep pathStep) {
        if (this.invalidAxis(pathStep)) {
            this.raiseInvalidPathError(pathStep);
        }
        boolean bl = this.queryState.getSchema() == null;
        switch (pathStep.axisClass.getAxisType()) {
            case 8: {
                FSChoiceType fSChoiceType = this.typeFactory.getFSChoiceType(2);
                fSChoiceType.addType((FSType)(bl ? OXMLSequenceType.ELEMENT_UNTYPED_ZERO_OR_ONE : OXMLSequenceType.ELEMENT_ZERO_OR_ONE));
                fSChoiceType.addType((FSType)OXMLSequenceType.DOCUMENT_ZERO_OR_ONE);
                this.setBit(XPATH_GIVE_UP);
                this.applyNodeTest((FSType)fSChoiceType, pathStep, false);
                break;
            }
            case 0: {
                FSChoiceType fSChoiceType = this.typeFactory.getFSChoiceType(2);
                fSChoiceType.addType((FSType)(bl ? OXMLSequenceType.ELEMENT_UNTYPED_ZERO_OR_MORE : OXMLSequenceType.ELEMENT_ZERO_OR_MORE));
                fSChoiceType.addType((FSType)OXMLSequenceType.DOCUMENT_ZERO_OR_MORE);
                this.setBit(XPATH_GIVE_UP);
                this.applyNodeTest((FSType)fSChoiceType, pathStep, false);
                break;
            }
            case 1: {
                FSChoiceType fSChoiceType = this.typeFactory.getFSChoiceType(3);
                fSChoiceType.addType(this.queryState.getContextItemStaticType());
                fSChoiceType.addType((FSType)(bl ? OXMLSequenceType.ELEMENT_UNTYPED_ZERO_OR_MORE : OXMLSequenceType.ELEMENT_ZERO_OR_MORE));
                fSChoiceType.addType((FSType)OXMLSequenceType.DOCUMENT_ZERO_OR_MORE);
                this.setBit(XPATH_GIVE_UP);
                this.applyNodeTest((FSType)fSChoiceType, pathStep, true);
                break;
            }
            case 2: {
                this.visitAttrStep(pathStep);
                break;
            }
            case 3: {
                this.visitChildStep(pathStep);
                break;
            }
            case 4: {
                this.visitDescendantStep(pathStep, false);
                break;
            }
            case 5: {
                this.visitDescendantStep(pathStep, true);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                this.setBit(XPATH_GIVE_UP);
                this.applyNodeTest((FSType)(bl ? OXMLSequenceType.ELEMENT_UNTYPED_ZERO_OR_MORE : OXMLSequenceType.ELEMENT_ZERO_OR_MORE), pathStep, false);
                break;
            }
            case 11: {
                this.applyNodeTest(this.queryState.getContextItemStaticType(), pathStep, true);
            }
        }
        if (pathStep.predicateSet != null) {
            this.queryState.setContextItemStaticType(pathStep.staticType);
            this.visitPredicateSet(pathStep.predicateSet);
            if (pathStep.predicateSet.falseEBV()) {
                pathStep.setEBV(false);
                return;
            }
            if (!pathStep.predicateSet.emptyPredicates()) {
                int n = FSTypeUtil.calculateQuantifier((int)pathStep.staticType.quantifier(), (int)2, (int)2);
                FSType fSType = this.getPrimeQuan(pathStep.staticType, n);
                pathStep.setStaticType(fSType);
            }
        }
    }

    private FSType simpleDocNodeTest(FSType fSType, boolean bl) {
        FSType fSType2 = null;
        OXMLSequenceType oXMLSequenceType = OXMLSequenceType.DOCUMENT_ZERO_OR_MORE;
        int n = fSType.instanceOf((FSType)oXMLSequenceType);
        if (n == 0) {
            fSType2 = fSType;
        } else {
            oXMLSequenceType = OXMLSequenceType.DOCUMENT_ONE;
            n = oXMLSequenceType.instanceOf(fSType);
            if (n != 1) {
                fSType2 = OXMLSequenceType.DOCUMENT_ZERO_OR_ONE;
            }
        }
        return fSType2;
    }

    private void applyNodeTest(FSType fSType, PathStep pathStep, boolean bl) {
        this.applyNodeTest(fSType, pathStep, bl, false);
    }

    private void applyNodeTest(FSType fSType, PathStep pathStep, boolean bl, boolean bl2) {
        boolean bl3;
        if (pathStep.anyNode) {
            pathStep.setStaticType(fSType);
            return;
        }
        boolean bl4 = bl3 = bl2 ? false : this.isBitSet(XPATH_GIVE_UP);
        boolean bl5 = bl2 ? false : this.queryState.getSchema() == null;
        switch (pathStep.nodeType) {
            case 1: {
                FSType fSType2 = pathStep.seqType == null ? FSTypeUtil.nameTest((FSType)fSType, (String)pathStep.nameSpace, (String)pathStep.name, (int)1, (boolean)bl3, (boolean)bl5) : FSTypeUtil.kindTest((FSType)fSType, (OXMLSequenceType)pathStep.seqType, (boolean)bl3, (boolean)bl5);
                if (fSType2 == null || fSType2.isEmpty() || fSType2.isNone()) {
                    this.raiseInvalidPathError(pathStep);
                }
                pathStep.setStaticType(fSType2);
                break;
            }
            case 2: {
                FSType fSType3 = pathStep.seqType == null ? FSTypeUtil.nameTest((FSType)fSType, (String)pathStep.nameSpace, (String)pathStep.name, (int)2, (boolean)bl3, (boolean)bl5) : FSTypeUtil.kindTest((FSType)fSType, (OXMLSequenceType)pathStep.seqType, (boolean)bl3, (boolean)bl5);
                if (fSType3 == null || fSType3.isEmpty() || fSType3.isNone()) {
                    this.raiseInvalidPathError(pathStep);
                }
                pathStep.setStaticType(fSType3);
                break;
            }
            case 3: 
            case 4: {
                if (!bl) {
                    this.raiseInvalidPathError(pathStep);
                }
                pathStep.setStaticType((FSType)OXMLSequenceType.TEXT_ONE);
                break;
            }
            case 8: {
                if (!bl) {
                    this.raiseInvalidPathError(pathStep);
                }
                pathStep.setStaticType((FSType)OXMLSequenceType.COMMENT_ONE);
                break;
            }
            case 7: {
                if (!bl) {
                    this.raiseInvalidPathError(pathStep);
                }
                pathStep.setStaticType((FSType)(pathStep.name == null ? OXMLSequenceType.PI_ONE : OXMLSequenceType.PI_ZERO_OR_ONE));
                break;
            }
            case 9: {
                if (bl5 || bl3 || pathStep.seqType == null) {
                    FSType fSType4 = this.simpleDocNodeTest(fSType, bl5);
                    if (fSType4 == null) {
                        this.raiseInvalidPathError(pathStep);
                    }
                    pathStep.setStaticType(fSType4);
                    return;
                }
                FSType fSType5 = FSTypeUtil.kindTest((FSType)fSType, (OXMLSequenceType)pathStep.seqType, (boolean)bl3, (boolean)bl5);
                if (fSType5 == null || fSType5.isEmpty() || fSType5.isNone()) {
                    this.raiseInvalidPathError(pathStep);
                }
                pathStep.setStaticType(fSType5);
            }
        }
    }

    private void visitDescendantStep(PathStep pathStep, boolean bl) {
        XMLSchema xMLSchema = this.queryState.getSchema();
        FSType fSType = this.queryState.getContextItemStaticType();
        if (xMLSchema == null || this.isBitSet(XPATH_GIVE_UP)) {
            FSType fSType2 = null;
            boolean bl2 = false;
            if (bl && FSTypeUtil.isATCPType((FSType)fSType)) {
                fSType2 = fSType;
            } else {
                FSChoiceType fSChoiceType;
                if (this.isBitSet(XPATH_GIVE_UP)) {
                    fSType2 = OXMLSequenceType.ELEMENT_ZERO_OR_MORE;
                } else {
                    fSChoiceType = new HashMap();
                    FSTypeUtil.getDescendantChildrenType((FSType)fSType, fSChoiceType);
                    int n = fSChoiceType.size();
                    if (n > 0) {
                        bl2 = true;
                        Iterator iterator = fSChoiceType.keySet().iterator();
                        if (n == 1) {
                            fSType2 = (FSType)iterator.next();
                            bl2 = bl2 && (Boolean)fSChoiceType.get(fSType2) != false;
                        } else {
                            FSChoiceType fSChoiceType2 = this.typeFactory.getFSChoiceType(n);
                            while (iterator.hasNext()) {
                                FSType fSType3 = (FSType)iterator.next();
                                fSChoiceType2.addType(fSType3);
                                bl2 = bl2 && (Boolean)fSChoiceType.get(fSType3) != false;
                            }
                            fSType2 = fSChoiceType2;
                        }
                    }
                }
                if (bl) {
                    if (fSType2 == null) {
                        fSType2 = fSType;
                    } else {
                        fSChoiceType = this.typeFactory.getFSChoiceType();
                        fSChoiceType.addType(fSType);
                        fSChoiceType.addType(fSType2);
                        fSType2 = fSChoiceType;
                    }
                }
            }
            this.applyNodeTest(fSType2, pathStep, true, bl2);
            return;
        }
        this.setSchemaTypeChain(xMLSchema);
        HashMap hashMap = new HashMap();
        FSTypeUtil.getDescendantType((FSType)fSType, (XMLSchema)xMLSchema, (HashMap)this.schemaTypeChain, hashMap, (boolean)bl);
        FSType fSType4 = this.getTypeFromHashMap(hashMap);
        if (fSType4 == null) {
            this.raiseInvalidPathError(pathStep);
        }
        this.applyNodeTest(fSType4, pathStep, true);
    }

    private FSType getTypeFromHashMap(HashMap hashMap) {
        int n = hashMap.size();
        if (n <= 0) {
            return null;
        }
        FSType fSType = null;
        Iterator iterator = hashMap.values().iterator();
        if (n == 1) {
            fSType = (FSType)iterator.next();
        } else {
            FSChoiceType fSChoiceType = this.typeFactory.getFSChoiceType(n);
            while (iterator.hasNext()) {
                fSChoiceType.addType((FSType)iterator.next());
            }
            fSType = fSChoiceType;
        }
        return fSType;
    }

    private void raiseInvalidPathError(PathStep pathStep) {
        StringBuffer stringBuffer = new StringBuffer();
        pathStep.getStrRep(stringBuffer);
        throw new XQException(this.queryState.getMesg().getMessage0("XPST0005"), this.queryState.getMesg().getMessage1("XQE-0250", stringBuffer.toString()));
    }

    private void visitAttrStep(PathStep pathStep) {
        FSType fSType;
        boolean bl;
        XMLSchema xMLSchema = this.queryState.getSchema();
        FSType fSType2 = this.queryState.getContextItemStaticType();
        boolean bl2 = bl = xMLSchema == null;
        if (bl || this.isBitSet(XPATH_GIVE_UP)) {
            if (this.isBitSet(XPATH_GIVE_UP)) {
                fSType2 = OXMLSequenceType.ATTRIBUTE_ZERO_OR_MORE;
            } else {
                if ((fSType2 = FSTypeUtil.getChildrenOrAttrType((FSType)fSType2, (int)2)) != null) {
                    this.applyNodeTest(fSType2, pathStep, false, true);
                    return;
                }
                fSType2 = OXMLSequenceType.ATTRIBUTE_UNTYPED_ZERO_OR_MORE;
            }
            this.applyNodeTest(fSType2, pathStep, false);
            return;
        }
        this.setSchemaTypeChain(xMLSchema);
        if (pathStep.anyNode) {
            FSType fSType3 = FSTypeUtil.getAttribute((FSType)fSType2, (HashMap)this.schemaTypeChain, (String)"*", (String)"*", null);
            if (fSType3 == null || fSType3.isNone() || fSType3.isEmpty()) {
                this.raiseInvalidPathError(pathStep);
            }
            pathStep.setStaticType(fSType3);
            return;
        }
        if (pathStep.nodeType != 2) {
            this.raiseInvalidPathError(pathStep);
        }
        if ((fSType = FSTypeUtil.getAttribute((FSType)fSType2, (HashMap)this.schemaTypeChain, (String)pathStep.nameSpace, (String)pathStep.name, (OXMLSequenceType)pathStep.seqType)) == null || fSType.isNone() || fSType.isEmpty()) {
            this.raiseInvalidPathError(pathStep);
        }
        pathStep.setStaticType(fSType);
    }

    private void setSchemaTypeChain(XMLSchema xMLSchema) {
        if (this.schemaTypeChain == null) {
            this.schemaTypeChain = FSTypeUtil.getSchemaTypeChain((XMLSchema)xMLSchema);
        }
    }

    private void visitChildStep(PathStep pathStep) {
        boolean bl;
        XMLSchema xMLSchema = this.queryState.getSchema();
        FSType fSType = this.queryState.getContextItemStaticType();
        boolean bl2 = bl = xMLSchema == null;
        if (bl || this.isBitSet(XPATH_GIVE_UP)) {
            if (this.isBitSet(XPATH_GIVE_UP)) {
                fSType = OXMLSequenceType.ELEMENT_ZERO_OR_MORE;
            } else if (bl) {
                if ((fSType = FSTypeUtil.getChildrenOrAttrType((FSType)fSType, (int)1)) != null) {
                    this.applyNodeTest(fSType, pathStep, true, true);
                    return;
                }
                fSType = OXMLSequenceType.ELEMENT_UNTYPED_ZERO_OR_MORE;
            }
            this.applyNodeTest(fSType, pathStep, true);
            return;
        }
        this.setSchemaTypeChain(xMLSchema);
        if (pathStep.anyNode) {
            FSType fSType2 = FSTypeUtil.getChildType((FSType)fSType, (XMLSchema)xMLSchema, (HashMap)this.schemaTypeChain, (String)"*", (String)"*", null);
            if (fSType2 == null || fSType2.isNone() || fSType2.isEmpty()) {
                this.raiseInvalidPathError(pathStep);
            }
            pathStep.setStaticType(fSType2);
            return;
        }
        switch (pathStep.nodeType) {
            case 1: {
                FSType fSType3 = FSTypeUtil.getChildType((FSType)fSType, (XMLSchema)xMLSchema, (HashMap)this.schemaTypeChain, (String)pathStep.nameSpace, (String)pathStep.name, (OXMLSequenceType)pathStep.seqType);
                if (fSType3 == null || fSType3.isNone() || fSType3.isEmpty()) {
                    this.raiseInvalidPathError(pathStep);
                }
                pathStep.setStaticType(fSType3);
                break;
            }
            case 3: 
            case 4: {
                pathStep.setStaticType((FSType)OXMLSequenceType.TEXT_ONE);
                break;
            }
            case 8: {
                pathStep.setStaticType((FSType)OXMLSequenceType.COMMENT_ONE);
                break;
            }
            case 7: {
                pathStep.setStaticType((FSType)(pathStep.name == null ? OXMLSequenceType.PI_ONE : OXMLSequenceType.PI_ZERO_OR_ONE));
                break;
            }
            case 2: 
            case 9: {
                this.raiseInvalidPathError(pathStep);
            }
        }
    }

    @Override
    public void visitPredicateExpr(PredicatedExpr predicatedExpr) {
        FSType fSType = this.queryState.getContextItemStaticType();
        FSType fSType2 = this.getStaticType(predicatedExpr.kids[0]);
        this.queryState.setContextItemStaticType(this.getPrime(fSType2));
        this.visitPredicateSet(predicatedExpr.predSet);
        if (predicatedExpr.predSet.falseEBV()) {
            this.replaceWithEmptySequence(predicatedExpr);
            return;
        }
        if (predicatedExpr.predSet.emptyPredicates()) {
            predicatedExpr.setStaticType(fSType2);
            return;
        }
        int n = FSTypeUtil.calculateQuantifier((int)fSType2.quantifier(), (int)2, (int)2);
        FSType fSType3 = this.getPrimeQuan(fSType2, n);
        predicatedExpr.setStaticType(fSType3);
        this.queryState.setContextItemStaticType(fSType);
    }

    @Override
    public void visitPredicateSet(PredicateSet predicateSet) {
        if (predicateSet.predicates == null) {
            return;
        }
        int n = predicateSet.predicates.size();
        ArrayList<Predicate> arrayList = new ArrayList<Predicate>(n);
        for (int i = 0; i < n; ++i) {
            Predicate predicate = (Predicate)predicateSet.predicates.get(i);
            this.visitPredicate(predicate);
            if (predicate.unknownEBV()) {
                arrayList.add(predicate);
                continue;
            }
            if (predicate.trueEBV()) continue;
            predicateSet.setEBV(false);
            return;
        }
        predicateSet.setPredicates(arrayList);
    }

    @Override
    public void visitPredicate(Predicate predicate) {
        FSType fSType = this.queryState.getContextItemStaticType();
        predicate.kids[0].acceptVisitor(this);
        int n = this.isBooleanFunction(predicate.kids[0]);
        if (n == 0) {
            predicate.setEBV(true);
        } else if (n == 1) {
            predicate.setEBV(false);
        }
        this.queryState.setContextItemStaticType(fSType);
    }

    @Override
    public void visitExprSequence(ExprSequence exprSequence) {
        if (exprSequence.kids == null) {
            exprSequence.setStaticType((FSType)OXMLSequenceType.EMPTY_SEQUENCE);
            exprSequence.setEBV(false);
        } else if (exprSequence.kids.length == 1) {
            exprSequence.setStaticType(this.getStaticType(exprSequence.kids[0]));
            if (!this.isBitSet(INSIDE_DIRECT_ELEM)) {
                this.curExpr = exprSequence.replaceMeWithKid(exprSequence.kids[0]);
            }
        } else {
            if (!this.isBitSet(INSIDE_DIRECT_ELEM)) {
                this.flattenExprSequence(exprSequence);
            }
            if (exprSequence.kids == null) {
                exprSequence.setStaticType((FSType)OXMLSequenceType.EMPTY_SEQUENCE);
                exprSequence.setEBV(false);
                return;
            }
            FSSequenceType fSSequenceType = this.typeFactory.getFSSequenceType(exprSequence.kids.length);
            for (int i = 0; i < exprSequence.kids.length; ++i) {
                fSSequenceType.addType(this.getStaticType(exprSequence.kids[i]));
            }
            exprSequence.setStaticType((FSType)fSSequenceType);
        }
    }

    private void normalizeWS(Expr expr, boolean bl) {
        int n;
        if (expr.kids == null) {
            return;
        }
        ArrayList<Expr> arrayList = new ArrayList<Expr>(expr.kids.length);
        for (n = 0; n < expr.kids.length; ++n) {
            expr.kids[n].acceptVisitor(this);
            if (!bl && expr.kids[n] instanceof ConstantExpr && expr.kids[n].staticType == OXMLSequenceType.TSTRING && ((ConstantExpr)expr.kids[n]).getValue().trim().length() == 0) continue;
            arrayList.add(expr.kids[n]);
        }
        n = arrayList.size();
        if (n < expr.kids.length) {
            if (n == 0) {
                expr.kids = null;
            } else {
                Expr[] exprArray = new Expr[n];
                for (int i = 0; i < n; ++i) {
                    exprArray[i] = (Expr)arrayList.get(i);
                }
                expr.kids = exprArray;
            }
        }
    }

    private void flattenExprSequence(Expr expr) {
        this.flattenExprSequence(expr, true);
    }

    private void flattenExprSequence(Expr expr, boolean bl) {
        int n;
        if (expr.kids == null) {
            return;
        }
        boolean bl2 = false;
        ArrayList<Expr> arrayList = new ArrayList<Expr>(expr.kids.length + 5);
        for (n = 0; n < expr.kids.length; ++n) {
            expr.kids[n].acceptVisitor(this);
            if (expr.kids[n] instanceof ExprSequence) {
                if (expr.kids[n].kids == null) continue;
                for (int i = 0; i < expr.kids[n].kids.length; ++i) {
                    bl2 = true;
                    arrayList.add(expr.kids[n].kids[i]);
                }
                continue;
            }
            if (bl || !(expr.kids[n] instanceof ConstantExpr) || expr.kids[n].staticType != OXMLSequenceType.TSTRING || ((ConstantExpr)expr.kids[n]).getValue().trim().length() != 0) {
                arrayList.add(expr.kids[n]);
                continue;
            }
            bl2 = true;
        }
        n = arrayList.size();
        if (bl2 || n != expr.kids.length) {
            if (n == 0) {
                expr.kids = null;
            } else {
                Expr[] exprArray = new Expr[n];
                for (int i = 0; i < n; ++i) {
                    exprArray[i] = (Expr)arrayList.get(i);
                }
                expr.kids = exprArray;
            }
        }
    }

    @Override
    public void visitRangeExpr(XQRangeExpr xQRangeExpr) {
        if (this.handleEmptySequence(xQRangeExpr)) {
            return;
        }
        OXMLSequenceType oXMLSequenceType = OXMLSequenceType.getConstantType((int)2, (int)22);
        for (int i = 0; i < xQRangeExpr.kids.length; ++i) {
            FSType fSType = this.normalizeParameter(oXMLSequenceType, xQRangeExpr.kids[i]);
        }
        xQRangeExpr.setStaticType((FSType)OXMLSequenceType.getConstantType((int)4, (int)22));
    }

    @Override
    public void visitNodeSequence(SeqOp seqOp) {
        int n;
        FSType fSType;
        for (int i = 0; i < seqOp.kids.length; ++i) {
            fSType = this.getStaticType(seqOp.kids[i]);
            n = fSType.instanceOf((FSType)OXMLSequenceType.NODE_ZERO_OR_MORE);
            this.handleErrorPass(n, seqOp.kids[i]);
        }
        FSType fSType2 = seqOp.kids[0].staticType;
        fSType = seqOp.kids[1].staticType;
        switch (seqOp.type) {
            case 0: {
                if (fSType2.isEmpty()) {
                    seqOp.setStaticType(fSType);
                    this.curExpr = seqOp.replaceMeWithKid(seqOp.kids[1]);
                    return;
                }
                if (fSType.isEmpty()) {
                    seqOp.setStaticType(fSType2);
                    this.curExpr = seqOp.replaceMeWithKid(seqOp.kids[0]);
                    return;
                }
            }
            case 1: {
                if (fSType2.isEmpty() || fSType.isEmpty()) {
                    this.replaceWithEmptySequence(seqOp);
                    return;
                }
                FSPrimeChoiceType fSPrimeChoiceType = this.typeFactory.getFSPrimeChoiceType();
                FSTypeUtil.addPrime((FSType)fSType2, (FSType)fSType, (FSPrimeChoiceType)fSPrimeChoiceType);
                int n2 = FSTypeUtil.calculateQuantifier((int)fSType2.quantifier(), (int)fSType.quantifier(), (int)0);
                if (seqOp.type == 1) {
                    n2 = FSTypeUtil.calculateQuantifier((int)n2, (int)2, (int)2);
                }
                fSPrimeChoiceType.setQuantifier(n2);
                seqOp.setStaticType((FSType)fSPrimeChoiceType);
                break;
            }
            case 2: {
                if (fSType2.isEmpty()) {
                    this.replaceWithEmptySequence(seqOp);
                    return;
                }
                if (fSType.isEmpty()) {
                    seqOp.setStaticType(fSType2);
                    this.curExpr = seqOp.replaceMeWithKid(seqOp.kids[0]);
                    return;
                }
                n = FSTypeUtil.calculateQuantifier((int)fSType2.quantifier(), (int)2, (int)2);
                FSType fSType3 = this.getPrimeQuan(fSType2, n);
                seqOp.setStaticType(fSType3);
                break;
            }
        }
    }

    @Override
    public void visitArithmeticExpr(ArithOp arithOp) {
        FSType fSType;
        if (this.handleEmptySequence(arithOp)) {
            return;
        }
        FSType fSType2 = this.arithmeticHelper(arithOp.kids[0]);
        FSType fSType3 = FSTypeUtil.arithmeticOK((FSType)fSType2, (FSType)(fSType = this.arithmeticHelper(arithOp.kids[1])), (int)arithOp.type);
        if (fSType3 == null || fSType3.isEmpty() || fSType3.isNone()) {
            this.raiseStaticTypeError();
        }
        int n = fSType2.quantifier();
        int n2 = fSType.quantifier();
        int n3 = 2;
        if (FSTypeUtil.quantifierAtLeastOne((int)n) && FSTypeUtil.quantifierAtLeastOne((int)n2)) {
            n3 = 1;
        }
        if (fSType3.getKind() == 2) {
            OXMLSequenceType oXMLSequenceType = (OXMLSequenceType)fSType3;
            fSType3 = this.getOXMLSequenceType(oXMLSequenceType, n3);
        } else {
            ((FSPrimeChoiceType)fSType3).setQuantifier(n3);
        }
        arithOp.setStaticType(fSType3);
    }

    private OXMLSequenceType getOXMLSequenceType(OXMLSequenceType oXMLSequenceType, int n) {
        OXMLSequenceType oXMLSequenceType2 = null;
        oXMLSequenceType2 = oXMLSequenceType.isAnyAtomicType() ? OXMLSequenceType.createAnyAtomicType((int)n) : OXMLSequenceType.getConstantType((int)n, (int)oXMLSequenceType.getPrimitiveId());
        return oXMLSequenceType2;
    }

    private FSType arithmeticHelper(Expr expr) {
        FSType fSType = this.applyFnData(expr);
        FSType fSType2 = this.castUntypedAtomicHelper(fSType, 4, this.getExpr(expr));
        return fSType2 == null ? fSType : fSType2;
    }

    private FSType valueComparisonHelper(Expr expr) {
        FSType fSType = this.applyFnData(expr);
        FSType fSType2 = this.castUntypedAtomicHelper(fSType, 1, this.getExpr(expr));
        return fSType2 == null ? fSType : fSType2;
    }

    private FSType castUntypedAtomicHelper(FSType fSType, int n, Expr expr) {
        if (FSTypeUtil.isAnyAtomicType((FSType)fSType)) {
            return null;
        }
        int n2 = fSType.instanceOf((FSType)OXMLSequenceType.getConstantType((int)4, (int)0));
        if (n2 == 0) {
            expr.knowStaticType();
            return FSTypeUtil.quantifierAtLeastOne((int)fSType.quantifier()) ? OXMLSequenceType.getConstantType((int)1, (int)n) : OXMLSequenceType.getConstantType((int)2, (int)n);
        }
        if (n2 == 1) {
            expr.noCast();
        }
        return null;
    }

    @Override
    public void visitUnaryExpr(UnaryExpr unaryExpr) {
        if (this.handleEmptySequence(unaryExpr)) {
            return;
        }
        FSType fSType = this.arithmeticHelper(unaryExpr.kids[0]);
        this.numericFunctionHelper(fSType, unaryExpr);
    }

    private boolean handleEmptySequence(Expr expr) {
        for (int i = 0; i < expr.kids.length; ++i) {
            FSType fSType = this.getStaticType(expr.kids[i]);
            if (!fSType.isEmpty()) continue;
            this.replaceWithEmptySequence(expr);
            return true;
        }
        return false;
    }

    @Override
    public void visitValueComp(RelOp relOp) {
        FSType fSType;
        if (this.handleEmptySequence(relOp)) {
            return;
        }
        FSType fSType2 = this.valueComparisonHelper(relOp.kids[0]);
        int n = FSTypeUtil.valueComparisonOK((FSType)fSType2, (FSType)(fSType = this.valueComparisonHelper(relOp.kids[1])), (int)relOp.type);
        if (n == 1) {
            this.raiseStaticTypeError();
        }
        int n2 = fSType2.quantifier();
        int n3 = fSType.quantifier();
        if (FSTypeUtil.quantifierAtLeastOne((int)n2) && FSTypeUtil.quantifierAtLeastOne((int)n3)) {
            relOp.setStaticType((FSType)OXMLSequenceType.TBOOLEAN);
        } else {
            relOp.setStaticType((FSType)OXMLSequenceType.TBOOLEAN_ZERO_OR_ONE);
        }
    }

    @Override
    public void visitGeneralComp(GeneralComparison generalComparison) {
        FSType fSType = this.applyFnData(generalComparison.kids[0]);
        if (fSType.isEmpty()) {
            this.replaceWithBooleanFunction(generalComparison, false);
            return;
        }
        FSType fSType2 = this.applyFnData(generalComparison.kids[1]);
        if (fSType2.isEmpty()) {
            this.replaceWithBooleanFunction(generalComparison, false);
            return;
        }
        int n = FSTypeUtil.generalComparisonOK((FSType)fSType, (FSType)fSType2, (int)generalComparison.type);
        if (n == 1) {
            this.raiseStaticTypeError();
        }
        generalComparison.setStaticType((FSType)OXMLSequenceType.TBOOLEAN);
    }

    @Override
    public void visitNodeComp(OrderComparison orderComparison) {
        for (int i = 0; i < orderComparison.kids.length; ++i) {
            FSType fSType = this.getStaticType(orderComparison.kids[i]);
            if (fSType.isEmpty()) {
                this.replaceWithEmptySequence(orderComparison);
                return;
            }
            int n = fSType.instanceOf((FSType)OXMLSequenceType.NODE_ZERO_OR_ONE);
            this.handleErrorPass(n, orderComparison.kids[i]);
        }
        orderComparison.setStaticType((FSType)OXMLSequenceType.TBOOLEAN);
    }

    @Override
    public void visitLogicalExpr(LogicalOp logicalOp) {
        int n;
        boolean bl = false;
        int n2 = logicalOp.getLogicalOp();
        for (n = 0; n < logicalOp.kids.length; ++n) {
            FSType fSType = this.getStaticType(logicalOp.kids[n]);
            this.applyFnBoolean(fSType, logicalOp.kids[n]);
            logicalOp.kids[n].passStaticTyping();
            if (logicalOp.kids[n].trueEBV()) {
                if (n2 != 2) continue;
                this.replaceWithBooleanFunction(logicalOp, true);
                return;
            }
            if (logicalOp.kids[n].unknownEBV()) {
                bl = true;
                continue;
            }
            if (n2 != 1) continue;
            this.replaceWithBooleanFunction(logicalOp, false);
            return;
        }
        if (!bl) {
            n = logicalOp.kids[0].trueEBV() ? 1 : 0;
            if (n2 == 3) {
                n = n == 0 ? 1 : 0;
            }
            this.replaceWithBooleanFunction(logicalOp, n != 0);
            return;
        }
        logicalOp.setStaticType((FSType)OXMLSequenceType.TBOOLEAN);
    }

    private void applyFnBoolean(FSType fSType, Expr expr) {
        int n = FSTypeUtil.hasEBV((FSType)fSType);
        if (n > 2) {
            expr.setEBV(n == FSTypeUtil.EBV_VALUE_TRUE);
            n = 0;
        }
        this.handleError(n, expr, "FORG0006");
    }

    private void raiseStaticTypeError() {
        this.raiseStaticTypeError("XPTY0004");
    }

    private void raiseStaticTypeError(String string) {
        throw new XQException(this.queryState.getMesg().getMessage0(string), this.queryState.getMesg().getMessage0("XQE-0251"));
    }

    private void handleError(int n, Expr expr) {
        this.handleError(n, expr, "XPTY0004");
    }

    private void handleError(int n, Expr expr, String string) {
        if (n == 1) {
            this.raiseStaticTypeError(string);
        } else if (n == 0) {
            expr.knowStaticType();
        }
    }

    private void handleErrorPass(int n, Expr expr) {
        this.handleErrorPass(n, expr, "XPTY0004");
    }

    private void handleErrorPass(int n, Expr expr, String string) {
        if (n == 1) {
            this.raiseStaticTypeError(string);
        } else if (n == 0) {
            expr.passStaticTyping();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void visitElementConstructor(XMLElem xMLElem) {
        boolean bl;
        int n;
        OXMLSequenceType oXMLSequenceType;
        QName qName;
        if (xMLElem.namespaceHT != null) {
            this.queryState.pushNamespaceHT(xMLElem.namespaceHT);
        }
        if (xMLElem.defaultNamespaceURI != null) {
            this.queryState.pushDefaultElemNS(xMLElem.defaultNamespaceURI);
        }
        if ((qName = xMLElem.getElementQName(this.queryState)) == null && xMLElem.elemNameExpr != null) {
            FSType fSType = this.applyFnData(xMLElem.elemNameExpr, false);
            oXMLSequenceType = new OXMLSequenceType[]{OXMLSequenceType.TQNAME, OXMLSequenceType.TSTRING, OXMLSequenceType.TUNTYPED};
            n = FSTypeUtil.isInOneOfTypes((FSType)fSType, (OXMLSequenceType[])oXMLSequenceType);
            this.handleError(n, xMLElem.elemNameExpr);
        }
        if (xMLElem.getType() == 2) {
            this.flattenExprSequence(xMLElem, this.queryState.getWhiteSpacePreserve());
        } else {
            this.setBit(INSIDE_DIRECT_ELEM);
            this.normalizeWS(xMLElem, this.queryState.getWhiteSpacePreserve());
            this.clearBit(INSIDE_DIRECT_ELEM);
        }
        boolean bl2 = bl = this.queryState.getConstructionMode() == 0;
        if (qName != null) {
            oXMLSequenceType = bl ? OXMLSequenceType.createNodeTypeAllowChildren((QName)qName, null, (int)1, (boolean)false, (int)1) : OXMLSequenceType.createNodeTypeAllowChildren((QName)qName, (QName)FSTypeUtil.UNTYPED_QNAME, (int)1, (boolean)false, (int)1);
        } else {
            OXMLSequenceType oXMLSequenceType2 = oXMLSequenceType = bl ? OXMLSequenceType.createNodeTypeAllowChildren(null, null, (int)1, (boolean)false, (int)1) : OXMLSequenceType.createNodeTypeAllowChildren(null, (QName)FSTypeUtil.UNTYPED_QNAME, (int)1, (boolean)false, (int)1);
        }
        if (xMLElem.kids != null) {
            n = 0;
            for (int i = 0; i < xMLElem.kids.length; ++i) {
                FSType fSType;
                block16: {
                    fSType = this.getStaticType(xMLElem.kids[i]);
                    int n2 = fSType.instanceOf((FSType)OXMLSequenceType.ATTRIBUTE_ZERO_OR_MORE);
                    if (n2 == 0) {
                        if (n != 0) {
                            this.raiseStaticTypeError("XQTY0024");
                            break block16;
                        } else {
                            xMLElem.kids[i].passStaticTyping();
                            oXMLSequenceType.addAttributeType(fSType, bl);
                            continue;
                        }
                    }
                    if (n2 == 1) {
                        n = 1;
                        xMLElem.kids[i].passStaticTyping();
                    }
                }
                if (fSType.isEmpty()) continue;
                if (FSTypeUtil.isNodeType((FSType)fSType, (int)1)) {
                    oXMLSequenceType.addChildrenType(fSType, bl);
                    continue;
                }
                if (!FSTypeUtil.isNodeType((FSType)fSType, (int)9)) continue;
                FSType fSType2 = this.getDocChildren(fSType);
                oXMLSequenceType.addChildrenType(fSType2, bl);
            }
        }
        xMLElem.setStaticType((FSType)oXMLSequenceType);
        if (xMLElem.namespaceHT != null) {
            this.queryState.popNamespaceHT();
        }
        if (xMLElem.defaultNamespaceURI != null) {
            this.queryState.popDefaultElemNS();
        }
    }

    private FSType getDocChildren(FSType fSType) {
        XMLSchema xMLSchema = this.queryState.getSchema();
        if (xMLSchema == null) {
            FSType fSType2 = FSTypeUtil.getChildrenOrAttrType((FSType)fSType, (int)1);
            if (fSType2 != null) {
                return fSType2;
            }
            return OXMLSequenceType.ELEMENT_UNTYPED_ZERO_OR_MORE;
        }
        this.setSchemaTypeChain(xMLSchema);
        FSType fSType3 = FSTypeUtil.getChildType((FSType)fSType, (XMLSchema)xMLSchema, (HashMap)this.schemaTypeChain, (String)"*", (String)"*", null);
        if (fSType3 == null) {
            return OXMLSequenceType.EMPTY_SEQUENCE;
        }
        return fSType3;
    }

    @Override
    public void visitOtherConstructor(XMLCons xMLCons) {
        switch (xMLCons.getType()) {
            case 1: 
            case 10: {
                QName qName = xMLCons.getAttrQName(this.queryState);
                if (qName == null && xMLCons.nameExpr != null) {
                    FSType fSType = this.applyFnData(xMLCons.nameExpr, false);
                    OXMLSequenceType[] oXMLSequenceTypeArray = new OXMLSequenceType[]{OXMLSequenceType.TQNAME, OXMLSequenceType.TSTRING, OXMLSequenceType.TUNTYPED};
                    int n = FSTypeUtil.isInOneOfTypes((FSType)fSType, (OXMLSequenceType[])oXMLSequenceTypeArray);
                    this.handleError(n, xMLCons.nameExpr);
                }
                if (xMLCons.kids != null) {
                    for (int i = 0; i < xMLCons.kids.length; ++i) {
                        this.applyFnData(xMLCons.kids[i]);
                    }
                }
                xMLCons.setStaticType((FSType)(qName == null ? OXMLSequenceType.createNodeType((int)2, (int)1) : OXMLSequenceType.createNodeType((QName)qName, (QName)FSTypeUtil.UNTYPED_ATOMIC_QNAME, (int)2, (boolean)false, (int)1)));
                break;
            }
            case 7: {
                FSType fSType = this.applyFnData(xMLCons.kids[0]);
                if (fSType.isEmpty()) {
                    this.replaceWithEmptySequence(xMLCons);
                    break;
                }
            }
            case 3: {
                xMLCons.setStaticType((FSType)OXMLSequenceType.TEXT_ZERO_OR_ONE);
                break;
            }
            case 5: {
                if (xMLCons.kids != null) {
                    this.applyFnData(xMLCons.kids[0]);
                }
            }
            case 2: {
                xMLCons.setStaticType((FSType)OXMLSequenceType.COMMENT_ONE);
                break;
            }
            case 6: {
                String string = xMLCons.getPIName(this.queryState);
                if (string == null && xMLCons.nameExpr != null) {
                    FSType fSType = this.applyFnData(xMLCons.nameExpr, false);
                    OXMLSequenceType[] oXMLSequenceTypeArray = new OXMLSequenceType[]{FNUtil.TNCNAME, OXMLSequenceType.TSTRING, OXMLSequenceType.TUNTYPED};
                    int n = FSTypeUtil.isInOneOfTypes((FSType)fSType, (OXMLSequenceType[])oXMLSequenceTypeArray);
                    this.handleError(n, xMLCons.nameExpr);
                }
                if (xMLCons.kids != null) {
                    this.applyFnData(xMLCons.kids[0]);
                }
            }
            case 4: {
                xMLCons.setStaticType((FSType)OXMLSequenceType.PI_ONE);
                break;
            }
            case 8: {
                this.flattenExprSequence(xMLCons);
                OXMLSequenceType oXMLSequenceType = OXMLSequenceType.createNodeTypeAllowChildren(null, (QName)FSTypeUtil.UNTYPED_QNAME, (int)9, (boolean)false, (int)1);
                if (xMLCons.kids != null) {
                    for (int i = 0; i < xMLCons.kids.length; ++i) {
                        FSType fSType = this.getStaticType(xMLCons.kids[i]);
                        int n = fSType.instanceOf((FSType)OXMLSequenceType.ATTRIBUTE_ZERO_OR_MORE);
                        if (n == 0) {
                            this.raiseStaticTypeError();
                        } else if (n == 1) {
                            xMLCons.kids[i].passStaticTyping();
                        }
                        if (fSType.isEmpty()) continue;
                        if (FSTypeUtil.isNodeType((FSType)fSType, (int)1)) {
                            oXMLSequenceType.addChildrenType(fSType, this.queryState.isPreserveMode());
                            continue;
                        }
                        if (!FSTypeUtil.isNodeType((FSType)fSType, (int)9)) continue;
                        FSType fSType2 = this.getDocChildren(fSType);
                        oXMLSequenceType.addChildrenType(fSType2, this.queryState.isPreserveMode());
                    }
                }
                xMLCons.setStaticType((FSType)oXMLSequenceType);
            }
        }
    }

    @Override
    public void visitFlwor(FLWR fLWR) {
        fLWR.setStaticType(fLWR.nsTree.staticTypeChecking(this));
    }

    @Override
    public void visitConditionalExpr(Case case_) {
        FSType fSType = this.getStaticType(case_.kids[0]);
        this.applyFnBoolean(fSType, case_.kids[0]);
        if (case_.kids[0].unknownEBV()) {
            FSChoiceType fSChoiceType = this.typeFactory.getFSChoiceType();
            for (int i = 1; i < case_.kids.length; ++i) {
                fSChoiceType.addType(this.getStaticType(case_.kids[i]));
                case_.kids[i].passStaticTyping();
            }
            case_.setStaticType((FSType)fSChoiceType);
        } else if (case_.kids[0].trueEBV()) {
            case_.setStaticType(this.getStaticType(case_.kids[1]));
            this.curExpr = case_.replaceMeWithKid(case_.kids[1]);
        } else {
            case_.setStaticType(this.getStaticType(case_.kids[2]));
            this.curExpr = case_.replaceMeWithKid(case_.kids[2]);
        }
    }

    @Override
    public void visitQuantifiedExpr(Exists exists) {
        exists.kids[0].acceptVisitor(this);
        exists.setStaticType((FSType)OXMLSequenceType.TBOOLEAN);
    }

    private FSType applyFnData(Expr expr) {
        return this.applyFnData(expr, true);
    }

    private FSType applyFnData(Expr expr, boolean bl) {
        Expr expr2;
        FSType fSType = this.getStaticType(expr);
        Expr expr3 = expr2 = bl ? this.getExpr(expr) : expr;
        if (fSType.isEmpty() || fSType.isNone()) {
            expr2.noAtomization();
            return fSType;
        }
        FSPrimeChoiceType fSPrimeChoiceType = null;
        if (fSType.getKind() == 2) {
            OXMLSequenceType oXMLSequenceType = (OXMLSequenceType)fSType;
            if (oXMLSequenceType.isNode()) {
                fSPrimeChoiceType = FSTypeUtil.applyDataOn((OXMLSequenceType)((OXMLSequenceType)fSType));
            } else {
                expr2.noAtomization();
                fSPrimeChoiceType = oXMLSequenceType;
            }
        } else {
            fSPrimeChoiceType = this.typeFactory.getFSPrimeChoiceType();
            if (FSTypeUtil.calculateFnData((FSType)fSType, (FSPrimeChoiceType)fSPrimeChoiceType)) {
                expr2.noAtomization();
            }
        }
        return fSPrimeChoiceType;
    }

    @Override
    public void visitSequenceTypeExpr(TypeOp typeOp) {
        FSType fSType = this.getStaticType(typeOp.kids[0]);
        int n = typeOp.getOperator();
        switch (n) {
            case 2: {
                FSType fSType2 = this.applyFnData(typeOp.kids[0]);
                if (fSType2.isEmpty()) {
                    switch (typeOp.userSpecifiedType.quantifier()) {
                        case 2: {
                            this.replaceWithEmptySequence(typeOp);
                            return;
                        }
                        case 1: {
                            this.raiseStaticTypeError();
                        }
                    }
                }
                int n2 = FSTypeUtil.castable((FSType)fSType2, (OXMLSequenceType)typeOp.userSpecifiedType);
                this.handleError(n2, typeOp.kids[0]);
                typeOp.setStaticType((FSType)typeOp.userSpecifiedType);
                break;
            }
            case 3: {
                FSType fSType3 = this.applyFnData(typeOp.kids[0]);
                if (fSType3.isEmpty()) {
                    switch (typeOp.userSpecifiedType.quantifier()) {
                        case 2: {
                            this.replaceWithBooleanFunction(typeOp, true);
                            return;
                        }
                        case 1: {
                            this.replaceWithBooleanFunction(typeOp, false);
                            return;
                        }
                    }
                }
                typeOp.setStaticType((FSType)OXMLSequenceType.TBOOLEAN);
                break;
            }
            case 1: {
                int n3 = fSType.instanceOf((FSType)typeOp.userSpecifiedType);
                if (n3 == 0) {
                    this.replaceWithBooleanFunction(typeOp, true);
                    break;
                }
                if (!this.isBitSet(INSIDE_UDF_BODY) && n3 == 1) {
                    this.replaceWithBooleanFunction(typeOp, false);
                    break;
                }
                typeOp.setStaticType((FSType)OXMLSequenceType.TBOOLEAN);
                break;
            }
            case 4: {
                int n4 = fSType.instanceOf((FSType)typeOp.userSpecifiedType);
                if (n4 == 0) {
                    typeOp.knowStaticType();
                    this.curExpr = typeOp.replaceMeWithKid(typeOp.kids[0]);
                } else if (n4 == 1) {
                    this.raiseStaticTypeError();
                }
                typeOp.setStaticType(fSType);
                break;
            }
            case 5: {
                VarExpr varExpr;
                int n5;
                FSChoiceType fSChoiceType = null;
                for (n5 = 1; n5 < typeOp.kids.length - 2; n5 += 2) {
                    varExpr = (VarExpr)typeOp.kids[n5];
                    int n6 = fSType.instanceOf((FSType)varExpr.getDefinedType());
                    if (n6 == 0) {
                        typeOp.setStaticType(this.getStaticType(typeOp.kids[n5 + 1]));
                        return;
                    }
                    if (n6 == 2) {
                        if (fSChoiceType == null) {
                            fSChoiceType = this.typeFactory.getFSChoiceType();
                        }
                        fSChoiceType.addType(this.getStaticType(typeOp.kids[n5 + 1]));
                        continue;
                    }
                    if (n6 != 1) continue;
                }
                if (typeOp.staticType != null) break;
                if (n5 < typeOp.kids.length - 1) {
                    varExpr = (VarExpr)typeOp.kids[n5];
                    varExpr.setStaticType(fSType);
                }
                varExpr = this.getStaticType(typeOp.kids[typeOp.kids.length - 1]);
                if (fSChoiceType == null) {
                    typeOp.setStaticType((FSType)varExpr);
                    break;
                }
                fSChoiceType.addType(this.getStaticType(typeOp.kids[typeOp.kids.length - 1]));
                typeOp.setStaticType((FSType)fSChoiceType);
            }
        }
    }

    @Override
    public void visitValidateExpr(ValidateExpr validateExpr) {
        validateExpr.kids[0].acceptVisitor(this);
    }

    public FSType visitScan(Scan scan) {
        VarExpr[] varExprArray;
        int n = 1;
        VarExpr varExpr = scan.getOutVariable();
        if (varExpr != null) {
            varExprArray = varExpr.getDefinedType();
            FSType fSType = this.getStaticType(scan.sourceExpr);
            FSType fSType2 = this.getPrime(fSType);
            if (varExprArray != null) {
                int n2 = fSType2.instanceOf((FSType)varExprArray);
                this.handleErrorPass(n2, scan.sourceExpr);
                if (n2 == 0) {
                    varExpr.setStaticType(fSType2);
                } else {
                    varExpr.setStaticType((FSType)varExprArray);
                }
            } else {
                scan.sourceExpr.passStaticTyping();
                varExpr.setStaticType(fSType2);
            }
            n = fSType.quantifier();
        }
        if ((varExprArray = scan.getLetExprs()) != null) {
            for (int i = 0; i < varExprArray.length; ++i) {
                varExprArray[i].acceptVisitor(this);
            }
        }
        return OXMLSequenceType.getConstantType((int)n, (int)1);
    }

    public FSType visitFilterProject(FilterProject filterProject) {
        VarExpr varExpr;
        Expr expr;
        int n = 1;
        if (filterProject.kids != null) {
            for (int i = 0; i < filterProject.kids.length; ++i) {
                n = FSTypeUtil.calculateQuantifier((int)n, (int)filterProject.kids[i].staticTypeChecking(this).quantifier(), (int)2);
            }
        }
        if ((expr = filterProject.getFilter()) != null) {
            varExpr = this.getStaticType(expr);
            this.applyFnBoolean((FSType)varExpr, expr);
            if (expr.trueEBV()) {
                filterProject.removeWhereClause();
            } else {
                n = FSTypeUtil.calculateQuantifier((int)n, (int)2, (int)2);
            }
        }
        varExpr = filterProject.getOutVariable();
        FSType fSType = this.getStaticType(varExpr);
        if (n == 1) {
            return fSType;
        }
        n = FSTypeUtil.calculateQuantifier((int)fSType.quantifier(), (int)n, (int)2);
        FSType fSType2 = this.getPrimeQuan(fSType, n);
        return fSType2;
    }

    public FSType visitNLJ(NLJ nLJ) {
        int n = 1;
        if (nLJ.kids != null) {
            for (int i = 0; i < nLJ.kids.length; ++i) {
                n = FSTypeUtil.calculateQuantifier((int)n, (int)nLJ.kids[i].staticTypeChecking(this).quantifier(), (int)2);
            }
        }
        return OXMLSequenceType.getConstantType((int)n, (int)1);
    }

    public FSType visitSortNS(SortNS sortNS) {
        FSType fSType = sortNS.kids[0].staticTypeChecking(this);
        if (sortNS.keys != null) {
            for (int i = 0; i < sortNS.keys.length; ++i) {
                Expr expr = sortNS.keys[i];
                FSType fSType2 = this.applyFnData(expr, false);
                FSType fSType3 = this.castUntypedAtomicHelper(fSType2, 1, expr);
                if (fSType3 != null) {
                    fSType2 = fSType3;
                }
                if (FSTypeUtil.gtComparisonOK((FSType)fSType2) != 1) continue;
                this.raiseStaticTypeError();
            }
        }
        return fSType;
    }

    @Override
    public void visitTransformExpr(TransformExpr transformExpr) {
    }

    @Override
    public void visitInsertExpr(InsertExpr insertExpr) {
        FSType fSType = this.getStaticType(insertExpr.kids[0]);
        String string = insertExpr.getType() <= 3 ? "XUTY0005" : "XUTY0006";
        int n = fSType.instanceOf((FSType)OXMLSequenceType.NODE_ONE);
        this.handleErrorPass(n, insertExpr.kids[0], string);
        insertExpr.setStaticType((FSType)OXMLSequenceType.EMPTY_SEQUENCE);
        insertExpr.setEBV(false);
    }

    @Override
    public void visitDeleteExpr(DeleteExpr deleteExpr) {
        FSType fSType = this.getStaticType(deleteExpr.kids[0]);
        int n = fSType.instanceOf((FSType)OXMLSequenceType.NODE_ZERO_OR_MORE);
        this.handleErrorPass(n, deleteExpr.kids[0], "XUTY0007");
        deleteExpr.setStaticType((FSType)OXMLSequenceType.EMPTY_SEQUENCE);
        deleteExpr.setEBV(false);
    }

    @Override
    public void visitReplaceNodeExpr(ReplaceNodeExpr replaceNodeExpr) {
        FSType fSType = this.getStaticType(replaceNodeExpr.kids[0]);
        int n = fSType.instanceOf((FSType)OXMLSequenceType.NODE_ONE);
        this.handleError(n, replaceNodeExpr.kids[0], "XUTY0008");
        n = fSType.instanceOf((FSType)OXMLSequenceType.DOCUMENT_ONE);
        if (n == 0) {
            this.raiseStaticTypeError("XUTY0008");
        }
        FSType fSType2 = this.getStaticType(replaceNodeExpr.kids[1]);
        int n2 = fSType2.instanceOf((FSType)OXMLSequenceType.ATTRIBUTE_ZERO_OR_MORE);
        n = fSType.instanceOf((FSType)OXMLSequenceType.ATTRIBUTE_ONE);
        if (n == 0 && n2 == 1) {
            this.raiseStaticTypeError("XUDY0011");
        }
        if (n == 1 && !fSType2.isEmpty() && !fSType2.isNone() && n2 == 0) {
            this.raiseStaticTypeError("XUDY0010");
        }
        replaceNodeExpr.setStaticType((FSType)OXMLSequenceType.EMPTY_SEQUENCE);
        replaceNodeExpr.setEBV(false);
    }

    @Override
    public void visitReplaceValueExpr(ReplaceValueExpr replaceValueExpr) {
        FSType fSType = this.getStaticType(replaceValueExpr.kids[0]);
        int n = fSType.instanceOf((FSType)OXMLSequenceType.NODE_ONE);
        this.handleError(n, replaceValueExpr.kids[0], "XUTY0008");
        n = fSType.instanceOf((FSType)OXMLSequenceType.DOCUMENT_ONE);
        if (n == 0) {
            this.raiseStaticTypeError("XUTY0008");
        }
        FSType fSType2 = this.applyFnData(replaceValueExpr.kids[1]);
        replaceValueExpr.setStaticType((FSType)OXMLSequenceType.EMPTY_SEQUENCE);
        replaceValueExpr.setEBV(false);
    }

    @Override
    public void visitRenameExpr(RenameExpr renameExpr) {
        FSType fSType = this.getStaticType(renameExpr.kids[0]);
        OXMLSequenceType[] oXMLSequenceTypeArray = new OXMLSequenceType[]{OXMLSequenceType.ATTRIBUTE_ONE, OXMLSequenceType.ELEMENT_ONE, OXMLSequenceType.PI_ONE};
        int n = FSTypeUtil.isInOneOfTypes((FSType)fSType, (OXMLSequenceType[])oXMLSequenceTypeArray);
        this.handleErrorPass(n, renameExpr.kids[0], "XUTY0012");
        FSType fSType2 = this.applyFnData(renameExpr.kids[1], false);
        OXMLSequenceType[] oXMLSequenceTypeArray2 = new OXMLSequenceType[]{OXMLSequenceType.TQNAME, OXMLSequenceType.TSTRING, OXMLSequenceType.TUNTYPED};
        int n2 = FSTypeUtil.isInOneOfTypes((FSType)fSType2, (OXMLSequenceType[])oXMLSequenceTypeArray2);
        this.handleError(n2, renameExpr.kids[1]);
        renameExpr.setStaticType((FSType)OXMLSequenceType.EMPTY_SEQUENCE);
        renameExpr.setEBV(false);
    }

    public void visitFunctionDefn(FunctionDefn functionDefn) {
        if (!functionDefn.isExternalFunction()) {
            this.setBit(INSIDE_UDF_BODY);
            Expr expr = functionDefn.getFunctionExpr();
            OXMLSequenceType oXMLSequenceType = functionDefn.getReturnType();
            if (oXMLSequenceType != null) {
                FSType fSType = this.normalizeParameter(oXMLSequenceType, expr);
            } else {
                functionDefn.setStaticReturnType(this.getStaticType(expr));
            }
            this.clearBit(INSIDE_UDF_BODY);
        }
    }

    private void replaceWithEmptySequence(Expr expr) {
        ExprSequence exprSequence = new ExprSequence(null);
        exprSequence.setStaticType((FSType)OXMLSequenceType.EMPTY_SEQUENCE);
        exprSequence.setEBV(false);
        expr.setStaticType(exprSequence.staticType);
        this.curExpr = expr.replaceMeWithKid(exprSequence);
    }

    private void replaceWithBooleanFunction(Expr expr, boolean bl) {
        String string = bl ? "true" : "false";
        FunctionDefn functionDefn = new FunctionDefn(string, "http://www.w3.org/2005/xpath-functions", FNFunctionLibrary.getInstance().getFunction(string, 0));
        FunctionCall functionCall = new FunctionCall(functionDefn, null);
        functionCall.setStaticType((FSType)OXMLSequenceType.TBOOLEAN);
        expr.setStaticType(functionCall.staticType);
        expr.setEBV(bl);
        this.curExpr = expr.replaceMeWithKid(functionCall);
    }

    private int isBooleanFunction(Expr expr) {
        FunctionDefn functionDefn;
        OXMLFunction oXMLFunction;
        if (expr instanceof FunctionCall && (oXMLFunction = (functionDefn = ((FunctionCall)expr).getFunctionDefn()).getFunctionObj()) != null) {
            if (oXMLFunction == FNFunctionLibrary.getInstance().getFunction("true", 0)) {
                return 0;
            }
            if (oXMLFunction == FNFunctionLibrary.getInstance().getFunction("false", 0)) {
                return 1;
            }
        }
        return 2;
    }

    private FSType getStaticType(Expr expr) {
        if (expr.staticType == null) {
            expr.acceptVisitor(this);
        }
        return expr.getStaticType();
    }

    private Expr getExpr(Expr expr) {
        if (expr.parent != null) {
            return expr;
        }
        if (this.curExpr != null) {
            return this.curExpr;
        }
        return expr;
    }

    private void passStaticTyping(Expr expr) {
        this.getExpr(expr).passStaticTyping();
    }

    private void noAtomization(Expr expr) {
        this.getExpr(expr).noAtomization();
    }

    private void noTypePromition(Expr expr) {
        this.getExpr(expr).noTypePromotion();
    }

    private void noCast(Expr expr) {
        this.getExpr(expr).noCast();
    }

    private void knowStaticType(Expr expr) {
        this.getExpr(expr).knowStaticType();
    }

    private FSType getPrime(FSType fSType) {
        FSType fSType2 = fSType.prime();
        if (fSType2 == null) {
            FSPrimeChoiceType fSPrimeChoiceType = this.typeFactory.getFSPrimeChoiceType();
            fSType.calculatePrime(fSPrimeChoiceType);
            fSPrimeChoiceType.setQuantifier(1);
            fSType2 = fSPrimeChoiceType;
        }
        return fSType2;
    }

    private FSType getPrimeQuan(FSType fSType, int n) {
        FSType fSType2 = this.getPrime(fSType);
        switch (fSType2.getKind()) {
            case 2: {
                if (n == fSType2.quantifier()) {
                    return fSType2;
                }
                return OXMLSequenceType.createSequenceType((OXMLSequenceType)((OXMLSequenceType)fSType2), (int)n);
            }
            case 6: {
                ((FSPrimeChoiceType)fSType2).setQuantifier(n);
                return fSType2;
            }
        }
        return null;
    }

    private FSType getPrimeQuan(FSType fSType) {
        switch (fSType.getKind()) {
            case 1: 
            case 2: 
            case 6: {
                return fSType;
            }
            case 3: 
            case 4: 
            case 5: {
                FSPrimeChoiceType fSPrimeChoiceType = (FSPrimeChoiceType)this.getPrime(fSType);
                fSPrimeChoiceType.setQuantifier(fSType.quantifier());
                return fSPrimeChoiceType;
            }
        }
        return null;
    }
}

