/*
 * Decompiled with CFR 0.152.
 */
package oracle.xquery.comp;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import oracle.xml.parser.v2.DocumentBuilder;
import oracle.xml.parser.v2.SAXParser;
import oracle.xquery.XQMesg;
import oracle.xquery.comp.SAXComp;
import oracle.xquery.comp.SQLComp;
import oracle.xquery.exec.Expr;
import oracle.xquery.parser.XPath;
import oracle.xquery.parser.XQXGen;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public class XQCompiler {
    private InputStream input;
    private Reader rdr;
    private boolean xqueryx;
    private XQMesg msg;

    public XQCompiler(XQMesg xQMesg) {
        this.msg = xQMesg;
    }

    public void printSQL(Expr expr, PrintStream printStream) throws Exception {
        SQLComp sQLComp = new SQLComp();
        XQXGen xQXGen = new XQXGen(sQLComp, this.msg);
        expr.toSqlDisplay(xQXGen);
        sQLComp.display(printStream);
        DocumentBuilder documentBuilder = new DocumentBuilder();
        LocatorImpl locatorImpl = new LocatorImpl();
        documentBuilder.setDocumentLocator((Locator)locatorImpl);
        documentBuilder.startDocument();
        xQXGen.setContentHandler((ContentHandler)documentBuilder, "", "");
        expr.toSqlDisplay(xQXGen);
        documentBuilder.endDocument();
        documentBuilder.getDocument().print((OutputStream)printStream);
    }

    public void parse(Reader reader, SAXComp sAXComp, boolean bl) throws Exception {
        if (bl) {
            SAXParser sAXParser = new SAXParser();
            sAXParser.setPreserveWhitespace(false);
            sAXParser.setContentHandler((ContentHandler)sAXComp);
            sAXParser.parse(reader);
        } else {
            XQXGen xQXGen = new XQXGen(sAXComp, this.msg);
            XPath.generateXQX(reader, xQXGen);
        }
    }
}

