/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.util;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.xml.soap.SOAPMessage;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.Element;

public class WSSEncryptionParams {
    private String dataEncAlg;
    private SecretKey dataEncKey;
    private String dataEncKeyName;
    private String keyEncAlg;
    private PublicKey keyEncKey;
    private byte[] iv;
    private SOAPMessage msg;
    private KeyInfoData keyInfoData;
    private X509Certificate keyEncCert;
    private String keyEncKeyName;
    private byte[] certId;
    private String mgf;
    private String digestMethod;

    public WSSEncryptionParams(String dataEncAlg, SecretKey dataEncKey, String dataEncKeyName) {
        this.dataEncAlg = dataEncAlg;
        this.dataEncKey = dataEncKey;
        this.dataEncKeyName = dataEncKeyName;
    }

    public WSSEncryptionParams(String dataEncAlg, SecretKey dataEncKey, String keyEncAlg, PublicKey keyEncKey, KeyInfoData keyInfoData) {
        this.dataEncAlg = dataEncAlg;
        this.dataEncKey = dataEncKey;
        this.keyEncAlg = keyEncAlg;
        this.keyEncKey = keyEncKey;
        this.keyInfoData = keyInfoData;
    }

    public WSSEncryptionParams(String dataEncAlg, SecretKey dataEncKey, String keyEncAlg, PublicKey keyEncKey, KeyInfoData keyInfoData, String mgf, String digestMethod) {
        this.dataEncAlg = dataEncAlg;
        this.dataEncKey = dataEncKey;
        this.keyEncAlg = keyEncAlg;
        this.keyEncKey = keyEncKey;
        this.keyInfoData = keyInfoData;
        this.mgf = mgf;
        this.digestMethod = digestMethod;
    }

    public WSSEncryptionParams(String dataEncAlg, String keyEncAlg, X509Certificate keyEncCert, String keyEncKeyName, byte[] certId) {
        this.dataEncAlg = dataEncAlg;
        this.keyEncAlg = keyEncAlg;
        this.keyEncCert = keyEncCert;
        this.keyEncKey = keyEncCert.getPublicKey();
        this.keyEncKeyName = keyEncKeyName;
        this.certId = certId;
    }

    public WSSEncryptionParams(WSSEncryptionParams encParam) {
        this.certId = encParam.certId;
        this.dataEncAlg = encParam.dataEncAlg;
        this.dataEncKey = encParam.dataEncKey;
        this.dataEncKeyName = encParam.dataEncKeyName;
        this.iv = encParam.iv;
        this.keyEncAlg = encParam.keyEncAlg;
        this.keyEncCert = encParam.keyEncCert;
        this.keyEncKey = encParam.keyEncKey;
        this.keyEncKeyName = encParam.keyEncKeyName;
        this.keyInfoData = encParam.keyInfoData;
        this.msg = encParam.msg;
        this.mgf = encParam.mgf;
        this.digestMethod = encParam.digestMethod;
        if (encParam.keyInfoData != null) {
            XMLElement origKeyInfoData = (XMLElement)encParam.keyInfoData;
            XMLElement newKeyInfoData = XMLUtils.getInstance((Element)((Element)origKeyInfoData.cloneNode(true)));
            this.keyInfoData = (KeyInfoData)newKeyInfoData;
        }
    }

    public String getDataEncryptionAlg() {
        return this.dataEncAlg;
    }

    public SecretKey getDataEncryptionKey() {
        return this.dataEncKey;
    }

    public void setDataEncryptionKey(SecretKey dataEncKey) {
        this.dataEncKey = dataEncKey;
    }

    public String getDataEncryptionKeyName() {
        return this.dataEncKeyName;
    }

    public String getKeyEncryptionAlg() {
        return this.keyEncAlg;
    }

    public void setKeyEncryptionAlg(String keyEncAlg) {
        this.keyEncAlg = keyEncAlg;
    }

    public X509Certificate getKeyEncryptionCert() {
        return this.keyEncCert;
    }

    public PublicKey getKeyEncryptionKey() {
        return this.keyEncKey;
    }

    public void setKeyEncryptionKey(PublicKey keyEncKey) {
        this.keyEncKey = keyEncKey;
    }

    public String getKeyEncryptionKeyName() {
        return this.keyEncKeyName;
    }

    public String getMGF() {
        return this.mgf;
    }

    public void setMGF(String mgf) {
        this.mgf = mgf;
    }

    public String getDigestMethod() {
        return this.digestMethod;
    }

    public void setDigestMethod(String digestMethod) {
        this.digestMethod = digestMethod;
    }

    public byte[] getCertId() {
        return this.certId;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public void setIv(byte[] iv) {
        this.iv = iv;
    }

    public KeyInfoData getKeyInfoData() {
        return this.keyInfoData;
    }

    public void setKeyInfoData(KeyInfoData keyInfoData) {
        this.keyInfoData = keyInfoData;
    }

    protected Object clone() throws CloneNotSupportedException {
        WSSEncryptionParams newEncParam = (WSSEncryptionParams)super.clone();
        if (this.keyInfoData != null) {
            XMLElement origKeyInfoData = (XMLElement)this.keyInfoData;
            XMLElement newKeyInfoData = XMLUtils.getInstance((Element)((Element)origKeyInfoData.cloneNode(true)));
            newEncParam.keyInfoData = (KeyInfoData)newKeyInfoData;
        }
        return newEncParam;
    }
}

