/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.kerberos;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.EncryptionKey;
import javax.security.auth.kerberos.KerberosTicket;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.xmlsec.wss.impl.KrbDecryptor;
import oracle.security.xmlsec.wss.impl.KrbParser;
import org.ietf.jgss.GSSContext;

public class KerberosUtils {
    private static final int AP_REQ_ID = 256;

    public static SecretKey getSessionKey(Subject subject, String svcPrincipalName) {
        Subject s = Subject.getSubject(AccessController.getContext());
        if (s != null) {
            Set<KerberosTicket> stkts = s.getPrivateCredentials(KerberosTicket.class);
            for (KerberosTicket stkt : stkts) {
                if (!stkt.getServer().getName().equals(svcPrincipalName)) continue;
                SecretKey skey = stkt.getSessionKey();
                return skey;
            }
        }
        return null;
    }

    public static SecretKey getSessionKey(GSSContext context) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> c_GSSContextImpl = Class.forName("sun.security.jgss.GSSContextImpl");
        Class<?> c_Krb5Context = Class.forName("sun.security.jgss.krb5.Krb5Context");
        Field f_mechCtxt = c_GSSContextImpl.getDeclaredField("mechCtxt");
        Method m_getKey = c_Krb5Context.getDeclaredMethod("getKey", null);
        f_mechCtxt.setAccessible(true);
        Object mechCtxt = f_mechCtxt.get(context);
        m_getKey.setAccessible(true);
        EncryptionKey encKey = (EncryptionKey)m_getKey.invoke(mechCtxt, (Object[])null);
        byte[] keyBytes = encKey.getEncoded();
        int eType = encKey.getKeyType();
        String algorithm = "DES";
        if (eType == 5 || eType == 7 || eType == 15 || eType == 16) {
            algorithm = "DESede";
        } else if (eType == 17 || eType == 18) {
            algorithm = "AES";
        } else if (eType == 23 || eType == 24) {
            algorithm = "RC4";
        }
        return new SecretKeySpec(keyBytes, algorithm);
    }

    public static SecretKey getSessionKey(Subject subject, byte[] ap_req) throws IOException {
        KrbDecryptor.EncryptionKey[] serviceKeys = KrbDecryptor.getEncryptionKeysForSubject(subject);
        KrbDecryptor.EncryptionKey tgtSessionKey = KrbDecryptor.getTGTSessionKey(subject);
        ASN1GenericConstructed obj = KrbParser.GSSUnwrap(ap_req);
        KrbParser.ApReq apReq = new KrbParser.ApReq(obj, serviceKeys, tgtSessionKey);
        if (apReq.authenticator.subkey != null) {
            return apReq.authenticator.subkey;
        }
        return apReq.ticket.key;
    }

    public static SecretKey getSessionKey(String sname, char[] passwd, byte[] ap_req) throws IOException {
        ASN1GenericConstructed obj = KrbParser.GSSUnwrap(ap_req);
        KrbParser.ApReq apReq = new KrbParser.ApReq(obj, null, null);
        int etype = apReq.ticket.edata.etype;
        KrbDecryptor.EncryptionKey serviceKey = KrbDecryptor.passwdToKey(passwd, sname, etype);
        obj = KrbParser.GSSUnwrap(ap_req);
        apReq = new KrbParser.ApReq(obj, new KrbDecryptor.EncryptionKey[]{serviceKey}, null);
        if (apReq.authenticator.subkey != null) {
            return apReq.authenticator.subkey;
        }
        return apReq.ticket.key;
    }
}

