/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss;

import java.lang.reflect.Constructor;
import javax.crypto.SecretKey;
import oracle.security.xmlsec.keys.KeyInfoData;
import oracle.security.xmlsec.saml.AuthorityBinding;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.WSSElement;
import oracle.security.xmlsec.wss.WSSEmbedded;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSKeyIdentifier;
import oracle.security.xmlsec.wss.WSSReference;
import oracle.security.xmlsec.wss.WSSURI;
import oracle.security.xmlsec.wss.WSSecurityTokenReferenceType;
import oracle.security.xmlsec.wss.saml.SAMLAssertionKeyIdentifier;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionKeyIdentifier;
import oracle.security.xmlsec.wss.util.WSSUtils;
import oracle.security.xmlsec.wss.wsc.WSCDerivedKeyToken;
import oracle.security.xmlsec.wss.x509.X509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSSecurityTokenReference
extends WSSElement
implements KeyInfoData {
    private static final String WSC_NONCE = "Nonce";
    private static final String WSC_LENGTH = "Length";

    public WSSecurityTokenReference(Element element) {
        super(element);
    }

    public WSSecurityTokenReference(Element element, String systemId) {
        super(element, systemId);
    }

    public WSSecurityTokenReference(Document owner) {
        super(owner, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference");
        if (XMLUtils.getAddTokenTypeFlag()) {
            this.setTokenType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1");
        }
    }

    public void setUsage(String usage) {
        WSSUtils.setTypeAttribute((Element)this.node, "Usage", usage);
    }

    public String getUsage() {
        return WSSUtils.getTypeAttribute((Element)this.node, "Usage");
    }

    public void setTokenType(String tokenType) {
        this.setAttributeNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", WSSecurityTokenReference.getDefaultNSPrefix((String)"http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd") + ":TokenType", tokenType);
    }

    public String getTokenType() {
        return this.getAttributeNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "TokenType");
    }

    public void setSTReference(WSSecurityTokenReferenceType ref) {
        SAMLAssertionKeyIdentifier saki;
        AuthorityBinding ab;
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"*", (String)"*");
        Node refNode = ref.getNode();
        if (this.getOwnerDocument() != refNode.getOwnerDocument()) {
            refNode = this.getOwnerDocument().importNode(refNode, true);
        }
        if (ref instanceof SAMLAssertionKeyIdentifier && (ab = (saki = new SAMLAssertionKeyIdentifier((Element)refNode)).getAuthorityBinding()) != null) {
            this.appendChild(ab.getNode());
        }
        if (ref instanceof SAML2AssertionKeyIdentifier) {
            this.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        }
        this.appendChild(refNode);
    }

    public WSSecurityTokenReferenceType getSTReference() throws WSSException {
        NodeList list = this.getChildElementsByTagName("*");
        if (list.getLength() > 0) {
            Element ab = (Element)list.item(0);
            String localName = ab.getLocalName();
            String ns = ab.getNamespaceURI();
            if (ns.equals("urn:oasis:names:tc:SAML:1.0:assertion") && localName.equals("AuthorityBinding") && list.getLength() > 1) {
                SAMLAssertionKeyIdentifier ski = (SAMLAssertionKeyIdentifier)WSSecurityTokenReference.createSTReference((Element)list.item(1));
                ski.setAuthorityBinding(new AuthorityBinding((Element)list.item(0)));
                return ski;
            }
            return WSSecurityTokenReference.createSTReference((Element)list.item(0));
        }
        throw new WSSException(WSSException.INVALID_SECURITY_TOKEN);
    }

    public String getType() {
        return null;
    }

    public static WSSecurityTokenReferenceType createSTReference(Element element) throws WSSException {
        WSSecurityTokenReferenceType ref = null;
        String localName = element.getLocalName();
        String ns = element.getNamespaceURI();
        if (ns.equals("http://www.w3.org/2000/09/xmldsig#")) {
            if (localName.equals("X509IssuerSerial")) {
                return new X509IssuerSerial(element);
            }
            NodeList isList = XMLElement.getChildElementsByTagNameNS((Element)element, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"X509IssuerSerial");
            int n = isList.getLength();
            if (n > 0) {
                Element e = (Element)isList.item(0);
                return new X509IssuerSerial(e);
            }
        }
        QName tag = new QName(localName, ns, null);
        Object valType = null;
        if (WSSURI.str_EMBEDDED.equals((Object)tag)) {
            ref = new WSSEmbedded(element);
        } else {
            String valTypeStr = element.getAttribute("ValueType");
            try {
                Class<WSSKeyIdentifier> c = null;
                if (WSSURI.str_REFERENCE.equals((Object)tag)) {
                    c = URIManager.getURIManager().getClassForURI(valTypeStr, "useReference");
                    if (c == null) {
                        c = WSSReference.class;
                    }
                } else if (WSSURI.str_KEY_IDENTIFIER.equals((Object)tag) && (c = URIManager.getURIManager().getClassForURI(valTypeStr, "useIdentifier")) == null) {
                    c = WSSKeyIdentifier.class;
                }
                if (c != null) {
                    Constructor x = c.getConstructor(Element.class);
                    ref = (WSSecurityTokenReferenceType)x.newInstance(element);
                }
            }
            catch (Exception ex) {
                throw new WSSException(ex, WSSException.INVALID_SECURITY);
            }
        }
        if (ref == null) {
            String msg = "Tag = " + tag.toString();
            if (valType != null) {
                msg = msg + "ValueType  = " + valType.toString();
            }
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE, "Unknown token reference element: " + msg);
        }
        return ref;
    }

    public byte[] getDerivedKeyNonce() {
        if (!this.hasAttributeNS("http://schemas.xmlsoap.org/ws/2005/02/sc", WSC_NONCE)) {
            return null;
        }
        return Base64.fromBase64((String)this.getAttributeNS("http://schemas.xmlsoap.org/ws/2005/02/sc", WSC_NONCE));
    }

    public void setDerivedKeyNonce(byte[] nonce) {
        if (nonce == null) {
            this.removeAttributeNS("http://schemas.xmlsoap.org/ws/2005/02/sc", WSC_NONCE);
        } else {
            this.setAttributeNS("http://schemas.xmlsoap.org/ws/2005/02/sc", WSC_NONCE, Base64.toBase64((byte[])nonce, (boolean)false));
        }
    }

    public Integer getDerivedKeyLength() {
        if (!this.hasAttributeNS("http://schemas.xmlsoap.org/ws/2005/02/sc", WSC_LENGTH)) {
            return null;
        }
        return Integer.parseInt(this.getAttributeNS("http://schemas.xmlsoap.org/ws/2005/02/sc", WSC_LENGTH));
    }

    public void setDerivedKeyLength(Integer length) {
        if (length == null) {
            this.removeAttributeNS("http://schemas.xmlsoap.org/ws/2005/02/sc", WSC_LENGTH);
        } else {
            this.setAttributeNS("http://schemas.xmlsoap.org/ws/2005/02/sc", WSC_LENGTH, length.toString());
        }
    }

    public SecretKey computeImpliedDerivedKeys(SecretKey key) {
        byte[] nonce = this.getDerivedKeyNonce();
        if (nonce == null) {
            return key;
        }
        Integer length = this.getDerivedKeyLength();
        if (length == null) {
            length = 32;
        }
        return WSCDerivedKeyToken.deriveKey(key, nonce, "WS-SecureConversationWS-SecureConversation", 0, length);
    }
}

