/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss;

import java.util.ArrayList;
import java.util.List;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.WSSElement;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSKeyIdentifierResolver;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.WSSecurityTokenReferenceType;
import oracle.security.xmlsec.wss.util.WSSTokenUtils;
import oracle.security.xmlsec.wss.util.WSSUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSKeyIdentifier
extends WSSElement
implements WSSecurityTokenReferenceType {
    public static final String vt_ThumbprintSHA1 = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1";
    private static ArrayList resolverList = new ArrayList();

    public WSSKeyIdentifier(Element element) {
        super(element);
    }

    public WSSKeyIdentifier(Element element, String systemId) {
        super(element, systemId);
    }

    public WSSKeyIdentifier(Document owner) {
        super(owner, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier");
    }

    public WSSKeyIdentifier(Document owner, String valType) {
        this(owner, valType, null);
    }

    public WSSKeyIdentifier(Document owner, String valType, String encType) {
        this(owner);
        if (valType != null) {
            WSSUtils.setTypeAttribute((Element)this.node, "ValueType", valType);
        }
        if (encType != null) {
            WSSUtils.setTypeAttribute((Element)this.getNode(), "EncodingType", encType);
        }
    }

    public void setValueType(String valType) {
        WSSUtils.setTypeAttribute((Element)this.node, "ValueType", valType);
    }

    public String getValueType() {
        String valueType = WSSUtils.getTypeAttribute((Element)this.node, "ValueType");
        if (valueType.startsWith("#")) {
            valueType = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1" + valueType;
        }
        return valueType;
    }

    public void setEncodingType(String encType) {
        WSSUtils.setTypeAttribute((Element)this.node, "EncodingType", encType);
    }

    public String getEncodingType() {
        String encType = WSSUtils.getTypeAttribute((Element)this.node, "EncodingType");
        if (encType == null || encType.length() == 0) {
            encType = this.getDefaultEncodingType();
        }
        return encType;
    }

    protected String getDefaultEncodingType() {
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    }

    public void setValue(byte[] value) {
        this.appendChild(this.getOwnerDocument().createTextNode(WSSTokenUtils.createBinaryDataEncoder(this.getEncodingType()).encode(value)));
    }

    public byte[] getValue() {
        String valStr = XMLUtils.collectText((Node)this.node);
        return WSSTokenUtils.createBinaryDataEncoder(this.getEncodingType()).decode(valStr);
    }

    @Override
    public QName getName() {
        return new QName("KeyIdentifier", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", null);
    }

    public byte[] getThumbprint() {
        return this.getValueType().equals(vt_ThumbprintSHA1) ? this.getValue() : null;
    }

    public static void addResolver(WSSKeyIdentifierResolver resolver) {
        resolverList.add(resolver);
    }

    public static List getResolvers() {
        return resolverList;
    }

    @Override
    public Object getKey() throws WSSException {
        Object key = null;
        int n = resolverList.size();
        for (int i = 0; i < n && key == null; ++i) {
            WSSKeyIdentifierResolver r = (WSSKeyIdentifierResolver)resolverList.get(i);
            key = r.getKey(this, this.getValueType());
        }
        return key;
    }

    @Override
    public WSSecurityToken getSecurityToken() throws WSSException {
        WSSecurityToken token = null;
        int n = resolverList.size();
        for (int i = 0; i < n && token == null; ++i) {
            WSSKeyIdentifierResolver r = (WSSKeyIdentifierResolver)resolverList.get(i);
            token = r.getSecurityToken(this, this.getValueType());
        }
        return token;
    }
}

