/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.gallery;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.gallery.ElementInfo;
import oracle.ide.gallery.GalleryElement;
import oracle.ide.gallery.GalleryHandler;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.util.Assert;

public final class GalleryElementActionFactory {
    private static final Logger LOGGER = Logger.getLogger(GalleryElementActionFactory.class.getName());
    private static final String GALLERY_ITEM_REF = "gallery-element-action";
    private static final Controller GALLERY_ELEMENT_ACTION_CONTROLLER = new GIC();
    private static final GalleryElementActionFactory _instance = new GalleryElementActionFactory();
    private final Set<ElementInfo> _lazilyRegisteredElementInfos = new HashSet<ElementInfo>();

    private GalleryElementActionFactory() {
    }

    public static GalleryElementActionFactory getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void itemRegistered(ElementInfo info) {
        if (!GalleryHandler.get().isRegistered(info)) {
            Set<ElementInfo> set = this._lazilyRegisteredElementInfos;
            synchronized (set) {
                this._lazilyRegisteredElementInfos.add(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void itemUnregistered(ElementInfo info) {
        Set<ElementInfo> set = this._lazilyRegisteredElementInfos;
        synchronized (set) {
            this._lazilyRegisteredElementInfos.remove(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElementInfo[] lazilyRegisteredElementInfos() {
        Set<ElementInfo> set = this._lazilyRegisteredElementInfos;
        synchronized (set) {
            return this._lazilyRegisteredElementInfos.toArray(new ElementInfo[0]);
        }
    }

    public IdeAction actionForItemNamed(String galleryItemClassName, String id) {
        ElementInfo elementInfo;
        IdeAction action = null;
        Integer cmdId = Ide.findCmdID((String)this.actionId(galleryItemClassName, id));
        action = cmdId == null ? ((elementInfo = GalleryHandler.get().elementInfo(galleryItemClassName, id)) != null ? this.actionForGalleryElement(elementInfo.createElement()) : this.actionForLazyElement(galleryItemClassName, id)) : IdeAction.get((int)cmdId);
        return action;
    }

    private IdeAction actionForLazyElement(String galleryItemClassName, String id) {
        if (galleryItemClassName != null) {
            for (ElementInfo e : this.lazilyRegisteredElementInfos()) {
                try {
                    if (galleryItemClassName.equals(e.getInvokableClassName()) && (e.getId() == null ? id == null : e.getId().equals(id))) {
                        return this.actionForGalleryElement(e.createElement());
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, e + " caused exception ", ex);
                }
            }
        }
        return null;
    }

    private IdeAction actionForGalleryElement(GalleryElement element) {
        Integer cmdId = Ide.findOrCreateCmdID((String)this.actionId(element.getInvokableClass(), element.getId()));
        IdeAction action = IdeAction.get((int)cmdId);
        action.putValue(GALLERY_ITEM_REF, (Object)element);
        action.putValue("Name", (Object)(element.getName() + "..."));
        action.putValue("SmallIcon", (Object)element.getIcon());
        action.addController(GALLERY_ELEMENT_ACTION_CONTROLLER);
        return action;
    }

    private String actionId(String invokable, String id) {
        if (id != null) {
            return invokable + "." + id;
        }
        return invokable;
    }

    private static class GIC
    implements Controller {
        private GIC() {
        }

        public boolean handleEvent(IdeAction action, Context context) {
            Object galleryElement = action.getValue(GalleryElementActionFactory.GALLERY_ITEM_REF);
            Assert.check((boolean)(galleryElement instanceof GalleryElement));
            GalleryManager.getGalleryManager().getGallery().invokeWizard((GalleryElement)galleryElement, context);
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            Object galleryElement = action.getValue(GalleryElementActionFactory.GALLERY_ITEM_REF);
            Assert.check((boolean)(galleryElement instanceof GalleryElement));
            boolean enabled = ((GalleryElement)galleryElement).isAvailable(context);
            action.setEnabled(enabled);
            return true;
        }
    }
}

