/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.triggers;

import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.TimingEvent;
import org.jdesktop.animation.timing.TimingListener;
import org.jdesktop.animation.timing.triggers.TimingTriggerEvent;
import org.jdesktop.animation.timing.triggers.Trigger;
import org.jdesktop.animation.timing.triggers.TriggerEvent;
import org.jdesktop.animation.timing.triggers.TriggerListener;

public class TimingTrigger
extends Trigger {
    public TimingTrigger(TimingController timingController, TimingController timingController2, Trigger.TriggerAction triggerAction, TimingTriggerEvent timingTriggerEvent) {
        this.setupListener(timingController, timingController2, triggerAction, timingTriggerEvent);
    }

    public TimingTrigger(TimingController timingController, TimingController timingController2, TimingTriggerEvent timingTriggerEvent, TimingController timingController3) {
        super(timingController, timingController2, timingTriggerEvent, timingController3);
    }

    @Override
    protected void setupListener(TimingController timingController, Object object, Trigger.TriggerAction triggerAction, TriggerEvent triggerEvent) {
        try {
            TimingTriggerListener timingTriggerListener = new TimingTriggerListener(timingController, triggerAction, (TimingTriggerEvent)triggerEvent);
            this.setupListener(object, timingTriggerListener, "addTimingListener", TimingListener.class);
        }
        catch (Exception exception) {
            System.out.println("Exception creating timing listener for object " + object + ": " + exception);
        }
    }

    private class TimingTriggerListener
    extends TriggerListener
    implements TimingListener {
        TimingTriggerEvent event;

        protected TimingTriggerListener(TimingController timingController, Trigger.TriggerAction triggerAction, TimingTriggerEvent timingTriggerEvent) {
            super(timingController, triggerAction);
            this.event = timingTriggerEvent;
        }

        @Override
        public void timerStarted(TimingEvent timingEvent) {
            if (this.event == TimingTriggerEvent.START) {
                this.pullTrigger();
            }
        }

        @Override
        public void timerStopped(TimingEvent timingEvent) {
            if (this.event == TimingTriggerEvent.STOP) {
                this.pullTrigger();
            }
        }

        @Override
        public void timerRepeated(TimingEvent timingEvent) {
            if (this.event == TimingTriggerEvent.REPEAT) {
                this.pullTrigger();
            }
        }
    }
}

