/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem.editor;

import com.oracle.jdeveloper.nbwindowsystem.NbEditorManager;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorCreation;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorCriteriaImpl;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorPathImpl;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorState;
import com.oracle.jdeveloper.nbwindowsystem.editor.EditorUtil;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPane;
import com.oracle.jdeveloper.nbwindowsystem.editor.SplitPaneState;
import com.oracle.jdeveloper.nbwindowsystem.editor.TabGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.editor.DefaultEditorManager;
import oracle.ideimpl.editor.RecentFilesLRU;

public final class TabGroupState
implements Observer {
    private TabGroup _parentTabGroup;
    private Context _context;
    private int _currentSplitPanePos = -1;
    private final ArrayList _splitPaneStates = new ArrayList();
    private StructuredPropertyAccess _structuredPropertyAccess;
    private int _acceleratorNo = -1;
    private SplitPaneState[] _reservedEditors;
    private List _editorAddins;

    public TabGroupState(TabGroup parentTabGroup, EditorCreation editorCreation) {
        this._parentTabGroup = parentTabGroup;
        OpenEditorOptions openEditorOptions = editorCreation.getOpenEditorOptions();
        Context context = openEditorOptions.getContext();
        this.setContext(context);
        List addins = editorCreation.getEditorAddins();
        this.setEditorAddins(addins);
    }

    TabGroupState(TabGroup parentTabGroup) {
        this._parentTabGroup = parentTabGroup;
    }

    public void setParentTabGroup(TabGroup parentTabGroup) {
        this._parentTabGroup = parentTabGroup;
    }

    public TabGroup getParentTabGroup() {
        return this._parentTabGroup;
    }

    public SplitPaneState createSplitPaneState(EditorCreation editorCreation) {
        int pos;
        SplitPaneState ret = null;
        SplitPaneState splitPaneState = new SplitPaneState(editorCreation, this);
        int editorClassPos = 0;
        Class editorClass = editorCreation.getOpenEditorOptions().getEditorClass();
        if (editorClass != null && (pos = splitPaneState.searchEditorPos(editorClass)) != -1) {
            editorClassPos = pos;
        }
        if (splitPaneState.setCurrentEditorStatePos(editorClassPos)) {
            ret = splitPaneState;
        }
        return ret;
    }

    public void addSplitPaneState(SplitPaneState splitPaneState) {
        this._splitPaneStates.add(splitPaneState);
        if (this._currentSplitPanePos == -1) {
            this.setCurrentSplitPanePos(0);
        }
        int editorStatesCount = splitPaneState.getEditorStateCount();
        for (int i = 0; i < editorStatesCount; ++i) {
            EditorState editorState = splitPaneState.getEditorState(i);
            SplitPaneState reservedEditorState = this.getReservedEditorState(i);
            boolean isEnabled = reservedEditorState == null || reservedEditorState == splitPaneState;
            editorState.setEnabled(isEnabled);
        }
    }

    public int getSplitPaneStateCount() {
        return this._splitPaneStates.size();
    }

    public SplitPane getSplitPane(int i) {
        SplitPaneState splitPaneState = this.getSplitPaneState(i);
        if (splitPaneState != null) {
            return splitPaneState.getSplitPane();
        }
        return null;
    }

    public SplitPaneState getSplitPaneState(int i) {
        if (i >= 0 && i < this._splitPaneStates.size()) {
            return (SplitPaneState)this._splitPaneStates.get(i);
        }
        return null;
    }

    int indexOf(SplitPaneState splitPaneState) {
        int count = this.getSplitPaneStateCount();
        for (int i = 0; i < count; ++i) {
            if (splitPaneState != this.getSplitPaneState(i)) continue;
            return i;
        }
        return -1;
    }

    private void setCurrentSplitPanePos(int currentSplitPanePos) {
        if (this._currentSplitPanePos != currentSplitPanePos) {
            this._currentSplitPanePos = currentSplitPanePos;
            SplitPaneState splitPaneState = this._currentSplitPanePos != -1 ? this.getSplitPaneState(currentSplitPanePos) : null;
            this.whenCurrentEditorChanges(splitPaneState);
        }
    }

    boolean getCurrentEditorPath(EditorPathImpl editorPath) {
        SplitPaneState splitPaneState;
        boolean ret = false;
        editorPath._panePos = this.getCurrentSplitPanePos();
        if (editorPath._panePos != -1 && (splitPaneState = this.getSplitPaneState(editorPath._panePos)) != null) {
            ret = splitPaneState.getCurrentEditorPath(editorPath);
        }
        return ret;
    }

    public int getCurrentSplitPanePos() {
        return this._currentSplitPanePos;
    }

    public SplitPane getCurrentSplitPane() {
        SplitPane splitPane = null;
        if (this._currentSplitPanePos != -1) {
            splitPane = this.getSplitPane(this._currentSplitPanePos);
        }
        return splitPane;
    }

    public SplitPaneState getCurrentSplitPaneState() {
        SplitPaneState splitPaneState = null;
        if (this._currentSplitPanePos != -1) {
            splitPaneState = this.getSplitPaneState(this._currentSplitPanePos);
        }
        return splitPaneState;
    }

    public Editor getCurrentEditor() {
        Editor ret = null;
        SplitPaneState currentSplitPaneState = this.getCurrentSplitPaneState();
        if (currentSplitPaneState != null) {
            ret = currentSplitPaneState.getCurrentEditor();
        }
        return ret;
    }

    public Context getContext() {
        return this._context;
    }

    public void setContext(Context context) {
        Node node;
        if (this._context != null) {
            node = this._context.getNode();
            node.detach((Observer)this);
        }
        this._context = context;
        if (this._context != null) {
            node = this._context.getNode();
            node.attach((Observer)this);
        }
    }

    private void setEditorAddins(List editorAddins) {
        this._editorAddins = editorAddins;
        if (editorAddins != null) {
            int editorAddinsSize = editorAddins.size();
            this._reservedEditors = new SplitPaneState[editorAddinsSize];
        } else {
            this._reservedEditors = null;
        }
    }

    List getEditorAddins() {
        return this._editorAddins;
    }

    public boolean match(EditorCriteriaImpl editorCriteria) {
        boolean ret = false;
        switch (editorCriteria.getType()) {
            case 2: {
                ret = EditorUtil.isSameNode(editorCriteria.getContext(), this.getContext());
                break;
            }
            case 1: {
                ret = EditorUtil.isSameNode(editorCriteria.getNode(), this.getContext().getNode());
                break;
            }
            case 12: {
                ret = this.equals(editorCriteria.getCriteria1());
                break;
            }
            case 14: {
                ret = this.getNodeNumber() == editorCriteria.getAssignedKey();
            }
        }
        return ret;
    }

    public boolean searchEditor(EditorPathImpl editorPath, EditorCriteriaImpl editorCriteria) {
        boolean ret = false;
        if (editorCriteria.getType() == 10) {
            Context context = editorCriteria.getContext();
            if (EditorUtil.isSameNode(context, this.getContext())) {
                ret = this.searchBestEditor(editorPath, editorCriteria.getEditorClass());
            }
        } else {
            int n = this.getSplitPaneStateCount();
            for (int i = 0; !ret && i < n; ++i) {
                SplitPaneState splitPaneState = this.getSplitPaneState(i);
                if (!SplitPaneState.match(editorCriteria) && !splitPaneState.searchEditor(editorPath, editorCriteria)) continue;
                editorPath._panePos = i;
                ret = true;
            }
        }
        return ret;
    }

    private boolean searchBestEditor(EditorPathImpl editorPath, Class editorClass) {
        int currentEditorStatePos;
        boolean ret = false;
        int currentSplitPanePos = this.getCurrentSplitPanePos();
        SplitPaneState currentSplitPaneState = this.getSplitPaneState(currentSplitPanePos);
        EditorState currentEditorState = currentSplitPaneState.getEditorState(currentEditorStatePos = currentSplitPaneState.getCurrentEditorStatePos());
        EditorAddin currentEditorAddin = currentEditorState.getEditorAddin();
        Class currentEditorClass = currentEditorAddin.getEditorClass();
        if (editorClass.equals(currentEditorClass)) {
            editorPath._panePos = currentSplitPanePos;
            editorPath._editorPos = currentEditorStatePos;
            ret = true;
        }
        if (!ret) {
            EditorState editorState;
            EditorAddin editorAddin;
            int splitPanePos;
            int splitPaneStateCount = this.getSplitPaneStateCount();
            for (splitPanePos = 0; !ret && splitPanePos < splitPaneStateCount; ++splitPanePos) {
                Class currentEditorClass2;
                SplitPaneState splitPaneState = this.getSplitPaneState(splitPanePos);
                int currentEditorStatePos2 = splitPaneState.getCurrentEditorStatePos();
                if (currentEditorStatePos2 == -1 || !editorClass.equals(currentEditorClass2 = (editorAddin = (editorState = splitPaneState.getEditorState(currentEditorStatePos2)).getEditorAddin()).getEditorClass())) continue;
                editorPath._panePos = splitPanePos;
                editorPath._editorPos = currentEditorStatePos2;
                ret = true;
            }
            if (!ret) {
                for (splitPanePos = 0; !ret && splitPanePos < splitPaneStateCount; ++splitPanePos) {
                    SplitPaneState splitPaneState_i = this.getSplitPaneState(splitPanePos);
                    int editorStateCount = splitPaneState_i.getEditorStateCount();
                    for (int editorStatePos = 0; editorStatePos < editorStateCount; ++editorStatePos) {
                        Class<?> editorClass_i;
                        EditorState editorState2 = splitPaneState_i.getEditorState(editorStatePos);
                        Editor editor = editorState2.getEditor();
                        if (editor == null || !editorClass.equals(editorClass_i = editor.getClass())) continue;
                        editorPath._panePos = splitPanePos;
                        editorPath._editorPos = editorStatePos;
                        ret = true;
                    }
                }
                if (!ret) {
                    SplitPaneState currentSplitPaneState2 = this.getSplitPaneState(currentSplitPanePos);
                    int editorStateCount = currentSplitPaneState2.getEditorStateCount();
                    for (int editorStatePos = 0; editorStatePos < editorStateCount; ++editorStatePos) {
                        editorState = currentSplitPaneState2.getEditorState(editorStatePos);
                        editorAddin = editorState.getEditorAddin();
                        Class editorClass_i = editorAddin.getEditorClass();
                        if (!editorClass.equals(editorClass_i)) continue;
                        editorPath._panePos = currentSplitPanePos;
                        editorPath._editorPos = editorStatePos;
                        ret = true;
                    }
                }
            }
        }
        return ret;
    }

    public boolean activateEditor(EditorPathImpl editorPath) {
        boolean ret = false;
        int panePos = editorPath._panePos != -1 ? editorPath._panePos : this.getCurrentSplitPanePos();
        SplitPaneState splitPaneState = this.getSplitPaneState(panePos);
        if (splitPaneState == null) {
            return ret;
        }
        if (splitPaneState.activateEditor(editorPath)) {
            this.setCurrentSplitPanePos(panePos);
            ret = true;
        }
        return ret;
    }

    int getNodeNumber() {
        return this._acceleratorNo;
    }

    void setNodeNumber(int acceleratorNo) {
        this._acceleratorNo = acceleratorNo;
        this.getParentTabGroup().whenTabGroupStateChanged(this);
    }

    Icon getNodeIcon() {
        Icon baseIcon = this.getBaseIcon();
        Icon icon = null;
        icon = baseIcon;
        return icon;
    }

    private Icon getBaseIcon() {
        Context context = this.getContext();
        Node node = context.getNode();
        Icon ret = node.getIcon();
        return ret;
    }

    boolean isExplicit() {
        return this.getNodeNumber() >= 0;
    }

    private boolean hasAccelerator() {
        int nodeNumber = this.getNodeNumber();
        return false;
    }

    public String getLongLabel() {
        String ret;
        Context context = this.getContext();
        if (context == null || context.getNode() == null) {
            return null;
        }
        Node node = context.getNode();
        String longLabel = node.getLongLabel();
        if (this.hasAccelerator()) {
            int nodeNumber = this.getNodeNumber();
            NbEditorManager editorManager = NbEditorManager.getInstance();
            String activateCmdTooltip = editorManager.getActivateCmdTooltip(nodeNumber);
            ret = longLabel + " (" + activateCmdTooltip + ")";
        } else {
            ret = longLabel;
        }
        return ret;
    }

    public StructuredPropertyAccess getStructPersistence() {
        return this._structuredPropertyAccess;
    }

    public void setStructPersistence(StructuredPropertyAccess structuredPropertyAccess) {
        this._structuredPropertyAccess = structuredPropertyAccess;
    }

    public void closeSplitPaneState(int pos) {
        SplitPaneState splitPaneState = this.getSplitPaneState(pos);
        if (splitPaneState == null) {
            return;
        }
        SplitPane splitPane = splitPaneState.getSplitPane();
        if (splitPane != null) {
            splitPane.setSplitPaneState(null);
        }
        splitPaneState.setCurrentEditorStatePos(-1);
        DefaultListModel editorsModel = splitPaneState.getEditorsModel();
        int size = editorsModel.getSize();
        for (int i = 0; i < size; ++i) {
            DefaultCustomTabPage page = (DefaultCustomTabPage)editorsModel.get(i);
            EditorState editorState = (EditorState)page.getUserObject();
            if (editorState == null) continue;
            editorState.replaceEditor(null);
        }
        if (pos <= this._currentSplitPanePos) {
            --this._currentSplitPanePos;
            if (this._currentSplitPanePos < 0 && this.getSplitPaneStateCount() > 1) {
                ++this._currentSplitPanePos;
            }
        }
        this._splitPaneStates.remove(pos);
    }

    public void update(Object observed, UpdateMessage change) {
        int messageID = change.getMessageID();
        if (messageID == UpdateMessage.OBJECT_CLOSED) {
            this.whenObjectClosed();
        } else if (messageID == UpdateMessage.OBJECT_RENAMED) {
            this.whenObjectChanged();
        } else if (messageID == UpdateMessage.ATTRIBUTE_CHANGED) {
            this.whenAttributeChanged();
        }
    }

    private void whenObjectClosed() {
        final Editor editor = this.getCurrentEditor();
        if (editor != null) {
            RecentFile recentFile;
            RecentFilesLRU recentFilesLRU = NbEditorManager.getInstance().getRecentFilesLRU();
            RecentFile recentFile2 = recentFile = recentFilesLRU != null ? recentFilesLRU.getRecentFile(editor.getContext()) : null;
            if (recentFile != null) {
                recentFile.setReopen(true);
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    NbEditorManager.getInstance().closeEditors(Collections.singletonList(editor), false);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }
    }

    private void whenAttributeChanged() {
        Editor currentEditor;
        boolean isDirty;
        Context context = this.getContext();
        Node node = null;
        if (context != null) {
            node = context.getNode();
        } else {
            Logger.getAnonymousLogger().log(Level.WARNING, "Context is null for TabGroupState " + this);
        }
        if (node != null && (isDirty = node.isDirty()) && (currentEditor = this.getCurrentEditor()) != null) {
            NbEditorManager editorManager = NbEditorManager.getInstance();
            editorManager.setExplicit(currentEditor, true);
        }
        this.whenObjectChanged();
    }

    private void whenObjectChanged() {
        this.getParentTabGroup().whenTabGroupStateChanged(this);
    }

    void dispose() {
        this.setContext(null);
        this.setEditorAddins(null);
    }

    void reserveEditorStates(SplitPaneState splitPaneState, int editorStatePos, boolean reserved) {
        EditorState editorState = splitPaneState.getEditorState(editorStatePos);
        boolean splittable = editorState.isSplittable();
        SplitPaneState newValue = reserved && !splittable ? splitPaneState : null;
        this.setReservedEditorState(editorStatePos, newValue);
    }

    private void setReservedEditorState(int editorStatePos, SplitPaneState newValue) {
        SplitPaneState oldValue = this._reservedEditors[editorStatePos];
        if (oldValue != newValue) {
            this._reservedEditors[editorStatePos] = newValue;
            int splitPaneStateCount = this.getSplitPaneStateCount();
            for (int i = 0; i < splitPaneStateCount; ++i) {
                SplitPaneState splitPaneState_i = this.getSplitPaneState(i);
                EditorState editorState_i = splitPaneState_i.getEditorState(editorStatePos);
                boolean isEnabled = newValue == null || newValue == splitPaneState_i;
                editorState_i.setEnabled(isEnabled);
            }
        }
    }

    SplitPaneState getReservedEditorState(int editorStatePos) {
        return this._reservedEditors[editorStatePos];
    }

    public void whenCurrentEditorChanges(SplitPaneState splitPaneState) {
        TabGroup tabGroup = this.getParentTabGroup();
        if (tabGroup != null) {
            tabGroup.whenCurrentEditorChanges(this);
        }
    }

    public void whenEditorActivated(SplitPaneState splitPaneState) {
        SplitPaneState currentSplitPaneState;
        int currentSplitPanePos = this.getCurrentSplitPanePos();
        SplitPaneState splitPaneState2 = currentSplitPaneState = currentSplitPanePos == -1 ? null : this.getSplitPaneState(currentSplitPanePos);
        if (currentSplitPaneState != splitPaneState) {
            int splitPaneStatePos = this.indexOf(splitPaneState);
            this.setCurrentSplitPanePos(splitPaneStatePos);
        }
        this.getParentTabGroup().whenEditorActivated(this);
    }

    void dump(String indent, boolean isActive) {
        Node node;
        Context context = this.getContext();
        String label = context != null ? ((node = context.getNode()) != null ? node.getShortLabel() : "node = null") : "context = null";
        System.out.println(indent + "TabGroupState" + (isActive ? "*" : "") + " - " + label);
        int splitPaneStateCount = this.getSplitPaneStateCount();
        for (int i = 0; i < splitPaneStateCount; ++i) {
            SplitPaneState splitPaneState = this.getSplitPaneState(i);
            boolean active = i == this._currentSplitPanePos;
            splitPaneState.dump(indent + "  ", active);
        }
    }

    EditorAddin findBestDuplicatedEditor(EditorAddin editorAddin) {
        EditorAddin ret = null;
        if (editorAddin.isDuplicable()) {
            ret = editorAddin;
        } else {
            NbEditorManager editorManager = NbEditorManager.getInstance();
            Context context = this.getContext();
            Node node = context.getNode();
            EditorAddin defaultAddin = editorManager.getDefaultAddin(context);
            if (this.isGoodDuplicatedEditor(defaultAddin)) {
                ret = defaultAddin;
            } else {
                List<EditorAddin> addins = editorManager._getAddins(context);
                for (int i = 0; ret == null && i < addins.size(); ++i) {
                    EditorAddin editorAddin_i = addins.get(i);
                    if (!this.isGoodDuplicatedEditor(editorAddin_i)) continue;
                    ret = editorAddin_i;
                }
            }
        }
        return ret;
    }

    private boolean isGoodDuplicatedEditor(EditorAddin editorAddin) {
        for (int i = 0; i < this._reservedEditors.length; ++i) {
            EditorState reservedEditorState;
            EditorAddin reservedEditorAddin;
            SplitPaneState reservedEditor = this._reservedEditors[i];
            if (reservedEditor == null || !editorAddin.equals(reservedEditorAddin = (reservedEditorState = reservedEditor.getCurrentEditorState()).getEditorAddin())) continue;
            return false;
        }
        return true;
    }

    public void focusCurrentEditor() {
        SplitPane currentSplitPane = this.getCurrentSplitPane();
        if (currentSplitPane != null) {
            currentSplitPane.focusCurrentEditor();
        }
    }

    public void handleEvent(int commandId) {
        if (commandId == DefaultEditorManager.NEXT_PANE_CMD_ID || commandId == DefaultEditorManager.PREV_PANE_CMD_ID) {
            int currentSplitPanePos = this.getCurrentSplitPanePos();
            int newSplitPanePos = commandId == DefaultEditorManager.NEXT_PANE_CMD_ID ? currentSplitPanePos + 1 : currentSplitPanePos - 1;
            this.setCurrentSplitPanePos(newSplitPanePos);
            SplitPane splitPane = this.getSplitPane(newSplitPanePos);
            splitPane.focusCurrentEditor();
        }
    }

    public boolean canDo(IdeAction action) {
        boolean ret = false;
        int commandId = action.getCommandId();
        if (commandId == DefaultEditorManager.NEXT_PANE_CMD_ID) {
            int splitPaneStateCount;
            int currentSplitPanePos = this.getCurrentSplitPanePos();
            ret = currentSplitPanePos + 1 < (splitPaneStateCount = this.getSplitPaneStateCount());
        } else if (commandId == DefaultEditorManager.PREV_PANE_CMD_ID) {
            int currentSplitPanePos = this.getCurrentSplitPanePos();
            ret = currentSplitPanePos > 0;
        }
        return ret;
    }

    public boolean isRestorableAtStartup() {
        for (int i = 0; i < this.getSplitPaneStateCount(); ++i) {
            SplitPaneState splitPaneState = this.getSplitPaneState(i);
            boolean restorableAtStartup = splitPaneState.isRestorableAtStartup();
            if (restorableAtStartup) continue;
            return false;
        }
        return true;
    }

    boolean saveStateInfo(StructuredPropertyAccess parentNode) {
        boolean ret = false;
        Context context = this.getContext();
        EditorUtil.saveContext(context, parentNode);
        int nodeNumber = this.getNodeNumber();
        parentNode.setProperty("accelerator", Integer.toString(nodeNumber));
        int splitPaneStateCount = this.getSplitPaneStateCount();
        for (int splitPaneStatePos = 0; splitPaneStatePos < splitPaneStateCount; ++splitPaneStatePos) {
            DefaultStructuredPropertyAccess splitPaneStateNode;
            SplitPaneState splitPaneState = this.getSplitPaneState(splitPaneStatePos);
            if (!splitPaneState.saveStateInfo((StructuredPropertyAccess)(splitPaneStateNode = new DefaultStructuredPropertyAccess("paneState")))) continue;
            parentNode.appendChild((StructuredPropertyAccess)splitPaneStateNode);
            ret = true;
        }
        StructuredPropertyAccess structPersistence = this.getStructPersistence();
        if (structPersistence != null) {
            parentNode.appendChild(structPersistence);
        }
        return ret;
    }

    boolean loadStateInfo(StructuredPropertyAccess parentNode) {
        StructuredPropertyAccess paneNode;
        boolean ret = false;
        Context context = EditorUtil.loadContext(parentNode);
        if (context != null) {
            this.setContext(context);
            NbEditorManager editorManager = NbEditorManager.getInstance();
            Node node = context.getNode();
            List<EditorAddin> addins = editorManager._getAddins(context);
            this.setEditorAddins(addins);
            if (!addins.isEmpty()) {
                int accelerator;
                Iterator paneStates = parentNode.getChildNodes("paneState");
                while (paneStates.hasNext()) {
                    SplitPaneState splitPaneState = new SplitPaneState(this);
                    StructuredPropertyAccess paneState = (StructuredPropertyAccess)paneStates.next();
                    if (!splitPaneState.loadStateInfo(paneState)) continue;
                    this.addSplitPaneState(splitPaneState);
                    ret = true;
                }
                String acceleratorAttribute = parentNode.getProperty("accelerator", null);
                if (acceleratorAttribute != null && (accelerator = Integer.parseInt(acceleratorAttribute)) >= 0 && accelerator < 9) {
                    this.setNodeNumber(accelerator);
                }
            }
        }
        if ((paneNode = parentNode.getChildNode("pane")) != null) {
            this.setStructPersistence(paneNode);
        }
        return ret;
    }

    public List<SplitPaneState> getSplitPaneStates() {
        return Collections.unmodifiableList(this._splitPaneStates);
    }
}

