/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.NbEmptyFS;
import com.oracle.jdeveloper.nbwindowsystem.NbToolbar;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.ide.menu.spi.Item;
import javax.ide.menu.spi.Section;
import javax.ide.menu.spi.SectionContainer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToolbarGroup;
import oracle.ide.controls.ToolbarItem;
import org.openide.awt.Actions;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.util.Enumerations;
import org.openide.util.WeakSet;

public final class NbToolbarsFS
extends AbstractFileSystem
implements AbstractFileSystem.List,
AbstractFileSystem.Attr,
AbstractFileSystem.Info,
ContainerListener {
    static final Logger LOG = Logger.getLogger(NbToolbarsFS.class.getName());
    private NbToolbar bar;
    private SectionContainer model;
    private Date created = new Date();
    private static final Set<Action> actions = new WeakSet();
    private final Set<Action> uncategorized;

    public NbToolbarsFS() {
        this.list = NbEmptyFS.DEFAULT;
        this.attr = this;
        this.info = NbEmptyFS.DEFAULT;
        this.bar = null;
        this.uncategorized = new WeakSet();
    }

    public String getDisplayName() {
        return "";
    }

    public boolean isReadOnly() {
        return true;
    }

    public String[] children(String path) {
        if (path.equals("")) {
            return new String[]{"Toolbars", "Actions"};
        }
        if ("Toolbars".equals(path)) {
            return this.sectionNames();
        }
        if ("Actions".equals(path)) {
            return this.actionCategories();
        }
        if (path.startsWith("Actions/")) {
            String category = path.substring(8);
            return this.actionNames(category);
        }
        if (path.startsWith("Toolbars/")) {
            String id = path.substring(9);
            Section sect = this.find(id);
            if (sect == null) {
                return new String[0];
            }
            if ("Uncategorized".equals(id)) {
                return this.getUncategorizedItems().toArray(new String[0]);
            }
            ArrayList<String> res = new ArrayList<String>();
            List items = sect.getContent();
            int cnt = 0;
            for (Item item : items) {
                String cmdID = item.getActionID();
                if (item.getWeight() == null) {
                    item.setWeight(Float.valueOf(cnt += 1000));
                }
                if (this.getBar().find(cmdID) == null) continue;
                res.add(cmdID + ".instance");
            }
            return res.toArray(new String[0]);
        }
        return null;
    }

    private Collection<String> getUncategorizedItems() {
        HashSet<String> set = new HashSet<String>();
        for (Action a : this.uncategorizedActions()) {
            String cmdName = Ide.findCmdName((int)((IdeAction)a).getCommandId());
            set.add(cmdName + ".instance");
        }
        return set;
    }

    SectionContainer findModel() {
        return this.model;
    }

    private String[] sectionNames() {
        SectionContainer modelToolbar = this.findModel();
        if (modelToolbar == null) {
            return new String[0];
        }
        ArrayList<String> arr = new ArrayList<String>();
        int cnt = 0;
        for (Object o : modelToolbar.getSections()) {
            Section s = (Section)o;
            if (s.getWeight() == null) {
                s.setWeight(Float.valueOf(cnt += 1000));
            }
            if (this.children("Toolbars/" + s.getID()).length == 0) continue;
            arr.add(s.getID());
        }
        if (this.uncategorizedActions().length > 0) {
            arr.add("Uncategorized");
        }
        return arr.toArray(new String[0]);
    }

    private String[] actionCategories() {
        Object[] allKeys = Ide.getIdeActionMap().allKeys();
        HashSet<String> arr = new HashSet<String>();
        NbToolbarsFS.categories(arr, allKeys);
        return arr.toArray(new String[0]);
    }

    private static void categories(Collection<String> res, Object[] keys) {
        for (Object o : keys) {
            IdeAction ideAction;
            if (!(o instanceof Integer) || (ideAction = IdeAction.find((int)((Integer)o))) == null) continue;
            String category = (String)ideAction.getValue("Category");
            if (category != null && !category.isEmpty()) {
                res.add(StringUtils.stripMnemonic((String)category));
                continue;
            }
            res.add("Other");
        }
    }

    private String[] actionNames(String category) {
        Object[] allKeys = Ide.getIdeActionMap().allKeys();
        ArrayList<String> arr = new ArrayList<String>();
        NbToolbarsFS.feedMap(arr, allKeys, category);
        return arr.toArray(new String[0]);
    }

    private static void feedMap(Collection<String> res, Object[] keys, String category) {
        boolean other = "Other".equals(category);
        for (Object o : keys) {
            String cat;
            IdeAction action;
            String cmd;
            if (!(o instanceof Integer) || (cmd = Ide.findCmdName((int)((Integer)o))) == null || (action = IdeAction.find((int)((Integer)o))) == null || ((cat = (String)action.getValue("Category")) == null || !category.equals(StringUtils.stripMnemonic((String)cat))) && (!other || cat != null && !cat.isEmpty())) continue;
            res.add(cmd + ".instance");
        }
    }

    private Section find(String id) {
        SectionContainer modelToolbar = this.findModel();
        if (modelToolbar == null) {
            return null;
        }
        if ("Uncategorized".equals(id) && this.uncategorizedActions().length > 0) {
            float wt;
            Section section = new Section("Uncategorized");
            List sections = modelToolbar.getSections();
            if (sections.isEmpty()) {
                wt = 10000.0f;
            } else {
                Object o = sections.get(sections.size() - 1);
                wt = ((Section)o).getWeight().floatValue() + 1001.0f;
            }
            section.setWeight(Float.valueOf(wt));
            return section;
        }
        return modelToolbar.getSection(id);
    }

    private Component findCommand(String fullPath, Item[] res, Section[] sections) {
        String[] arr;
        if (!fullPath.startsWith("Toolbars/")) {
            return null;
        }
        if (fullPath.endsWith(".instance")) {
            fullPath = fullPath.substring(0, fullPath.length() - 9);
        }
        if ((arr = fullPath.split("/")).length == 2) {
            sections[0] = this.find(arr[1]);
        }
        if (arr.length != 3) {
            return null;
        }
        Section s = this.find(arr[1]);
        if (s == null) {
            return null;
        }
        Item pos = (Item)s.getItem(arr[2]);
        if (res != null) {
            if (pos == null && "Uncategorized".equals(s.getID())) {
                Item item;
                pos = item = new Item(arr[2]);
            }
            res[0] = pos;
        }
        if (pos == null) {
            return null;
        }
        return this.getBar().find(arr[2]);
    }

    public Object readAttribute(String path, String attr) {
        if (attr.equals("Toolbars\\QuickSearch\\nb.toolbar.overflow.disable")) {
            return Boolean.TRUE;
        }
        if (this.bar == null) {
            return null;
        }
        boolean position = attr.equals("position");
        boolean instanceClass = attr.equals("instanceClass");
        boolean instanceCreate = attr.equals("instanceCreate");
        boolean displayName = attr.equals("displayName");
        if (!(position || instanceCreate || instanceClass || displayName)) {
            return null;
        }
        if (path.startsWith("Actions/")) {
            String[] arr = path.split("/");
            if (arr.length != 3) {
                return null;
            }
            String id = arr[2].replace(".instance", "");
            Integer value = Ide.findCmdID((String)id);
            if (instanceCreate) {
                if (value == null) {
                    return null;
                }
                return Ide.getIdeActionMap().get(value);
            }
            if (instanceClass) {
                return IdeAction.class.getName();
            }
            if (position) {
                return value;
            }
            return null;
        }
        if (!path.startsWith("Toolbars/")) {
            return null;
        }
        Item[] arr = new Item[1];
        Section[] sec = new Section[1];
        Component action = this.findCommand(path, arr, sec);
        if (action == null) {
            if (sec[0] != null) {
                if (position) {
                    return sec[0].getWeight();
                }
                if (displayName) {
                    return sec[0].getDisplayName();
                }
            }
            return null;
        }
        if (instanceCreate) {
            Action a = null;
            if (action instanceof AbstractButton) {
                AbstractButton tb = (AbstractButton)action;
                a = tb.getAction();
            }
            if (a != null) {
                NbToolbarsFS.registerAction(a);
            } else if (action instanceof MenuToolButton) {
                MenuToolButton m = (MenuToolButton)action;
                for (Component c : m.getPopupMenu().getComponents()) {
                    if (!(c instanceof AbstractButton)) continue;
                    AbstractButton tb = (AbstractButton)c;
                    Action menuAction = tb.getAction();
                    NbToolbarsFS.registerAction(menuAction);
                }
            }
            return action;
        }
        if (instanceClass) {
            return Component.class.getName();
        }
        if (position) {
            return arr[0].getWeight();
        }
        return null;
    }

    public void writeAttribute(String string, String string1, Object o) throws IOException {
        throw new IOException();
    }

    public Enumeration<String> attributes(String string) {
        return Enumerations.empty();
    }

    public void renameAttributes(String string, String string1) {
    }

    public void deleteAttributes(String string) {
    }

    public Date lastModified(String string) {
        return this.created;
    }

    public boolean folder(String path) {
        return !path.endsWith(".instance");
    }

    public boolean readOnly(String string) {
        return true;
    }

    public String mimeType(String string) {
        return null;
    }

    public long size(String string) {
        return 0L;
    }

    public InputStream inputStream(String string) throws FileNotFoundException {
        throw new FileNotFoundException();
    }

    public OutputStream outputStream(String string) throws IOException {
        throw new IOException();
    }

    public void lock(String string) throws IOException {
        throw new IOException();
    }

    public void unlock(String string) {
    }

    public void markUnimportant(String string) {
    }

    NbToolbar getBar() {
        return this.bar;
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.handleUncategorizedActionAddRemove(e, true);
        this.refresh(true);
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.handleUncategorizedActionAddRemove(e, false);
        this.refresh(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUncategorizedActionAddRemove(ContainerEvent e, boolean add) {
        Component comp;
        if (e != null && (comp = e.getChild()) instanceof JComponent && !Boolean.TRUE.equals(((JComponent)comp).getClientProperty("declarative-button"))) {
            Action a = null;
            if (comp instanceof AbstractButton) {
                a = ((AbstractButton)comp).getAction();
            } else if (comp instanceof ToolbarGroup) {
                Action[] actions = ((ToolbarGroup)comp).getActions();
                if (actions.length > 0) {
                    a = actions[0];
                }
            } else if (comp instanceof ToolbarItem) {
                a = ((ToolbarItem)comp).getAction();
            }
            if (a != null) {
                if (add) {
                    this.maybeAddUncategorized(a);
                } else {
                    Set<Action> set = this.uncategorized;
                    synchronized (set) {
                        this.uncategorized.remove(a);
                    }
                }
            }
        }
    }

    void assignNbToolbar(NbToolbar nbt) {
        if (this.bar != null) {
            LOG.info("NbToolbar created more than once");
        } else {
            this.bar = nbt;
        }
        this.info = this;
        this.list = this;
        this.bar.addContainerListener(this);
        this.refresh(true);
    }

    void assignModel(SectionContainer model) {
        if (this.model == null) {
            this.model = model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerAction(Action a) {
        Set<Action> set = actions;
        synchronized (set) {
            actions.add(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action[] allActions() {
        Set<Action> set = actions;
        synchronized (set) {
            return actions.toArray(new Action[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerUncategorized(Action a) {
        Set<Action> set = this.uncategorized;
        synchronized (set) {
            this.uncategorized.add(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Action[] uncategorizedActions() {
        Set<Action> set = this.uncategorized;
        synchronized (set) {
            return this.uncategorized.toArray(new Action[0]);
        }
    }

    private void maybeAddUncategorized(Action action) {
        if (!(action instanceof IdeAction)) {
            return;
        }
        SectionContainer toolbarModel = this.findModel();
        if (toolbarModel != null) {
            List sections = toolbarModel.getSections();
            if (sections.isEmpty()) {
                return;
            }
            boolean match = false;
            String cmdName = Ide.findCmdName((int)((IdeAction)action).getCommandId());
            block0: for (Object o : sections) {
                Section s = (Section)o;
                List items = s.getContent();
                for (Item item : items) {
                    if (!cmdName.equals(item.getActionID())) continue;
                    match = true;
                    continue block0;
                }
            }
            if (!match) {
                this.registerUncategorized(action);
            }
        }
    }

    public static final class BAC
    implements Actions.ButtonActionConnector {
        public boolean connect(AbstractButton ab, Action action) {
            NbToolbarsFS.registerAction(action);
            if (action instanceof IdeAction) {
                ((IdeAction)action).updateAction();
            }
            return false;
        }

        public boolean connect(JMenuItem jmi, Action action, boolean bln) {
            return false;
        }
    }
}

