/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import com.oracle.jdeveloper.nbwindowsystem.NbToolbarsFS;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.javatools.ui.search.SearchField;

final class NbToolbar
extends Toolbar {
    private final List<Component> arr = new ArrayList<Component>();
    private final NbToolbarsFS fs;
    private Map<String, Component> map;

    NbToolbar(NbToolbarsFS fs) {
        this.fs = fs;
        this.fs.assignNbToolbar(this);
        this.putClientProperty("updateToolbar", Boolean.FALSE);
    }

    public boolean isShowing() {
        return true;
    }

    public Action[] getActions() {
        return this.fs.allActions();
    }

    private List<Component> getComponentsImpl() {
        assert (Thread.holdsLock((Object)this));
        return this.arr;
    }

    public synchronized Component find(String cmdId) {
        if (this.map == null) {
            HashMap<String, Component> tmp = new HashMap<String, Component>();
            for (Component c : this.getComponentsImpl()) {
                Component res;
                Action a;
                if (c instanceof JSeparator || c instanceof Box.Filler) continue;
                JComponent jc = (JComponent)c;
                String id = (String)jc.getClientProperty("cmdId");
                if (jc instanceof SearchField) {
                    id = jc.getClass().getSimpleName() + jc.hashCode();
                }
                if (id == null && jc instanceof AbstractButton && (a = ((AbstractButton)jc).getAction()) instanceof IdeAction) {
                    int commandId = ((IdeAction)a).getCommandId();
                    id = Ide.findCmdName((int)commandId);
                }
                if (id == null) {
                    NbToolbarsFS.LOG.log(Level.WARNING, "no cmdId for {0}", jc);
                }
                if ((res = tmp.put(id, jc)) == null) continue;
                NbToolbarsFS.LOG.log(Level.SEVERE, "A component with this id ({0}) has already been added; the current component will replace it.\nPrevious component: {1}.\nCurrent component: {2}", new Object[]{id, res, jc});
            }
            this.map = tmp;
        }
        return this.map.get(cmdId);
    }

    public void updateUI() {
    }

    public synchronized Component[] getComponents() {
        return this.getComponentsImpl().toArray(new Component[0]);
    }

    public synchronized int getComponentCount() {
        return this.getComponentsImpl().size();
    }

    public synchronized Component getComponent(int index) {
        if (index >= 0 && index < this.getComponentsImpl().size()) {
            return this.getComponentsImpl().get(index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl2(Component comp, Object constraints, int index) {
        NbToolbar nbToolbar = this;
        synchronized (nbToolbar) {
            if (this.getComponentsImpl().contains(comp) || this.containsComponentWithCmdId(comp)) {
                return;
            }
            if (index == -1) {
                this.getComponentsImpl().add(comp);
            } else {
                this.getComponentsImpl().add(index, comp);
            }
            this.map = null;
        }
        this.fs.componentAdded(new ContainerEvent((Component)((Object)this), 300, comp));
    }

    private boolean containsComponentWithCmdId(Component component) {
        String compId;
        if (component instanceof JComponent && (compId = (String)((JComponent)component).getClientProperty("cmdId")) != null) {
            for (Component c : this.getComponentsImpl()) {
                if (!(c instanceof JComponent) || !compId.equals(((JComponent)c).getClientProperty("cmdId"))) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Component comp) {
        NbToolbar nbToolbar = this;
        synchronized (nbToolbar) {
            this.getComponentsImpl().remove(comp);
            this.map = null;
        }
        this.fs.componentRemoved(new ContainerEvent((Component)((Object)this), 301, comp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int index) {
        NbToolbar nbToolbar = this;
        synchronized (nbToolbar) {
            this.getComponentsImpl().remove(index);
            this.map = null;
        }
        this.fs.componentRemoved(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        NbToolbar nbToolbar = this;
        synchronized (nbToolbar) {
            this.getComponentsImpl().clear();
            this.map = null;
        }
        this.fs.componentRemoved(null);
    }
}

