/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jdeveloper.nbwindowsystem;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;
import org.netbeans.core.windows.services.PresenterDecorator;
import org.openide.util.HelpCtx;

public class JDevPresenter
extends PresenterDecorator {
    private static final String DEFAULT_OPTION_PANE = "nb.default.option.pane";

    public void customizePresenter(JDialog jd) {
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        InputMap inputMap = jd.getRootPane().getInputMap(2);
        HelpCtx helpCtx = JDevPresenter.findHelp(jd);
        this.loadMyMap(inputMap, jd.getRootPane().getActionMap(), kso, helpCtx);
        Dimension size = jd.getSize();
        jd.setMinimumSize(size);
        Object prop = jd.getRootPane().getClientProperty(DEFAULT_OPTION_PANE);
        if (Boolean.TRUE.equals(prop)) {
            jd.setResizable(false);
        }
        jd.setLocationRelativeTo((Component)Ide.getMainWindow());
    }

    private void loadMyMap(InputMap myMap, ActionMap aMap, KeyStrokeOptions kso, HelpCtx helpCtx) {
        if (helpCtx == HelpCtx.DEFAULT_HELP) {
            return;
        }
        IdeAction contextHelpAction = IdeAction.find((String)"ContextHelp");
        if (contextHelpAction != null) {
            this.updateMyMapWithAction(kso, aMap, myMap, contextHelpAction.getCommandId(), contextHelpAction);
            contextHelpAction.setEnabled(true);
        }
    }

    private void updateMyMapWithAction(KeyStrokeOptions kso, ActionMap aMap, InputMap myMap, int cmdId, IdeAction action) {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/jdevimpl/help/accelerators.xml");
        List kList = this.getKeyStrokesFor(kso, cmdId, ksc);
        if (kList != Collections.EMPTY_LIST) {
            int numKeys = kList.size();
            Integer integer = cmdId;
            for (int i = 0; i < numKeys; ++i) {
                aMap.put(integer, (Action)action);
                for (Object ks : ((KeyStrokes)kList.get(i)).getData()) {
                    myMap.put((KeyStroke)ks, integer);
                }
            }
        }
    }

    private List getKeyStrokesFor(KeyStrokeOptions kso, int cmdId, KeyStrokeContext ksc) {
        KeyStrokeMap ksm = kso.getGlobalKeyMap();
        List kList = ksm.getKeyStrokesFor(cmdId);
        if (kList == Collections.EMPTY_LIST) {
            ksm = kso.getLocalKeyMap(ksc);
            kList = ksm.getKeyStrokesFor(cmdId);
        }
        return kList;
    }

    private static HelpCtx findHelp(JDialog dlg) {
        HelpCtx res = HelpCtx.findHelp((Component)dlg.getRootPane());
        if (res == HelpCtx.DEFAULT_HELP) {
            for (Component c : dlg.getContentPane().getComponents()) {
                if (null != c && (res = HelpCtx.findHelp((Component)c)) != HelpCtx.DEFAULT_HELP) break;
            }
        }
        return res;
    }
}

