/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.plsql;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.plsql.PLSQLBlockRenderer;
import oracle.javatools.editor.language.plsql.PLSQLLanguageSupport;
import oracle.javatools.editor.language.plsql.PLSQLStyles;
import oracle.javatools.resource.BundleHelper;

public final class PLSQLLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"plsql", "pls", "sql"};

    @Override
    public String getPresentationName() {
        BundleHelper resources = EditorProperties.getEditorBundle();
        return resources.getString("PLSQL_MODULE_NAME");
    }

    @Override
    public String[] getStyleNames() {
        return PLSQLStyles.STYLE_NAMES;
    }

    @Override
    public String getContentSample() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("-- Create the department table first\n");
        buffer.append("DROP TABLE dept;\n");
        buffer.append("\n");
        buffer.append("CREATE TABLE dept ( deptno NUMBER (2),\n");
        buffer.append("                    dname VARCHAR2(10),\n");
        buffer.append("                    loc VARCHAR2(9) );\n");
        buffer.append("\n");
        buffer.append("-- Insert some default values\n");
        buffer.append("INSERT INTO dept VALUES ");
        buffer.append("( 10, 'SALES', 'Boston' );\n");
        buffer.append("INSERT INTO dept VALUES ");
        buffer.append("( 20, 'EDUCATION', 'San Francisco' );\n");
        buffer.append("INSERT INTO dept VALUES ");
        buffer.append("( 30, 'CONSULTING', 'Seattle' );\n");
        buffer.append("INSERT INTO dept VALUES ");
        buffer.append("( 40, 'FINANCE', 'New York' );\n");
        buffer.append("INSERT INTO dept VALUES ");
        buffer.append("( 50, 'PERSONNEL', 'Chicago' );\n");
        buffer.append("INSERT INTO dept VALUES ");
        buffer.append("( 60, 'DEVELOPMENT', 'Seattle' );\n");
        return buffer.toString();
    }

    @Override
    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    @Override
    public void registerStyles(StyleRegistry registry) {
        new PLSQLStyles(registry);
    }

    @Override
    public LanguageSupport createLanguageSupport() {
        return new PLSQLLanguageSupport();
    }

    @Override
    public BlockRenderer createBlockRenderer(TextBuffer buffer) {
        return new PLSQLBlockRenderer(buffer);
    }
}

