/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.java;

import oracle.javatools.editor.language.java.CodingStyleOptions;

public abstract class CodingStyleProvider {
    private static CodingStyleProvider INSTANCE;
    public static final CodingStyleProvider DEFAULT_PROVIDER;

    protected CodingStyleProvider() {
    }

    protected static void setCodingStyleProvider(CodingStyleProvider provider) {
        INSTANCE = provider;
    }

    public static CodingStyleProvider getCodingStyleProvider() {
        return INSTANCE;
    }

    public abstract CodingStyleOptions getCodingStyleOptions();

    static {
        DEFAULT_PROVIDER = new CodingStyleProvider(){

            @Override
            public CodingStyleOptions getCodingStyleOptions() {
                return new CodingStyleOptions(){

                    @Override
                    public int getIndentSize() {
                        return 8;
                    }

                    @Override
                    public boolean getIndentClassMembers() {
                        return true;
                    }

                    @Override
                    public boolean getIndentControlBlocks() {
                        return true;
                    }

                    @Override
                    public boolean getIndentBlockChildren() {
                        return true;
                    }

                    @Override
                    public boolean getIndentSwitchCases() {
                        return true;
                    }

                    @Override
                    public boolean getWrapAlign() {
                        return true;
                    }
                };
            }
        };
    }
}

