/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.cpp;

import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.resource.BundleHelper;

public final class CppStyles {
    public static final String CPP_COMMENT_STYLE = "c++-comment-style";
    public static final String CPP_KEYWORD_STYLE = "c++-keyword-style";
    public static final String CPP_IDENTIFIER_STYLE = "c++-identifier-style";
    public static final String CPP_STRING_STYLE = "c++-string-style";
    public static final String CPP_NUMBER_STYLE = "c++-number-style";
    public static final String CPP_BRACE_STYLE = "c++-brace-style";
    public static final String CPP_OPERATOR_STYLE = "c++-operator-style";
    public static final String[] STYLE_NAMES = new String[]{"c++-comment-style", "c++-keyword-style", "c++-identifier-style", "c++-string-style", "c++-number-style", "c++-brace-style", "c++-operator-style"};
    public static BaseStyle cppPlainStyle;
    public static BaseStyle cppCommentStyle;
    public static BaseStyle cppKeywordStyle;
    public static BaseStyle cppIdentifierStyle;
    public static BaseStyle cppStringStyle;
    public static BaseStyle cppNumberStyle;
    public static BaseStyle cppBraceStyle;
    public static BaseStyle cppOperatorStyle;

    public CppStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        String name;
        BundleHelper resources = EditorProperties.getEditorBundle();
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        cppPlainStyle = builtInStyles.plainStyle;
        cppCommentStyle = styleRegistry.lookupStyle(CPP_COMMENT_STYLE);
        if (cppCommentStyle == null) {
            name = resources.getString("CPP_COMMENT_STYLE");
            cppCommentStyle = styleRegistry.createStyle(CPP_COMMENT_STYLE, name, "base-comment-style");
        }
        if ((cppStringStyle = styleRegistry.lookupStyle(CPP_STRING_STYLE)) == null) {
            name = resources.getString("CPP_STRING_STYLE");
            cppStringStyle = styleRegistry.createStyle(CPP_STRING_STYLE, name, "base-string-style");
        }
        if ((cppKeywordStyle = styleRegistry.lookupStyle(CPP_KEYWORD_STYLE)) == null) {
            name = resources.getString("CPP_KEYWORD_STYLE");
            cppKeywordStyle = styleRegistry.createStyle(CPP_KEYWORD_STYLE, name, "base-keyword-style");
        }
        if ((cppIdentifierStyle = styleRegistry.lookupStyle(CPP_IDENTIFIER_STYLE)) == null) {
            name = resources.getString("CPP_IDENTIFIER_STYLE");
            cppIdentifierStyle = styleRegistry.createStyle(CPP_IDENTIFIER_STYLE, name, "base-identifier-style");
        }
        if ((cppNumberStyle = styleRegistry.lookupStyle(CPP_NUMBER_STYLE)) == null) {
            name = resources.getString("CPP_NUMBER_STYLE");
            cppNumberStyle = styleRegistry.createStyle(CPP_NUMBER_STYLE, name, "base-number-style");
        }
        if ((cppBraceStyle = styleRegistry.lookupStyle(CPP_BRACE_STYLE)) == null) {
            name = resources.getString("CPP_BRACE_STYLE");
            cppBraceStyle = styleRegistry.createStyle(CPP_BRACE_STYLE, name, "base-brace-style");
        }
        if ((cppOperatorStyle = styleRegistry.lookupStyle(CPP_OPERATOR_STYLE)) == null) {
            name = resources.getString("CPP_OPERATOR_STYLE");
            cppOperatorStyle = styleRegistry.createStyle(CPP_OPERATOR_STYLE, name, "base-operator-style");
        }
    }
}

