/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionPreInvoker;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.TextRange;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.resource.EditorBundle;

public final class TextTabber {
    private TextRange totalValidRange;
    private SortedSet<TabTextRange> ranges = new TreeSet<TabTextRange>();
    private TextBuffer buffer;
    private BasicEditorPane editor;
    private CaretL caretL = new CaretL();
    private KeyPressActionHookInvoker actionHookInvoker = new KeyPressActionHookInvoker();
    private boolean disposed = false;
    private HighlightLayer highlightLayer;
    private static HighlightStyle highlightStyle;
    private DocumentL documentL = new DocumentL();
    private TextRange currentRange;
    private boolean consumeEnter = false;
    private static final int MIN_VALID_RANGE_SIZE = 1;
    private InvalidRangeAction invalidRangeAction = InvalidRangeAction.REMOVE_RANGES;
    private static final String HIGHLIGHT_STYLE_NAME = "tab-field";
    private transient ArrayList propertyChangeListeners = new ArrayList(2);
    public static final String PROPERTY_ACTIVE = "PROPERTY_ACTIVE";
    public static final String PROPERTY_SELECT = "PROPERTY_SELECT";
    public static final String PROPERTY_RANGE_CHANGE = "PROPERTY_RANGE_CHANGE";
    public static final String PROPERTY_RANGE_CHANGE_PENDING = "PROPERTY_RANGE_CHANGE_PENDING";

    public TextTabber(BasicEditorPane editor) {
        this.editor = editor;
        this.buffer = ((BasicDocument)editor.getDocument()).getTextBuffer();
    }

    public void setEnterIsSelect(boolean enterIsSelect) {
        this.consumeEnter = enterIsSelect;
    }

    public boolean getEnterIsSelect() {
        return this.consumeEnter;
    }

    public TabTextRange addRange(int startOffset, int endOffset) {
        TabTextRange textRange = new TabTextRange(null, this.buffer, startOffset, endOffset);
        this.ranges.add(textRange);
        return textRange;
    }

    public TabTextRange addRange(Object key, int startOffset, int endOffset) {
        TabTextRange textRange = new TabTextRange(key, this.buffer, startOffset, endOffset);
        this.ranges.add(textRange);
        return textRange;
    }

    public void removeRange(TabTextRange textRange) {
        this.ranges.remove(textRange);
        textRange.dispose();
    }

    public void setValidRange(int startValidOffset, int endValidOffset) {
        if (this.totalValidRange != null) {
            this.totalValidRange.dispose();
        }
        this.totalValidRange = new TextRange(this.buffer, startValidOffset, endValidOffset);
    }

    public void setActive(boolean isActive) {
        if (isActive) {
            this.start();
        } else {
            this.stop();
        }
    }

    public Collection<TabTextRange> getTextRanges() {
        return Collections.unmodifiableCollection(this.ranges);
    }

    private void start() {
        if (this.disposed) {
            throw new IllegalStateException("Attempt to reactivate a disposed TextTabber");
        }
        if (this.ranges.size() < 1) {
            throw new IllegalStateException("Not enough ranges to activate TextTabber");
        }
        if (this.totalValidRange == null) {
            int startValidRange = this.editor.getDocument().getLength();
            int endValidRange = -1;
            for (TextRange textRange : this.ranges) {
                startValidRange = Math.min(startValidRange, textRange.getStartOffset());
                endValidRange = Math.max(endValidRange, textRange.getEndOffset());
            }
            this.totalValidRange = new TextRange(this.buffer, startValidRange, endValidRange);
        }
        this.selectRange(this.ranges.first());
        this.editor.addCaretListener(this.caretL);
        this.editor.getDocument().addDocumentListener(this.documentL);
        this.updateHighlights();
        this.editor.addPreActionInvoker(this.actionHookInvoker, 1.0);
        this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_ACTIVE, Boolean.FALSE, Boolean.TRUE));
    }

    private void stop() {
        this.dispose();
        this.editor.removeCaretListener(this.caretL);
        this.editor.getDocument().removeDocumentListener(this.documentL);
        this.removeHighlights();
        this.editor.removePreActionInvoker(this.actionHookInvoker, 1.0);
        this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_ACTIVE, Boolean.TRUE, Boolean.FALSE));
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.totalValidRange.dispose();
        for (TextRange textRange : this.ranges) {
            textRange.dispose();
        }
        this.ranges.clear();
        this.currentRange = null;
    }

    public void setInvalidRangeAction(InvalidRangeAction invalidRangeAction) {
        this.invalidRangeAction = invalidRangeAction;
    }

    public InvalidRangeAction getInvalidRangeAction() {
        return this.invalidRangeAction;
    }

    public void selectRange(TabTextRange range) {
        if (range == null) {
            throw new IllegalArgumentException("Range cannot be null");
        }
        if (!this.ranges.contains(range)) {
            throw new IllegalArgumentException("Range is not valid for this TextTabber");
        }
        TextRange lastRange = this.currentRange;
        this.currentRange = range;
        this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_RANGE_CHANGE_PENDING, lastRange, this.currentRange));
        this.editor.setCaretPosition(this.currentRange.getEndOffset());
        this.editor.moveCaretPosition(this.currentRange.getStartOffset());
        this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_RANGE_CHANGE, lastRange, this.currentRange));
    }

    private void nextRange() {
        int pos = Math.min(this.editor.getSelectionStart(), this.editor.getSelectionEnd());
        TabTextRange nextRange = null;
        for (TabTextRange range : this.ranges) {
            if (range.getStartOffset() <= pos) continue;
            nextRange = range;
            break;
        }
        if (nextRange == null) {
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_RANGE_CHANGE_PENDING, null, null));
            this.editor.setCaretPosition(this.totalValidRange.getEndOffset() + 1);
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_RANGE_CHANGE, null, null));
            this.setActive(false);
            return;
        }
        this.selectRange(nextRange);
    }

    private void previousRange() {
        TabTextRange range;
        int pos = Math.max(this.editor.getSelectionStart(), this.editor.getSelectionEnd());
        TabTextRange nextRange = null;
        Iterator iterator = this.ranges.iterator();
        while (iterator.hasNext() && (range = (TabTextRange)iterator.next()).getEndOffset() < pos) {
            nextRange = range;
        }
        if (nextRange == null) {
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_RANGE_CHANGE_PENDING, null, null));
            this.editor.setCaretPosition(this.totalValidRange.getStartOffset());
            this.firePropertyChange(new PropertyChangeEvent(this, PROPERTY_RANGE_CHANGE, null, null));
            this.setActive(false);
            return;
        }
        this.selectRange(nextRange);
    }

    private void updateHighlights() {
        if (this.disposed) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextTabber.this.updateHighlights();
                }
            });
            return;
        }
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        } else {
            this.highlightLayer.removeAllHighlights();
        }
        for (TabTextRange textRange : this.ranges) {
            this.highlightLayer.addHighlight(highlightStyle, textRange.getStartOffset(), false, textRange.getEndOffset(), true);
        }
    }

    private void removeHighlights() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TextTabber.this.removeHighlights();
                }
            });
            return;
        }
        this.highlightLayer.removeAllHighlights();
        this.editor.destroyHighlightLayer(this.highlightLayer);
    }

    private void documentChanged() {
        TreeSet<TabTextRange> newRanges = new TreeSet<TabTextRange>();
        TabTextRange lastRange = null;
        boolean invalid = false;
        for (TabTextRange textRange : this.ranges) {
            if (lastRange == null) {
                lastRange = textRange;
                continue;
            }
            if (textRange.getStartOffset() <= lastRange.getEndOffset()) {
                invalid = true;
                textRange.dispose();
                lastRange.dispose();
                lastRange = null;
                continue;
            }
            newRanges.add(lastRange);
            lastRange = textRange;
        }
        if (lastRange != null) {
            newRanges.add(lastRange);
        }
        this.ranges = newRanges;
        if (invalid && this.invalidRangeAction == InvalidRangeAction.STOP) {
            this.setActive(false);
            return;
        }
        if (this.ranges.size() < 1) {
            this.setActive(false);
            return;
        }
        this.updateHighlights();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new ArrayList(2);
        }
        this.propertyChangeListeners.add(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListeners != null) {
            this.propertyChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        List list;
        TextTabber textTabber = this;
        synchronized (textTabber) {
            if (this.propertyChangeListeners == null) {
                return;
            }
            list = (List)this.propertyChangeListeners.clone();
        }
        for (PropertyChangeListener listener : list) {
            listener.propertyChange(propertyChangeEvent);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.totalValidRange);
        for (TextRange textRange : this.ranges) {
            sb.append("\n\t");
            sb.append(textRange);
        }
        return sb.toString();
    }

    static {
        EditorProperties properties = EditorProperties.getProperties();
        HighlightRegistry registry = properties.getHighlightRegistry();
        highlightStyle = registry.lookupStyle(HIGHLIGHT_STYLE_NAME);
        if (highlightStyle == null) {
            String name = EditorBundle.get((String)"TAB_FIELD_HIGHLIGHT");
            highlightStyle = registry.createStyle(HIGHLIGHT_STYLE_NAME, name, true, 75, null, new Color(-1579033));
        }
    }

    private class CaretL
    implements CaretListener {
        private CaretL() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (!TextTabber.this.totalValidRange.contains(e.getDot())) {
                TextTabber.this.setActive(false);
            }
            if (TextTabber.this.currentRange != null && !TextTabber.this.currentRange.contains(e.getDot())) {
                for (TextRange textRange : TextTabber.this.ranges) {
                    if (!textRange.contains(e.getDot())) continue;
                    TextRange lastRange = TextTabber.this.currentRange;
                    TextTabber.this.currentRange = textRange;
                    TextTabber.this.firePropertyChange(new PropertyChangeEvent(this, TextTabber.PROPERTY_RANGE_CHANGE, lastRange, TextTabber.this.currentRange));
                    break;
                }
            }
        }
    }

    private class KeyPressActionHookInvoker
    implements ActionPreInvoker {
        private KeyPressActionHookInvoker() {
        }

        @Override
        public boolean invokeAction(String actionKey) {
            if (actionKey.equals("insert-tab") || actionKey.equals("caret-forward")) {
                TextTabber.this.nextRange();
            } else if (actionKey.equals("reverse-tab") || actionKey.equals("caret-backward")) {
                TextTabber.this.previousRange();
            } else if (actionKey.equals("cancel")) {
                TextTabber.this.setActive(false);
            } else if (TextTabber.this.consumeEnter && actionKey.equals("insert-break") && TextTabber.this.currentRange != null) {
                PropertyChangeEvent pce = new PropertyChangeEvent(this, TextTabber.PROPERTY_SELECT, null, TextTabber.this.currentRange);
                TextTabber.this.firePropertyChange(pce);
            } else {
                return false;
            }
            return true;
        }
    }

    private class DocumentL
    implements DocumentListener {
        private DocumentL() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TextTabber.this.documentChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TextTabber.this.documentChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TextTabber.this.documentChanged();
        }
    }

    public static enum InvalidRangeAction {
        STOP,
        REMOVE_RANGES;

    }

    public class TabTextRange
    extends TextRange {
        private Object key;

        private TabTextRange(Object key, TextBuffer buffer, int startOffset, int endOffset) {
            super(buffer, startOffset, endOffset);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }
}

