/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import oracle.javatools.editor.EditorProperties;

public final class EditDescriptor {
    private String editName;
    private String mergePropertyName;
    private int editId;
    private static int nextId = 101;

    public EditDescriptor(String editName) {
        this(editName, null);
    }

    EditDescriptor(String editName, String mergePropertyName) {
        this.editName = editName;
        this.mergePropertyName = mergePropertyName;
        this.editId = EditDescriptor.nextEditId();
    }

    public String getEditName() {
        if (this.editName == null) {
            return "";
        }
        return this.editName;
    }

    public boolean canMergeWith(EditDescriptor otherEdit) {
        if (this.mergePropertyName == null) {
            return false;
        }
        EditorProperties properties = EditorProperties.getProperties();
        Object value = properties.getProperty(this.mergePropertyName);
        if (value == null || value.equals(Boolean.FALSE)) {
            return false;
        }
        int otherId = otherEdit.editId;
        return otherId == this.editId;
    }

    private static synchronized int nextEditId() {
        return nextId++;
    }
}

