/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.editor.BasicEditorOverviewMark;
import oracle.javatools.editor.BasicEditorOverviewTipProvider;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.MultiSelectionEvent;
import oracle.javatools.editor.MultiSelectionListener;
import oracle.javatools.editor.Selection;
import oracle.javatools.editor.folding.CodeExpansionEvent;
import oracle.javatools.editor.folding.CodeExpansionListener;
import oracle.javatools.editor.folding.CodeFoldingMargin;
import oracle.javatools.editor.folding.CodeFoldingModel;
import oracle.javatools.editor.folding.CodeFoldingModelEvent;
import oracle.javatools.editor.folding.CodeFoldingModelListener;
import oracle.javatools.ui.overview.Overview;
import oracle.javatools.ui.overview.OverviewMark;
import oracle.javatools.ui.overview.OverviewMarkRenderingHints;
import oracle.javatools.util.Disposable;

public final class BasicEditorOverview
extends Overview<Integer, BasicEditorOverviewMark>
implements Disposable {
    private BasicEditorPane editor;
    private DocumentL documentL = new DocumentL();
    private PropertyChangeL propertyChangeL = new PropertyChangeL();
    private CodeExpansionL foldingL = new CodeExpansionL();
    private CaretL caretL = null;
    private boolean showEditMark = false;
    private int editOffset = -1;
    private Set<BasicEditorOverviewMark> autoRemoveMarks = new HashSet<BasicEditorOverviewMark>();
    private List<BasicEditorOverviewMark> caretMarks = new ArrayList<BasicEditorOverviewMark>();
    private BasicEditorOverviewMark editMark;
    private Timer timer = new Timer(200, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicEditorOverview.this.sizeChange();
            BasicEditorOverview.this.autoRemove();
            if (BasicEditorOverview.this.editMark != null) {
                BasicEditorOverview.this.removeMark(BasicEditorOverview.this.editMark);
                BasicEditorOverview.this.editMark = null;
            }
            if (BasicEditorOverview.this.showEditMark && BasicEditorOverview.this.editOffset >= 0) {
                BasicEditorOverview.this.editOffset = Math.min(BasicEditorOverview.this.editOffset, BasicEditorOverview.this.editor.getDocument().getLength() - 1);
                BasicEditorOverview.this.editMark = new BasicEditorOverviewMark(BasicEditorOverview.this.editor, BasicEditorOverview.this.editOffset, BasicEditorOverview.this.editOffset, 99.0f, new Color(100, 100, 100));
                BasicEditorOverview.this.editMark.putValue(OverviewMarkRenderingHints.Hint.DOTTED_LINE, Boolean.TRUE);
                BasicEditorOverview.this.addMark(BasicEditorOverview.this.editMark);
            }
        }
    });

    public BasicEditorOverview(BasicEditorPane editor) {
        this(editor, true);
    }

    public BasicEditorOverview(BasicEditorPane editor, boolean isDefaultOverviewForEditor) {
        super((Number)0, (Number)(editor.getRowForLine(editor.getLineCount()) - 1));
        this.timer.setRepeats(false);
        this.editor = editor;
        this.setInfoTipProvider(new BasicEditorOverviewTipProvider(editor));
        if (isDefaultOverviewForEditor) {
            editor.putProperty("overview", (Object)this);
        }
        editor.getDocument().addDocumentListener(this.documentL);
        editor.addPropertyChangeListener("code-folding-margin", this.propertyChangeL);
        editor.addPropertyChangeListener("document", this.propertyChangeL);
    }

    public void dispose() {
        this.timer.stop();
        if (this.caretL != null) {
            this.caretL.caretTimer.stop();
        }
        this.editor.getDocument().removeDocumentListener(this.documentL);
        this.editor.removePropertyChangeListener("code-folding-margin", this.propertyChangeL);
        this.editor.removePropertyChangeListener("document", this.propertyChangeL);
        this.editor.removeCaretListener(this.caretL);
        if (this.foldingL.model != null) {
            this.foldingL.model.removeCodeFoldingModelListener(this.foldingL);
        }
        if (this.foldingL.margin != null) {
            this.foldingL.margin.removeCodeExpansionListener(this.foldingL);
        }
        this.foldingL.model = null;
        this.foldingL.margin = null;
        for (BasicEditorOverviewMark mark : this.getMarks()) {
            mark.dispose();
        }
    }

    private void sizeChange() {
        try {
            int line = this.editor.getLineCount();
            int row = this.editor.getRowForLine(line);
            this.setEnd(row - 1);
        }
        catch (ExpiredTextBufferException expiredTextBufferException) {
            // empty catch block
        }
    }

    private void autoRemove() {
        ArrayList<BasicEditorOverviewMark> removeMarks = null;
        for (BasicEditorOverviewMark mark : this.autoRemoveMarks) {
            if (mark.getStartOffset() != mark.getEndOffset()) continue;
            if (removeMarks == null) {
                removeMarks = new ArrayList<BasicEditorOverviewMark>();
            }
            removeMarks.add(mark);
        }
        if (removeMarks != null) {
            for (BasicEditorOverviewMark mark : removeMarks) {
                this.removeMark(mark);
            }
        }
    }

    public void rebuild() {
        this.sizeChange();
        super.rebuild();
    }

    private void update() {
        this.timer.restart();
    }

    public void setShowEditMark(boolean showEditMark) {
        this.showEditMark = showEditMark;
        if (!showEditMark && this.editMark != null) {
            this.removeMark(this.editMark);
            this.editMark = null;
        }
    }

    public boolean isShowEditMark() {
        return this.showEditMark;
    }

    public void setShowCaretMark(boolean showCaretMark) {
        if (showCaretMark) {
            if (this.caretL == null) {
                this.caretL = new CaretL();
                this.editor.addCaretListener(this.caretL);
                this.editor.addMultiSelectionListener(this.caretL);
                this.updateCaret();
            }
        } else if (this.caretL != null) {
            this.editor.removeCaretListener(this.caretL);
            this.editor.removeMultiSelectionListener(this.caretL);
            this.caretL = null;
        }
    }

    public boolean isShowCaretMark() {
        return this.caretL != null;
    }

    private void updateCaret() {
        if (this.editor == null) {
            return;
        }
        for (BasicEditorOverviewMark mark : this.caretMarks) {
            this.removeMark(mark);
        }
        int location = this.editor.getCaretPosition();
        if (location >= 0) {
            BasicEditorOverviewMark mark;
            mark = new BasicEditorOverviewMark(this.editor, location, location, 100.0f, new Color(153, 153, 153));
            mark.putValue(OverviewMarkRenderingHints.Hint.LINE, Boolean.TRUE);
            this.addMark(mark);
            this.caretMarks.add(mark);
        }
        for (Selection sel : this.editor.getMultiSelections()) {
            location = sel.getDot();
            if (location < 0) continue;
            BasicEditorOverviewMark mark = new BasicEditorOverviewMark(this.editor, location, location, 100.0f, new Color(153, 153, 153));
            mark.putValue(OverviewMarkRenderingHints.Hint.LINE, Boolean.TRUE);
            this.addMark(mark);
            this.caretMarks.add(mark);
        }
    }

    public Collection<BasicEditorOverviewMark> removeMarks(Object group) {
        Collection marks = super.removeMarks(group);
        for (BasicEditorOverviewMark mark : marks) {
            mark.dispose();
        }
        return marks;
    }

    public void removeMark(BasicEditorOverviewMark overviewMark) {
        super.removeMark((OverviewMark)overviewMark);
        overviewMark.dispose();
        this.autoRemoveMarks.remove(overviewMark);
    }

    public void addMark(BasicEditorOverviewMark mark) {
        super.addMark((OverviewMark)mark);
        if (mark.isAutoRemove()) {
            this.autoRemoveMarks.add(mark);
        }
    }

    private class DocumentL
    implements DocumentListener {
        private DocumentL() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            BasicEditorOverview.this.editOffset = e.getOffset();
            BasicEditorOverview.this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            BasicEditorOverview.this.editOffset = e.getOffset();
            BasicEditorOverview.this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class PropertyChangeL
    implements PropertyChangeListener {
        private PropertyChangeL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("code-folding-margin")) {
                if (BasicEditorOverview.this.foldingL.model != null) {
                    BasicEditorOverview.this.foldingL.model.removeCodeFoldingModelListener(BasicEditorOverview.this.foldingL);
                }
                if (BasicEditorOverview.this.foldingL.margin != null) {
                    BasicEditorOverview.this.foldingL.margin.removeCodeExpansionListener(BasicEditorOverview.this.foldingL);
                }
                if (evt.getNewValue() instanceof CodeFoldingMargin) {
                    CodeFoldingMargin codeFoldingMargin = (CodeFoldingMargin)evt.getNewValue();
                    CodeFoldingModel model = codeFoldingMargin.getModel();
                    if (model != null) {
                        model.addCodeFoldingModelListener(BasicEditorOverview.this.foldingL);
                        codeFoldingMargin.addCodeExpansionListener(BasicEditorOverview.this.foldingL);
                        BasicEditorOverview.this.foldingL.model = codeFoldingMargin.getModel();
                        BasicEditorOverview.this.foldingL.margin = codeFoldingMargin;
                    }
                    BasicEditorOverview.this.update();
                }
            } else if (evt.getPropertyName().equals("document")) {
                if (evt.getOldValue() != null) {
                    ((Document)evt.getOldValue()).removeDocumentListener(BasicEditorOverview.this.documentL);
                }
                BasicEditorOverview.this.editor.getDocument().addDocumentListener(BasicEditorOverview.this.documentL);
                BasicEditorOverview.this.update();
            }
        }
    }

    private class CodeExpansionL
    implements CodeFoldingModelListener,
    CodeExpansionListener {
        private CodeFoldingModel model;
        private CodeFoldingMargin margin;

        private CodeExpansionL() {
        }

        @Override
        public void structureChanged(CodeFoldingModelEvent event) {
            BasicEditorOverview.this.update();
        }

        @Override
        public void codeExpanded(CodeExpansionEvent event) {
            BasicEditorOverview.this.update();
        }

        @Override
        public void codeCollapsed(CodeExpansionEvent event) {
            BasicEditorOverview.this.update();
        }
    }

    private class CaretL
    implements CaretListener,
    MultiSelectionListener {
        private Timer caretTimer = new Timer(400, e -> BasicEditorOverview.this.updateCaret());

        private CaretL() {
            this.caretTimer.setRepeats(false);
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            this.caretTimer.restart();
        }

        @Override
        public void multiSelectionChange(MultiSelectionEvent e) {
            this.caretTimer.restart();
        }
    }
}

