/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.dialogs.progress;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.util.WindowUtils;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.DetailDialog;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.dialogs.progress.ProgressPanel;
import oracle.javatools.resource.ProgressBundle;
import oracle.javatools.util.ClosureException;
import oracle.javatools.util.SwingClosure;

abstract class AbstractProgressMonitor {
    private ProgressPanel _panel;
    private ProgressDialog _dialog;
    private Component _parentComponent;
    private String _title;
    private Component _detailContent;
    private int _millisToPopup;
    private boolean _cancellable;
    private boolean _closeOnFinish;
    private boolean _detailVisible;
    private boolean _barVisible;
    private boolean _isModal = false;
    private final Collection<ChangeListener> _cancellationListeners = new ArrayList<ChangeListener>(1);
    private boolean _dialogWasCanceled = false;
    private final Throwable _creationThrowable;

    AbstractProgressMonitor(Component parentComponent, String title, Object message, String note) {
        this._panel = new ProgressPanel(message, note);
        this._parentComponent = parentComponent;
        this._title = title;
        this._cancellable = true;
        this._barVisible = true;
        this._closeOnFinish = true;
        this._creationThrowable = new Throwable();
    }

    public void setCloseOnFinish(boolean closeOnFinish) {
        this._closeOnFinish = closeOnFinish;
    }

    public boolean getCloseOnFinish() {
        return this._closeOnFinish;
    }

    public void start() {
        try {
            new SwingClosure(true){

                @Override
                protected void runImpl() throws Exception {
                    AbstractProgressMonitor.this.startImpl();
                }
            }.run();
        }
        catch (ClosureException ce) {
            ce.printStackTrace();
        }
    }

    protected void startImpl() {
    }

    public void finish() {
        try {
            new SwingClosure(true){

                @Override
                protected void runImpl() throws Exception {
                    AbstractProgressMonitor.this.finishImpl(AbstractProgressMonitor.this._panel != null ? AbstractProgressMonitor.this._panel.getProgressBar() : null);
                    if (AbstractProgressMonitor.this._closeOnFinish) {
                        AbstractProgressMonitor.this.close();
                    } else {
                        AbstractProgressMonitor.this.changeToCloseState();
                    }
                }
            }.run();
        }
        catch (ClosureException ce) {
            ce.printStackTrace();
        }
    }

    public void close() {
        try {
            new SwingClosure(true){

                @Override
                protected void runImpl() throws Exception {
                    AbstractProgressMonitor.this.closeImpl();
                }
            }.run();
        }
        catch (ClosureException ce) {
            ce.printStackTrace();
        }
    }

    public boolean isCanceled() {
        return this._dialog == null ? this._dialogWasCanceled : this._dialog.isCancelled();
    }

    public void addCancellationListener(ChangeListener l) {
        this._cancellationListeners.add(l);
    }

    public void removeCancellationListener(ChangeListener l) {
        this._cancellationListeners.remove(l);
    }

    public void setMillisToPopup(int millisToPopup) {
        this._millisToPopup = millisToPopup;
    }

    public int getMillisToPopup() {
        return this._millisToPopup;
    }

    public void setDetailContent(Component detailContent) {
        this._detailContent = detailContent;
    }

    public Component getDetailContent() {
        return this._detailContent;
    }

    public void setDetailVisible(boolean detailVisible) {
        this._detailVisible = detailVisible;
    }

    public boolean isDetailVisible() {
        return this._detailVisible;
    }

    public void setBarVisible(boolean barVisible) {
        this._barVisible = barVisible;
    }

    public boolean isBarVisible() {
        return this._barVisible;
    }

    public void setCancellable(boolean cancellable) {
        this._cancellable = cancellable;
    }

    public boolean isCancellable() {
        return this._cancellable;
    }

    public void display() {
        try {
            new SwingClosure(true){

                @Override
                protected void runImpl() throws Exception {
                    AbstractProgressMonitor.this.displayImpl();
                }
            }.run();
        }
        catch (ClosureException ce) {
            ce.printStackTrace();
        }
    }

    public Component getComponent() {
        return this._dialog;
    }

    public boolean isCancelled() {
        return this.isCanceled();
    }

    public void uncancel() {
        try {
            new SwingClosure(true){

                @Override
                protected void runImpl() throws Exception {
                    if (AbstractProgressMonitor.this._dialog != null) {
                        AbstractProgressMonitor.this._dialog.setCancelled(false);
                    }
                }
            }.run();
        }
        catch (ClosureException ce) {
            ce.printStackTrace();
        }
    }

    public ProgressPanel getPanel() {
        return this._panel;
    }

    protected JProgressBar createProgressBar() {
        return new JProgressBar();
    }

    protected void displayImpl() {
        this._dialogWasCanceled = false;
        final Runnable dialogLauncherRunnable = new Runnable(){

            @Override
            public void run() {
                ProgressDialog dialog;
                if (AbstractProgressMonitor.this._dialog != null) {
                    return;
                }
                if (AbstractProgressMonitor.this._panel == null) {
                    return;
                }
                try {
                    dialog = AbstractProgressMonitor.this.createDialog();
                }
                catch (NoParentWindowException npwe) {
                    return;
                }
                if (!dialog.getOwner().isVisible()) {
                    return;
                }
                WindowUtils.registerWindow((Window)((Object)dialog));
                AbstractProgressMonitor.this._dialog = dialog;
                try {
                    dialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    Assert.execute((Runnable)new Runnable(){

                        @Override
                        public final void run() {
                            throw new IllegalStateException("IndexOutOfBoundsException occurred in AbstractProgressMonitor. Refer to bug: 8219548", AbstractProgressMonitor.this._creationThrowable);
                        }
                    });
                }
            }
        };
        if (this.isModal()) {
            dialogLauncherRunnable.run();
        } else {
            try {
                new SwingClosure(true){

                    @Override
                    protected void runImpl() throws Exception {
                        dialogLauncherRunnable.run();
                    }
                }.run();
            }
            catch (ClosureException ce) {
                ce.printStackTrace();
            }
        }
    }

    protected void finishImpl(JProgressBar progressBar) {
    }

    protected void closeImpl() {
        if (this._dialog != null) {
            this._dialogWasCanceled = this._dialog.isCancelled();
            this.hideDialog((Dialog)((Object)this._dialog));
            this._dialog = null;
        }
        if (this._panel != null) {
            this._panel = null;
        }
    }

    private ProgressDialog createDialog() throws NoParentWindowException {
        if (this._barVisible) {
            this._panel.setProgressBar(this.createProgressBar());
        }
        ProgressDialog dialog = this.createDialogImpl();
        dialog.setContent(this._panel.getGUI());
        dialog.setDetailContent(this._detailContent);
        dialog.pack();
        dialog.setMinimumSize(dialog.getPreferredSize());
        dialog.setLocationRelativeTo(this._parentComponent);
        return dialog;
    }

    private ProgressDialog createDialogImpl() throws NoParentWindowException {
        Frame f;
        int buttons = 0;
        if (this._cancellable) {
            buttons |= 2;
        }
        if (this._detailContent != null) {
            buttons |= 0x10;
        }
        ProgressDialog dialog = null;
        Dialog d = DialogUtil.getAncestorDialog(this._parentComponent);
        if (d != null) {
            dialog = new ProgressDialog(d, this._title, buttons, this._closeOnFinish);
        }
        if (dialog == null && (f = DialogUtil.getAncestorFrame(this._parentComponent)) != null) {
            dialog = new ProgressDialog(f, this._title, buttons, this._closeOnFinish);
        }
        if (dialog == null) {
            throw new NoParentWindowException();
        }
        dialog.setCancellationListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                ce = new ChangeEvent(AbstractProgressMonitor.this);
                for (ChangeListener l : AbstractProgressMonitor.this._cancellationListeners) {
                    l.stateChanged(ce);
                }
            }
        });
        dialog.setDetailVisible(this._detailVisible);
        dialog.setCloseListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                AbstractProgressMonitor.this.close();
            }
        });
        this.setModal(this._isModal);
        return dialog;
    }

    private void hideDialog(final Dialog d) {
        try {
            new SwingClosure(true){

                @Override
                protected void runImpl() throws Exception {
                    d.dispose();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }.run();
        }
        catch (ClosureException ce) {
            ce.printStackTrace();
        }
    }

    public final boolean isModal() {
        return this._isModal;
    }

    public final void setModal(boolean isModal) {
        this._isModal = isModal;
    }

    private void changeToCloseState() {
        try {
            new SwingClosure(true){

                @Override
                protected void runImpl() throws Exception {
                    if (AbstractProgressMonitor.this._dialog != null) {
                        AbstractProgressMonitor.this._dialog.changeToCloseState();
                    }
                }
            }.run();
        }
        catch (ClosureException ce) {
            ce.printStackTrace();
        }
    }

    private static ResourceBundle getBundle() {
        return ResourceBundle.getBundle(ProgressBundle.class.getName());
    }

    private static final class ProgressDialog
    extends DetailDialog {
        private boolean _cancellable;
        private boolean _cancelled;
        private JButton _customButton;
        private boolean _closeState;
        private ActionListener _closeListener;
        private boolean _disposed;
        private ChangeListener _cancellationListener;

        private ProgressDialog(Dialog dialog, String title, int buttonMask, boolean closeOnFinish) {
            super(dialog, title, ProgressDialog.adjustButtonMask(buttonMask));
            this.initializeDialog(buttonMask, closeOnFinish);
        }

        private ProgressDialog(Frame frame, String title, int buttonMask, boolean closeOnFinish) {
            super(frame, title, ProgressDialog.adjustButtonMask(buttonMask));
            this.initializeDialog(buttonMask, closeOnFinish);
        }

        private final void setCancellationListener(ChangeListener l) {
            this._cancellationListener = l;
        }

        @Override
        public void setContent(Component content) {
            if (content != null) {
                super.setContent(content);
            }
        }

        public void dispose() {
            if (this._disposed) {
                return;
            }
            WindowUtils.unregisterWindow((Window)((Object)this));
            super.dispose();
            this._disposed = true;
        }

        void setCloseListener(ActionListener l) {
            this._closeListener = l;
        }

        public boolean isCancelled() {
            return this._cancelled;
        }

        void setCancelled(final boolean cancelled) {
            if (!this._cancellable) {
                return;
            }
            this._cancelled = cancelled;
            if (this._closeState) {
                return;
            }
            if (this._customButton != null) {
                try {
                    final JButton final_customButton = this._customButton;
                    new SwingClosure(true){

                        @Override
                        protected void runImpl() throws Exception {
                            final_customButton.setEnabled(!cancelled);
                        }
                    }.run();
                }
                catch (ClosureException ce) {
                    ce.printStackTrace();
                }
            }
        }

        void changeToCloseState() {
            if (this._closeState) {
                return;
            }
            if (this._customButton != null) {
                try {
                    final JButton final_customButton = this._customButton;
                    new SwingClosure(true){

                        @Override
                        protected void runImpl() throws Exception {
                            final_customButton.setEnabled(false);
                        }
                    }.run();
                }
                catch (ClosureException ce) {
                    ce.printStackTrace();
                }
            }
            this._closeState = true;
            this.changeToCloseButton();
        }

        protected void dismissDialog(boolean cancelled) {
        }

        private static final int adjustButtonMask(int buttonMask) {
            return (buttonMask & 2) > 0 ? buttonMask ^ 2 : buttonMask;
        }

        private void initializeDialog(int buttonMask, boolean closeOnFinish) {
            this._cancellable = (buttonMask & 2) > 0;
            this.setResizable(true);
            this.setDefaultCloseOperation(0);
            if (!this._cancellable && closeOnFinish) {
                return;
            }
            String _customButtonDisplayName = (String)UIManager.get("OptionPane.cancelButtonText");
            this._customButton = new JButton(_customButtonDisplayName);
            this._customButton.setName(JButton.class.getName() + _customButtonDisplayName);
            this.addCustomButton(this._customButton);
            this._customButton.setEnabled(this._cancellable);
            ActionListener al = new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent e) {
                    if (_closeState) {
                        if (_closeListener != null) {
                            _closeListener.actionPerformed(e);
                        }
                        return;
                    }
                    this.setCancelled(true);
                    if (_cancellationListener != null) {
                        _cancellationListener.stateChanged(null);
                    }
                }
            };
            this._customButton.addActionListener(al);
            KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
            this._customButton.registerKeyboardAction(al, stroke, 0);
        }

        private void changeToCloseButton() {
            try {
                new SwingClosure(true){

                    @Override
                    protected void runImpl() throws Exception {
                        if (_customButton != null) {
                            _customButton.setText(AbstractProgressMonitor.getBundle().getString("CLOSE_BUTTON_TEXT"));
                            _customButton.setMnemonic(AbstractProgressMonitor.getBundle().getString("CLOSE_BUTTON_MNEMONIC").charAt(0));
                            _customButton.setEnabled(true);
                        }
                    }
                }.run();
            }
            catch (ClosureException ce) {
                ce.printStackTrace();
            }
        }
    }

    private final class NoParentWindowException
    extends Exception {
        private NoParentWindowException() {
        }
    }
}

