/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;

class SimpleTransferDataInfo
extends TransferDataInfo {
    private final DataFlavor _flavor;
    private final WeakReference<Object> _data;
    private final Map _metadata;
    private final float _rank;

    SimpleTransferDataInfo(DataFlavor flavor, Object data, float rank, Map metadata) {
        this._flavor = flavor;
        this._data = null != data ? new WeakReference<Object>(data) : null;
        this._rank = rank;
        this._metadata = metadata == null ? Collections.EMPTY_MAP : metadata;
    }

    @Override
    public DataFlavor getDataFlavor() {
        return this._flavor;
    }

    @Override
    public Object getData(FetchMode mode, boolean asReference) throws IOException {
        return null != this._data ? this._data.get() : null;
    }

    @Override
    public float getSuitabilityRank() {
        return this._rank;
    }

    @Override
    public Object getMetadata(Object key) {
        return this._metadata.get(key);
    }

    public String toString() {
        return this._data.toString();
    }
}

