/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;

public class ProgressPanel
extends JPanel {
    private final JLabel _label;
    private final JButton _cancelButton;
    private String _cancelingText = " ";

    public ProgressPanel() {
        this.setLayout(new ProgressLayout());
        this.setBackground((Color)UIManager.get("window"));
        this.setForeground((Color)UIManager.get("textText"));
        this._label = new JLabel(" ");
        this._label.setFocusable(true);
        final JProgressBar progressComponent = new JProgressBar();
        progressComponent.setIndeterminate(true);
        progressComponent.setPreferredSize(new Dimension(250, progressComponent.getPreferredSize().height));
        this._cancelButton = new JButton(UIManager.getString("OptionPane.cancelButtonText"));
        this._cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                progressComponent.setIndeterminate(false);
                ProgressPanel.this._cancelButton.setEnabled(false);
                ProgressPanel.this._label.setText(ProgressPanel.this._cancelingText);
            }
        });
        this.add((Component)this._label, "Left");
        this.add((Component)progressComponent, "Center");
        this.add((Component)this._cancelButton, "Right");
    }

    public String getCancelingText() {
        return this._cancelingText;
    }

    public void setCancelingText(String cancelingText) {
        this._cancelingText = cancelingText;
    }

    public String getLabelText() {
        return this._label.getText();
    }

    public void setLabelText(String text) {
        this._label.setText(text);
    }

    public void addCancelActionListener(ActionListener l) {
        this._cancelButton.addActionListener(l);
    }

    public void removeCancelActionListener(ActionListener l) {
        this._cancelButton.removeActionListener(l);
    }

    public void setCancelEnabled(boolean enabled) {
        this._cancelButton.setEnabled(enabled);
    }

    public boolean isCancelEnabled() {
        return this._cancelButton.isEnabled();
    }

    public static void main(String[] argv) {
        ProgressPanel p = new ProgressPanel();
        p.setLabelText("Compare in progress...");
        JFrame f = new JFrame();
        f.getContentPane().setLayout(new BorderLayout());
        f.add((Component)p, "Center");
        f.setDefaultCloseOperation(3);
        f.setSize(800, 600);
        f.setVisible(true);
    }

    private class ProgressLayout
    implements LayoutManager2 {
        private static final int VERTICAL_SPACING = 5;
        private static final String CENTER = "Center";
        private static final String LEFT = "Left";
        private static final String RIGHT = "Right";
        private final Map<Component, String> _components = new LinkedHashMap<Component, String>();

        private ProgressLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.computeTotalDimensions(parent);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension d = this.computeTotalDimensions(parent);
            int maxWidth = d.width;
            int totalHeight = d.height;
            int currentHeight = 0;
            for (Component c : parent.getComponents()) {
                currentHeight += 5;
                currentHeight += parent.getInsets().top;
                d = c.getPreferredSize();
                int x = 0;
                String position = this._components.get(c);
                if (position == null || position.equals(CENTER)) {
                    c.setSize(maxWidth, d.height);
                    x = (parent.getWidth() - maxWidth) / 2;
                }
                if (position != null && position.equals(LEFT)) {
                    c.setSize(d);
                    x = (parent.getWidth() - maxWidth) / 2;
                }
                if (position != null && position.equals(RIGHT)) {
                    c.setSize(d);
                    x = (parent.getWidth() - maxWidth) / 2 + (maxWidth - d.width);
                }
                c.setLocation(x, (parent.getHeight() - totalHeight) / 2 + currentHeight);
                currentHeight += d.height;
                currentHeight += parent.getInsets().bottom;
            }
        }

        private Dimension computeTotalDimensions(Container parent) {
            Component[] components;
            int maxWidth = 0;
            int totalHeight = 0;
            for (Component c : components = parent.getComponents()) {
                totalHeight += 5;
                totalHeight += parent.getInsets().top;
                Dimension d = c.getPreferredSize();
                totalHeight += d.height;
                totalHeight += parent.getInsets().bottom;
                maxWidth = Math.max(maxWidth, d.width);
            }
            return new Dimension(maxWidth, totalHeight);
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            this._components.put(comp, (String)constraints);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }
}

