/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.naming.Context;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import oracle.javatools.jndi.Names;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.GraphicsUtils;

public class MainWindow
extends JFrame {
    public static final String MAIN_WINDOW_NAME = "main-window";
    private static final boolean USE_OPTIMIZED_GLASSPANE = Boolean.parseBoolean(System.getProperty("useNonRepaintingGlassPane", "true"));
    private static final boolean DEBUG_DRAWING = Boolean.parseBoolean(System.getProperty("debugThemedRootPaneDrawing", "false"));
    private static final boolean DEBUG_PAINTS = Boolean.parseBoolean(System.getProperty("debugPaints", "false"));
    private static final boolean DEBUG_REPAINTS = Boolean.parseBoolean(System.getProperty("debugRepaints", "false"));

    private static void flash(Graphics g, Color color, int x, int y, int width, int height, int delay, int count) {
        g.setXORMode(color);
        for (int i = 0; i < count; ++i) {
            g.fillRect(x, y, width, height);
            Toolkit.getDefaultToolkit().sync();
            long t = System.currentTimeMillis();
            while (System.currentTimeMillis() - t < (long)delay) {
            }
            g.fillRect(x, y, width, height);
            Toolkit.getDefaultToolkit().sync();
        }
        g.setPaintMode();
    }

    public void terminate() {
        System.exit(0);
    }

    public static MainWindow getMainWindow(Context context, int mainWindowID) {
        return (MainWindow)Names.lookup((Context)context, (String)MainWindow.getMainWindowName(mainWindowID));
    }

    public static void setMainWindow(Context context, MainWindow mainWindow, int mainWindowID) {
        Names.bind((Context)context, (String)MainWindow.getMainWindowName(mainWindowID), (Object)mainWindow);
    }

    private static String getMainWindowName(int id) {
        return MAIN_WINDOW_NAME + id;
    }

    public void preInitialize() {
        ThemedRootPane rootpane = new ThemedRootPane();
        rootpane.setName("ThemedRootPane");
        if (Themes.isThemed()) {
            ((JComponent)rootpane.getContentPane()).setOpaque(false);
            rootpane.setOpaque(true);
        }
        super.setRootPane(rootpane);
        if (DEBUG_PAINTS || DEBUG_REPAINTS) {
            RepaintManager.setCurrentManager(new DebuggingRepaintManager());
        }
    }

    protected void initialize() {
        super.setDefaultCloseOperation(0);
        this.setTitle(this.getMainTitle());
        this.setIconImages(this.getBrandingIcons());
        this.addWindowListener(this.getWindowListener());
        this.initGeometry();
        this.loadMainMenu();
    }

    protected String getMainTitle() {
        return null;
    }

    protected Image getMainIcon() {
        return null;
    }

    protected WindowListener getWindowListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.terminate();
            }
        };
    }

    protected void initGeometry() {
        this.setBounds(new Rectangle(0, 0, 600, 450));
        GraphicsUtils.centerWindowOnScreen((Window)this);
    }

    protected void loadMainMenu() {
    }

    protected List<? extends Image> getBrandingIcons() {
        return new ArrayList();
    }

    private class ThemedRootPane
    extends JRootPane {
        private Painter _painter;

        public ThemedRootPane() {
            if (DEBUG_DRAWING) {
                RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
            }
        }

        @Override
        protected Component createGlassPane() {
            if (!USE_OPTIMIZED_GLASSPANE) {
                return super.createGlassPane();
            }
            JPanel c = new JPanel(){

                @Override
                public void repaint() {
                }

                @Override
                public void repaint(int x, int y, int width, int height) {
                }

                @Override
                public void repaint(long tm) {
                }

                @Override
                public void repaint(long tm, int x, int y, int width, int height) {
                }

                @Override
                public void setVisible(boolean aFlag) {
                    if (aFlag != this.isVisible()) {
                        if (aFlag) {
                            this.show();
                        } else {
                            this.hide();
                        }
                    }
                }
            };
            c.setName(this.getName() + ".glassPane");
            c.setVisible(false);
            c.setOpaque(false);
            return c;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this._painter == null && Themes.isThemed()) {
                Component component = SwingUtilities.getRoot(this);
                if (component != null && component.getClass().getName().contains("NbMainWindow")) {
                    this._painter = Themes.getActiveTheme().getStateProperties("mainwindow", "normal").getPainter("bg");
                } else if (component != null) {
                    this._painter = Themes.getActiveTheme().getStateProperties("oldmainwindow", "normal").getPainter("bg");
                }
            }
            if (DEBUG_DRAWING) {
                MainWindow.flash(g, Color.red, 0, 0, this.getWidth(), this.getHeight(), 250, 1);
            }
            if (this._painter != null) {
                this._painter.paint(g, 0, 0, this.getWidth(), this.getHeight());
            } else {
                super.paintComponent(g);
            }
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
            Graphics g;
            super.repaint(tm, x, y, width, height);
            if (DEBUG_DRAWING && (g = this.getGraphics()) != null) {
                MainWindow.flash(g, Color.blue, x, y, width, height, 250, 1);
            }
        }
    }

    private final class DebuggingRepaintManager
    extends RepaintManager {
        private Rectangle tmp = new Rectangle();

        private DebuggingRepaintManager() {
        }

        @Override
        public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
            super.addDirtyRegion(c, x, y, w, h);
            if (DEBUG_REPAINTS) {
                if (w <= 0 || h <= 0 || c == null) {
                    return;
                }
                if (c.getWidth() <= 0 || c.getHeight() <= 0) {
                    return;
                }
                this.flashComponent(c, Color.blue, x, y, w, h);
            }
        }

        @Override
        public void paintDirtyRegions() {
            try {
                if (DEBUG_PAINTS) {
                    this.paintDirtyRegionsImpl();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                super.paintDirtyRegions();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintDirtyRegionsImpl() throws Exception {
            JComponent dirtyComponent;
            Hashtable tmpDirtyComponents;
            Field dirtyComponentsField = RepaintManager.class.getDeclaredField("dirtyComponents");
            dirtyComponentsField.setAccessible(true);
            DebuggingRepaintManager debuggingRepaintManager = this;
            synchronized (debuggingRepaintManager) {
                tmpDirtyComponents = (Hashtable)((Hashtable)dirtyComponentsField.get(this)).clone();
            }
            int count = tmpDirtyComponents.size();
            if (count == 0) {
                return;
            }
            int localBoundsX = 0;
            int localBoundsY = 0;
            int localBoundsH = 0;
            int localBoundsW = 0;
            Vector roots = new Vector(count);
            Enumeration keys = tmpDirtyComponents.keys();
            while (keys.hasMoreElements()) {
                dirtyComponent = (JComponent)keys.nextElement();
                this.collectDirtyComponents(tmpDirtyComponents, dirtyComponent, roots);
            }
            count = roots.size();
            for (int i = 0; i < count; ++i) {
                dirtyComponent = (JComponent)roots.elementAt(i);
                Rectangle rect = (Rectangle)tmpDirtyComponents.get(dirtyComponent);
                localBoundsH = dirtyComponent.getHeight();
                localBoundsW = dirtyComponent.getWidth();
                SwingUtilities.computeIntersection(localBoundsX, localBoundsY, localBoundsW, localBoundsH, rect);
                this.flashComponent(dirtyComponent, Color.red, rect.x, rect.y, rect.width, rect.height);
            }
        }

        private void collectDirtyComponents(Hashtable dirtyComponents, JComponent dirtyComponent, Vector roots) {
            Container parent;
            Container rootDirtyComponent = dirtyComponent;
            Container component = rootDirtyComponent;
            int x = dirtyComponent.getX();
            int y = dirtyComponent.getY();
            int w = dirtyComponent.getWidth();
            int h = dirtyComponent.getHeight();
            int rootDx = 0;
            int dx = 0;
            int rootDy = 0;
            int dy = 0;
            this.tmp.setBounds((Rectangle)dirtyComponents.get(dirtyComponent));
            SwingUtilities.computeIntersection(0, 0, w, h, this.tmp);
            if (this.tmp.isEmpty()) {
                return;
            }
            while ((parent = component.getParent()) != null && parent instanceof JComponent) {
                component = parent;
                dx += x;
                dy += y;
                this.tmp.setLocation(this.tmp.x + x, this.tmp.y + y);
                x = component.getX();
                y = component.getY();
                w = component.getWidth();
                h = component.getHeight();
                this.tmp = SwingUtilities.computeIntersection(0, 0, w, h, this.tmp);
                if (this.tmp.isEmpty()) {
                    return;
                }
                if (dirtyComponents.get(component) == null) continue;
                rootDirtyComponent = component;
                rootDx = dx;
                rootDy = dy;
            }
            if (dirtyComponent != rootDirtyComponent) {
                this.tmp.setLocation(this.tmp.x + rootDx - dx, this.tmp.y + rootDy - dy);
                Rectangle r = (Rectangle)dirtyComponents.get(rootDirtyComponent);
                SwingUtilities.computeUnion(this.tmp.x, this.tmp.y, this.tmp.width, this.tmp.height, r);
            }
            if (!roots.contains(rootDirtyComponent)) {
                roots.addElement(rootDirtyComponent);
            }
        }

        private void flashComponent(JComponent component, Color color, int x, int y, int width, int height) {
            Graphics g;
            if (component.isShowing() && (g = MainWindow.this.getGraphics()) != null) {
                Point componentsLocationOnScreen;
                g = g.create();
                g.setClip(null);
                Point windowsLocation = MainWindow.this.getLocation();
                if (windowsLocation != null) {
                    x -= windowsLocation.x;
                    y -= windowsLocation.y;
                }
                if ((componentsLocationOnScreen = component.getLocationOnScreen()) != null) {
                    x += componentsLocationOnScreen.x;
                    y += componentsLocationOnScreen.y;
                }
                MainWindow.flash(g, color, x, y, width, height, 75, 1);
            }
        }
    }
}

