/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.ObjectFactory;

public class ByteArrayFactory
extends ObjectFactory {
    public static final ByteArrayFactory BYTE_ARRAY_FACTORY = new ByteArrayFactory();
    private static final byte BYTE_ARRAY_CODE = -70;

    private ByteArrayFactory() {
    }

    @Override
    public byte getObjectCode() {
        return -70;
    }

    @Override
    public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
        int len = input.readInt();
        byte[] array = new byte[len];
        input.readFully(array);
        return array;
    }

    @Override
    public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
        byte[] array = (byte[])object;
        int len = array.length;
        output.writeInt(len);
        output.write(array);
    }
}

