/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.security.redaction.generator;

import java.sql.Connection;
import java.util.Map;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.RaptorVersionTracker;
import oracle.dbtools.raptor.utils.templates.TemplateSupport;
import oracle.dbtools.util.Logger;
import oracle.javatools.db.DBException;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

public final class RedactCodeGenerator {
    private static final String TEMPLATE_BASE_NAME = "DBMS_REDACT";
    private static final String TEMPLATE_PATH = "oracle/dbtools/security/redaction/generator/templates";

    private RedactCodeGenerator() {
    }

    public static RedactCodeGenerator getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private STGroup getTemplateGroup(String string) {
        return TemplatesHolder.getTemplateGroup(new Version(string));
    }

    public ST getTemplate(String string, String string2) {
        try {
            STGroup sTGroup = this.getTemplateGroup(string);
            if (sTGroup != null) {
                ST sT = sTGroup.getInstanceOf(string2);
                return sT;
            }
        }
        catch (Throwable throwable) {
            Logger.severe(RedactCodeGenerator.class, (String)throwable.getLocalizedMessage(), (Throwable)throwable);
        }
        return null;
    }

    public String generateForConnection(String string, String string2, Map<String, Object> map) {
        try {
            return this.generate(Connections.getInstance().getConnection(string), string2, map);
        }
        catch (DBException dBException) {
            return null;
        }
    }

    public String generate(Connection connection, String string, Map<String, Object> map) {
        String string2 = RaptorVersionTracker.getDbVersion((Connection)connection).toCanonicalString();
        return this.generate(string2, string, map);
    }

    public String generate(String string, String string2, Map<String, Object> map) {
        String string3 = null;
        try {
            ST sT = this.getTemplate(string, string2);
            if (sT != null) {
                if (map != null) {
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        sT.add(entry.getKey(), entry.getValue());
                    }
                }
                string3 = sT.render();
                if (string.startsWith("10")) {
                    string3 = string3.replaceAll("\r\n", "\n");
                }
            }
        }
        catch (Throwable throwable) {
            Logger.severe(RedactCodeGenerator.class, (String)throwable.getLocalizedMessage(), (Throwable)throwable);
        }
        return string3;
    }

    public String getQuery(String string, String string2) {
        STGroup sTGroup = this.getTemplateGroup(string2);
        ST sT = sTGroup.getInstanceOf(string);
        if (sT == null) {
            return null;
        }
        return sT.render();
    }

    private static class InstanceHolder {
        private static final RedactCodeGenerator INSTANCE = new RedactCodeGenerator();

        private InstanceHolder() {
        }
    }

    private static class TemplatesHolder
    extends TemplateSupport {
        private static final TemplatesHolder INSTANCE = new TemplatesHolder();

        private static STGroup getTemplateGroup(Version version) {
            return INSTANCE.findTemplateGroup(version);
        }

        private TemplatesHolder() {
            super(RedactCodeGenerator.TEMPLATE_PATH, RedactCodeGenerator.TEMPLATE_BASE_NAME, RedactCodeGenerator.class.getClassLoader());
        }

        static {
            try {
                INSTANCE.initVersions();
            }
            catch (Exception exception) {
                Logger.severe(RedactCodeGenerator.class, (String)"Unexpected error loading templates", (Throwable)exception);
            }
        }
    }
}

